/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.DefaultErrorHandler;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.xml.sax.SAXException;

public class ErrorDispatcher {
    private ErrorHandler errHandler = new DefaultErrorHandler();
    private boolean jspcMode = false;

    public ErrorDispatcher(boolean bl) {
        this.jspcMode = bl;
    }

    public void jspError(String string) throws JasperException {
        this.dispatch(null, string, null, null);
    }

    public void jspError(Mark mark, String string) throws JasperException {
        this.dispatch(mark, string, null, null);
    }

    public void jspError(Node node, String string) throws JasperException {
        this.dispatch(node.getStart(), string, null, null);
    }

    public void jspError(String string, String string2) throws JasperException {
        this.dispatch(null, string, new Object[]{string2}, null);
    }

    public void jspError(Mark mark, String string, String string2) throws JasperException {
        this.dispatch(mark, string, new Object[]{string2}, null);
    }

    public void jspError(Node node, String string, String string2) throws JasperException {
        this.dispatch(node.getStart(), string, new Object[]{string2}, null);
    }

    public void jspError(String string, String string2, String string3) throws JasperException {
        this.dispatch(null, string, new Object[]{string2, string3}, null);
    }

    public void jspError(String string, String string2, String string3, String string4) throws JasperException {
        this.dispatch(null, string, new Object[]{string2, string3, string4}, null);
    }

    public void jspError(Mark mark, String string, String string2, String string3) throws JasperException {
        this.dispatch(mark, string, new Object[]{string2, string3}, null);
    }

    public void jspError(Mark mark, String string, String string2, String string3, String string4) throws JasperException {
        this.dispatch(mark, string, new Object[]{string2, string3, string4}, null);
    }

    public void jspError(Node node, String string, String string2, String string3) throws JasperException {
        this.dispatch(node.getStart(), string, new Object[]{string2, string3}, null);
    }

    public void jspError(Node node, String string, String string2, String string3, String string4) throws JasperException {
        this.dispatch(node.getStart(), string, new Object[]{string2, string3, string4}, null);
    }

    public void jspError(Exception exception) throws JasperException {
        this.dispatch(null, null, null, exception);
    }

    public void jspError(Exception exception, String string, String string2) throws JasperException {
        this.dispatch(null, string, new Object[]{string2}, exception);
    }

    @Deprecated
    public void jspError(String string, String string2, Exception exception) throws JasperException {
        this.jspError(exception, string, string2);
    }

    public void jspError(Mark mark, Exception exception, String string, String ... stringArray) throws JasperException {
        this.dispatch(mark, string, stringArray, exception);
    }

    public void jspError(Node node, Exception exception, String string, String string2) throws JasperException {
        this.dispatch(node.getStart(), string, new Object[]{string2}, exception);
    }

    @Deprecated
    public void jspError(Node node, String string, String string2, Exception exception) throws JasperException {
        this.jspError(node, exception, string, string2);
    }

    public static JavacErrorDetail[] parseJavacErrors(String string, String string2, Node.Nodes nodes) throws JasperException, IOException {
        return ErrorDispatcher.parseJavacMessage(string, string2, nodes);
    }

    public void javacError(JavacErrorDetail[] javacErrorDetailArray) throws JasperException {
        this.errHandler.javacError(javacErrorDetailArray);
    }

    public void javacError(String string, Exception exception) throws JasperException {
        this.errHandler.javacError(string, exception);
    }

    private void dispatch(Mark mark, String string, Object[] objectArray, Exception exception) throws JasperException {
        String string2 = null;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        if (string != null) {
            string3 = Localizer.getMessage(string, objectArray);
        } else if (exception != null) {
            string3 = exception.getMessage();
        }
        if (mark != null) {
            if (this.jspcMode) {
                try {
                    string2 = mark.getURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    string2 = mark.getFile();
                }
            } else {
                string2 = mark.getFile();
            }
            n = mark.getLineNumber();
            n2 = mark.getColumnNumber();
            bl = true;
        }
        Exception exception2 = exception;
        if (exception instanceof SAXException && ((SAXException)exception).getException() != null) {
            exception2 = ((SAXException)exception).getException();
        }
        if (bl) {
            this.errHandler.jspError(string2, n, n2, string3, exception2);
        } else {
            this.errHandler.jspError(string3, exception2);
        }
    }

    private static JavacErrorDetail[] parseJavacMessage(String string, String string2, Node.Nodes nodes) throws IOException, JasperException {
        ArrayList<JavacErrorDetail> arrayList = new ArrayList<JavacErrorDetail>();
        StringBuilder stringBuilder = null;
        int n = -1;
        JavacErrorDetail javacErrorDetail = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            int n2 = string3.indexOf(58, 2);
            int n3 = string3.indexOf(58, n2 + 1);
            if (n2 >= 0 && n3 >= 0) {
                if (javacErrorDetail != null) {
                    arrayList.add(javacErrorDetail);
                }
                String string4 = string3.substring(n2 + 1, n3);
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                stringBuilder = new StringBuilder();
                javacErrorDetail = ErrorDispatcher.createJavacError(string2, nodes, stringBuilder, n);
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(string3);
            stringBuilder.append(Constants.NEWLINE);
        }
        if (javacErrorDetail != null) {
            arrayList.add(javacErrorDetail);
        }
        bufferedReader.close();
        JavacErrorDetail[] javacErrorDetailArray = null;
        if (arrayList.size() > 0) {
            javacErrorDetailArray = new JavacErrorDetail[arrayList.size()];
            arrayList.toArray(javacErrorDetailArray);
        }
        return javacErrorDetailArray;
    }

    public static JavacErrorDetail createJavacError(String string, Node.Nodes nodes, StringBuilder stringBuilder, int n) throws JasperException {
        return ErrorDispatcher.createJavacError(string, nodes, stringBuilder, n, null);
    }

    public static JavacErrorDetail createJavacError(String string, Node.Nodes nodes, StringBuilder stringBuilder, int n, JspCompilationContext jspCompilationContext) throws JasperException {
        ErrorVisitor errorVisitor = new ErrorVisitor(n);
        nodes.visit(errorVisitor);
        Node node = errorVisitor.getJspSourceNode();
        JavacErrorDetail javacErrorDetail = node != null && node.getStart() != null ? (errorVisitor.getJspSourceNode() instanceof Node.Scriptlet || errorVisitor.getJspSourceNode() instanceof Node.Declaration ? new JavacErrorDetail(string, n, node.getStart().getFile(), node.getStart().getLineNumber() + n - errorVisitor.getJspSourceNode().getBeginJavaLine(), stringBuilder, jspCompilationContext) : new JavacErrorDetail(string, n, node.getStart().getFile(), node.getStart().getLineNumber(), stringBuilder, jspCompilationContext)) : new JavacErrorDetail(string, n, stringBuilder);
        return javacErrorDetail;
    }

    static class ErrorVisitor
    extends Node.Visitor {
        private int lineNum;
        Node found;

        public ErrorVisitor(int n) {
            this.lineNum = n;
        }

        @Override
        public void doVisit(Node node) throws JasperException {
            if (this.lineNum >= node.getBeginJavaLine() && this.lineNum < node.getEndJavaLine()) {
                this.found = node;
            }
        }

        public Node getJspSourceNode() {
            return this.found;
        }
    }
}

