/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.util.LinkedList;
import java.util.ListIterator;

public class CommandHistory {
    private final LinkedList<String> commandHistory = new LinkedList();
    private final int maxHistorySize;
    private ListIterator<String> iterator = null;
    private boolean iteratorAsc;

    public CommandHistory(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize < 0 ? 0 : maxHistorySize;
        this.commandHistory.addLast("");
    }

    public void addCommand(String command) {
        if (this.maxHistorySize == 0) {
            return;
        }
        this.commandHistory.removeLast();
        if (this.commandHistory.isEmpty() || !this.commandHistory.getLast().equals(command)) {
            if (this.commandHistory.size() >= this.maxHistorySize) {
                this.commandHistory.removeFirst();
            }
            this.commandHistory.addLast(command);
        }
        this.commandHistory.addLast("");
        this.iterator = null;
    }

    public boolean hasNextCommand() {
        if (this.iterator == null) {
            return false;
        }
        if (!this.iteratorAsc) {
            this.iterator.next();
            this.iteratorAsc = true;
        }
        return this.iterator.hasNext();
    }

    public String getNextCommand() {
        if (!this.hasNextCommand()) {
            return null;
        }
        String next = this.iterator.next();
        if (this.iterator.nextIndex() == this.commandHistory.size()) {
            this.iterator.set("");
        }
        return next;
    }

    public boolean hasPreviousCommand() {
        if (this.iterator == null) {
            return this.commandHistory.size() > 1;
        }
        if (this.iteratorAsc) {
            this.iterator.previous();
            this.iteratorAsc = false;
        }
        return this.iterator.hasPrevious();
    }

    public String getPreviousCommand(String currentCommand) {
        if (!this.hasPreviousCommand()) {
            return null;
        }
        if (this.iterator == null) {
            this.iterator = this.commandHistory.listIterator(this.commandHistory.size());
            this.iterator.previous();
            this.iteratorAsc = false;
        }
        if (this.iterator.nextIndex() == this.commandHistory.size() - 1) {
            this.iterator.set(currentCommand == null ? "" : currentCommand);
        }
        return this.iterator.previous();
    }

    public String resetHistoryLocation() {
        this.iterator = null;
        return this.commandHistory.set(this.commandHistory.size() - 1, "");
    }

    public void clear() {
        this.iterator = null;
        this.commandHistory.clear();
        this.commandHistory.addLast("");
    }
}

