/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import processing.app.packages.UserLibrary;
import processing.app.packages.UserLibraryFolder;

public class UserLibraryPriorityComparator
implements Comparator<UserLibrary> {
    private static final Map<UserLibraryFolder.Location, Integer> priorities = new HashMap<UserLibraryFolder.Location, Integer>();
    private String arch;

    public UserLibraryPriorityComparator(String currentArch) {
        this.arch = currentArch;
    }

    private boolean hasArchitecturePriority(UserLibrary x) {
        return x.getArchitectures().contains(this.arch);
    }

    public int priority(UserLibrary l) {
        int priority = priorities.get((Object)l.getLocation());
        if (this.hasArchitecturePriority(l)) {
            priority += 10;
        }
        return priority;
    }

    @Override
    public int compare(UserLibrary x, UserLibrary y) {
        if (!x.getName().equals(y.getName())) {
            throw new IllegalArgumentException("The compared libraries must have the same name");
        }
        return this.priority(x) - this.priority(y);
    }

    static {
        priorities.put(UserLibraryFolder.Location.SKETCHBOOK, 4);
        priorities.put(UserLibraryFolder.Location.CORE, 3);
        priorities.put(UserLibraryFolder.Location.REFERENCED_CORE, 2);
        priorities.put(UserLibraryFolder.Location.IDE_BUILTIN, 1);
    }
}

