/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.jscomp.ZipEntryReader;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SourceFile
implements StaticSourceFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UTF8_BOM = "\ufeff";
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private StaticSourceFile.SourceKind kind;
    private String originalPath = null;
    private transient int[] lineOffsets = null;
    private transient String code = null;
    private static final String BANG_SLASH = "!/";

    public SourceFile(String fileName, StaticSourceFile.SourceKind kind) {
        if (Strings.isNullOrEmpty(fileName)) {
            throw new IllegalArgumentException("a source must have a name");
        }
        this.fileName = !"/".equals(File.separator) ? fileName.replace(File.separator, "/") : fileName;
        this.kind = kind;
    }

    @Override
    public int getLineOffset(int lineno) {
        this.findLineOffsets();
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        this.findLineOffsets();
        return this.lineOffsets.length;
    }

    private void findLineOffsets() {
        if (this.lineOffsets != null) {
            return;
        }
        try {
            String[] sourceLines = this.getCode().split("\n", -1);
            this.lineOffsets = new int[sourceLines.length];
            for (int ii = 1; ii < sourceLines.length; ++ii) {
                this.lineOffsets[ii] = this.lineOffsets[ii - 1] + sourceLines[ii - 1].length() + 1;
            }
        }
        catch (IOException e) {
            this.lineOffsets = new int[1];
            this.lineOffsets[0] = 0;
        }
    }

    private void resetLineOffsets() {
        this.lineOffsets = null;
    }

    public String getCode() throws IOException {
        return this.code;
    }

    @GwtIncompatible(value="java.io.Reader")
    public Reader getCodeReader() throws IOException {
        return new StringReader(this.getCode());
    }

    void setCode(String sourceCode) {
        this.code = sourceCode != null && sourceCode.startsWith(UTF8_BOM) ? sourceCode.substring(UTF8_BOM.length()) : sourceCode;
        this.resetLineOffsets();
    }

    public String getOriginalPath() {
        return this.originalPath != null ? this.originalPath : this.fileName;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public void clearCachedSource() {
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public StaticSourceFile.SourceKind getKind() {
        return this.kind;
    }

    public void setKind(StaticSourceFile.SourceKind kind) {
        this.kind = kind;
    }

    @Override
    public int getLineOfOffset(int offset) {
        this.findLineOffsets();
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            return search + 1;
        }
        int insertionPoint = -1 * (search + 1);
        return Math.min(insertionPoint - 1, this.lineOffsets.length - 1) + 1;
    }

    @Override
    public int getColumnOfOffset(int offset) {
        int line = this.getLineOfOffset(offset);
        return offset - this.lineOffsets[line - 1];
    }

    public String getLine(int lineNumber) {
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        if (js.indexOf(10, pos) == -1) {
            if (pos >= js.length()) {
                return null;
            }
            return js.substring(pos);
        }
        return js.substring(pos, js.indexOf(10, pos));
    }

    public Region getLines(int lineNumber, int length) {
        int endLine;
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if (length <= 0) {
            length = 1;
        }
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        if (pos == js.length()) {
            return new SimpleRegion(lineNumber, lineNumber, "");
        }
        int endChar = pos;
        for (endLine = lineNumber; endChar < pos + length && endLine <= this.lineOffsets.length; ++endLine) {
            endChar = endLine < this.lineOffsets.length ? this.lineOffsets[endLine] : js.length();
        }
        if (js.charAt(endChar - 1) == '\n') {
            return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar - 1));
        }
        return new SimpleRegion(lineNumber, endLine, js.substring(pos, endChar));
    }

    public Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    @GwtIncompatible(value="fromZipInput")
    public static List<SourceFile> fromZipFile(String zipName, Charset inputCharset) throws IOException {
        try (FileInputStream input = new FileInputStream(zipName);){
            List<SourceFile> list = SourceFile.fromZipInput(zipName, input, inputCharset);
            return list;
        }
    }

    @GwtIncompatible(value="java.util.zip.ZipInputStream")
    public static List<SourceFile> fromZipInput(String zipName, InputStream input, Charset inputCharset) throws IOException {
        String absoluteZipPath = new File(zipName).getAbsolutePath();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        try (ZipInputStream in = new ZipInputStream(input, inputCharset);){
            ZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!entryName.endsWith(".js")) continue;
                sourceFiles.add(SourceFile.fromZipEntry(zipName, absoluteZipPath, entryName, inputCharset));
            }
        }
        return sourceFiles;
    }

    private static boolean isZipEntry(String path) {
        return path.contains(".zip!" + File.separator) && (path.endsWith(".js") || path.endsWith(".js.map"));
    }

    @GwtIncompatible(value="java.io.File")
    private static SourceFile fromZipEntry(String zipURL, Charset inputCharset, StaticSourceFile.SourceKind kind) {
        Preconditions.checkArgument(SourceFile.isZipEntry(zipURL));
        String[] components = zipURL.split(Pattern.quote(BANG_SLASH.replace("/", File.separator)));
        try {
            String zipPath = components[0];
            String relativePath = components[1];
            return SourceFile.fromZipEntry(zipPath, zipPath, relativePath, inputCharset, kind);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromZipEntry(String originalZipPath, String absoluteZipPath, String entryPath, Charset inputCharset) throws MalformedURLException {
        return SourceFile.fromZipEntry(originalZipPath, absoluteZipPath, entryPath, inputCharset, StaticSourceFile.SourceKind.STRONG);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromZipEntry(String originalZipPath, String absoluteZipPath, String entryPath, Charset inputCharset, StaticSourceFile.SourceKind kind) throws MalformedURLException {
        return SourceFile.builder().withKind(kind).withCharset(inputCharset).withOriginalPath(originalZipPath + BANG_SLASH + entryPath).buildFromZipEntry(new ZipEntryReader(absoluteZipPath, entryPath.replace(File.separator, "/")));
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName, Charset charset, StaticSourceFile.SourceKind kind) {
        return SourceFile.builder().withKind(kind).withCharset(charset).buildFromFile(fileName);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName, Charset charset) {
        return SourceFile.fromFile(fileName, charset, StaticSourceFile.SourceKind.STRONG);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromFile(String fileName) {
        return SourceFile.fromFile(fileName, StandardCharsets.UTF_8);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromPath(Path path, Charset charset, StaticSourceFile.SourceKind kind) {
        return SourceFile.builder().withKind(kind).withCharset(charset).buildFromPath(path);
    }

    @GwtIncompatible(value="java.io.File")
    public static SourceFile fromPath(Path path, Charset charset) {
        return SourceFile.fromPath(path, charset, StaticSourceFile.SourceKind.STRONG);
    }

    public static SourceFile fromCode(String fileName, String code, StaticSourceFile.SourceKind kind) {
        return SourceFile.builder().withKind(kind).buildFromCode(fileName, code);
    }

    public static SourceFile fromCode(String fileName, String code) {
        return SourceFile.fromCode(fileName, code, StaticSourceFile.SourceKind.STRONG);
    }

    @Deprecated
    @GwtIncompatible(value="java.io.InputStream")
    public static SourceFile fromInputStream(String fileName, InputStream s) throws IOException {
        return SourceFile.builder().buildFromInputStream(fileName, s);
    }

    @GwtIncompatible(value="java.io.InputStream")
    public static SourceFile fromInputStream(String fileName, InputStream s, Charset charset) throws IOException {
        return SourceFile.builder().withCharset(charset).buildFromInputStream(fileName, s);
    }

    @GwtIncompatible(value="java.io.Reader")
    public static SourceFile fromReader(String fileName, Reader r) throws IOException {
        return SourceFile.builder().buildFromReader(fileName, r);
    }

    public static SourceFile fromGenerator(String fileName, Generator generator) {
        return SourceFile.builder().buildFromGenerator(fileName, generator);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void restoreFrom(SourceFile sourceFile) {
        this.code = sourceFile.code;
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.code = "<UNAVAILABLE>";
    }

    @GwtIncompatible(value="java.io.File")
    private static class AtZip
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final ZipEntryReader zipEntryReader;
        private transient Charset inputCharset;

        AtZip(ZipEntryReader zipEntryReader, String originalPath, Charset c, StaticSourceFile.SourceKind kind) {
            super(originalPath, kind);
            this.inputCharset = c;
            this.zipEntryReader = zipEntryReader;
            this.setOriginalPath(originalPath);
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = this.zipEntryReader.read(this.inputCharset);
                super.setCode(cachedCode);
                cachedCode = super.getCode();
            }
            return cachedCode;
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return this.zipEntryReader.getReader(this.inputCharset);
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream os) throws Exception {
            os.defaultWriteObject();
            os.writeObject(this.inputCharset.name());
        }

        @Override
        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.inputCharset = Charset.forName((String)in.readObject());
            super.setCode(null);
        }
    }

    @GwtIncompatible(value="com.google.common.io.CharStreams")
    private static class OnDisk
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private transient Path path;
        private transient Charset inputCharset;

        OnDisk(Path path, String originalPath, Charset c, StaticSourceFile.SourceKind kind) {
            super(path.toString(), kind);
            this.path = path;
            this.inputCharset = c;
            this.setOriginalPath(originalPath);
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                try (Reader r = this.getCodeReader();){
                    cachedCode = CharStreams.toString(r);
                }
                catch (MalformedInputException e) {
                    throw new IOException("Failed to read: " + this.path + ", is this input UTF-8 encoded?", e);
                }
                super.setCode(cachedCode);
                cachedCode = super.getCode();
            }
            return cachedCode;
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return Files.newBufferedReader(this.path, this.inputCharset);
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream out) throws Exception {
            out.defaultWriteObject();
            out.writeObject(this.inputCharset.name());
            out.writeObject(this.path.toUri());
        }

        @Override
        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.inputCharset = Charset.forName((String)in.readObject());
            this.path = Paths.get((URI)in.readObject());
            super.setCode(null);
        }
    }

    private static class Generated
    extends SourceFile {
        private transient Generator generator;

        Generated(String fileName, String originalPath, Generator generator, StaticSourceFile.SourceKind kind) {
            super(fileName, kind);
            super.setOriginalPath(originalPath);
            this.generator = generator;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = this.generator.getCode();
                super.setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public void clearCachedSource() {
            super.setCode(null);
        }

        @Override
        public void restoreFrom(SourceFile sourceFile) {
            super.restoreFrom(sourceFile);
            this.generator = ((Generated)sourceFile).generator;
        }
    }

    private static class Preloaded
    extends SourceFile {
        private static final long serialVersionUID = 2L;

        Preloaded(String fileName, String originalPath, String code, StaticSourceFile.SourceKind kind) {
            super(fileName, kind);
            super.setOriginalPath(originalPath);
            super.setCode(code);
        }

        @GwtIncompatible(value="ObjectOutputStream")
        private void writeObject(ObjectOutputStream os) throws Exception {
            os.defaultWriteObject();
            os.writeObject(this.getCode());
        }

        @Override
        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            super.setCode((String)in.readObject());
        }
    }

    public static class Builder {
        private StaticSourceFile.SourceKind kind = StaticSourceFile.SourceKind.STRONG;
        private Charset charset = StandardCharsets.UTF_8;
        private String originalPath = null;

        public Builder withKind(StaticSourceFile.SourceKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withOriginalPath(String originalPath) {
            this.originalPath = originalPath;
            return this;
        }

        @GwtIncompatible(value="java.io.File")
        public SourceFile buildFromFile(String fileName) {
            return this.buildFromPath(Paths.get(fileName, new String[0]));
        }

        @GwtIncompatible(value="java.io.File")
        public SourceFile buildFromPath(Path path) {
            Preconditions.checkNotNull(path);
            Preconditions.checkNotNull(this.charset);
            if (SourceFile.isZipEntry(path.toString())) {
                return SourceFile.fromZipEntry(path.toString(), this.charset, this.kind);
            }
            return new OnDisk(path, this.originalPath, this.charset, this.kind);
        }

        @GwtIncompatible(value="java.io.File")
        public SourceFile buildFromZipEntry(ZipEntryReader zipEntryReader) {
            Preconditions.checkNotNull(zipEntryReader);
            Preconditions.checkNotNull(this.charset);
            return new AtZip(zipEntryReader, this.originalPath, this.charset, this.kind);
        }

        public SourceFile buildFromCode(String fileName, String code) {
            return new Preloaded(fileName, this.originalPath, code, this.kind);
        }

        @GwtIncompatible(value="java.io.InputStream")
        public SourceFile buildFromInputStream(String fileName, InputStream s) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString(new InputStreamReader(s, this.charset)));
        }

        @GwtIncompatible(value="java.io.Reader")
        public SourceFile buildFromReader(String fileName, Reader r) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString(r));
        }

        public SourceFile buildFromGenerator(String fileName, Generator generator) {
            return new Generated(fileName, this.originalPath, generator, this.kind);
        }
    }

    public static interface Generator {
        public String getCode();
    }
}

