/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class GenericToolbar
extends JToolBar {
    private static int PREFERRED_HEIGHT = -1;

    public GenericToolbar() {
        this.tweak();
    }

    public GenericToolbar(int n) {
        super(n);
        this.tweak();
    }

    public GenericToolbar(String string) {
        super(string);
        this.tweak();
    }

    public GenericToolbar(String string, int n) {
        super(string, n);
        this.tweak();
    }

    private void tweak() {
        if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
            int n = this.getOrientation() == 1 ? 3 : 2;
            this.setLayout(new BoxLayout(this, n));
        }
        if (UIUtils.isNimbusLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(-2, 0, -2, 0));
        } else if (UIUtils.isAquaLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            this.setRollover(true);
        }
    }

    @Override
    public void addSeparator() {
        if (!UIUtils.isMetalLookAndFeel()) {
            super.addSeparator();
        } else {
            final JSeparator jSeparator = new JSeparator(1);
            final int n = jSeparator.getPreferredSize().width;
            final Dimension dimension = new Dimension(new JToolBar.Separator().getSeparatorSize().width, 12);
            JPanel jPanel = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return dimension;
                }

                @Override
                public Dimension getMaximumSize() {
                    return dimension;
                }

                @Override
                public Dimension getMinimumSize() {
                    return dimension;
                }

                @Override
                public void doLayout() {
                    int n3 = (this.getWidth() - n) / 2;
                    int n2 = (this.getHeight() - dimension.height) / 2;
                    jSeparator.setBounds(n3, n2, n, dimension.height);
                }
            };
            jPanel.setOpaque(false);
            jPanel.add(jSeparator);
            super.add(jPanel);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (UIUtils.isMetalLookAndFeel()) {
            if (component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                final AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setMargin(new Insets(1, 1, 1, 1));
                if (abstractButton.getClientProperty("MetalListener") == null) {
                    final ButtonModel buttonModel = abstractButton.getModel();
                    ChangeListener changeListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            abstractButton.setBorderPainted(buttonModel.isArmed() || buttonModel.isPressed() || buttonModel.isRollover() || buttonModel.isSelected());
                            abstractButton.setContentAreaFilled(buttonModel.isArmed() || buttonModel.isPressed() || buttonModel.isRollover() || buttonModel.isSelected());
                        }
                    };
                    changeListener.stateChanged(null);
                    abstractButton.getModel().addChangeListener(changeListener);
                    abstractButton.putClientProperty("MetalListener", changeListener);
                }
            }
        } else if (UIUtils.isNimbusLookAndFeel()) {
            if (component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setMargin(new Insets(2, 2, 2, 2));
            }
        } else if (UIUtils.isAquaLookAndFeel()) {
            if (component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.putClientProperty("JButton.buttonType", "segmentedTextured");
                if (abstractButton.getClientProperty("JButton.segmentPosition") == null) {
                    abstractButton.putClientProperty("JButton.segmentPosition", "only");
                }
                abstractButton.setMargin(new Insets(-1, -1, -2, -1));
            }
        } else if (UIUtils.isWindowsClassicLookAndFeel() && component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setMargin(new Insets(1, 1, 1, 1));
        }
        if (component instanceof JButton) {
            UIUtils.fixButtonUI((JButton)component);
        }
        super.addImpl(component, object, n);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (UIUtils.isGTKLookAndFeel() && this.getClientProperty("Toolbar.noGTKBorder") == Boolean.TRUE) {
            return;
        }
        super.paintComponent(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (PREFERRED_HEIGHT == -1) {
            GenericToolbar genericToolbar = new GenericToolbar();
            genericToolbar.setBorder(this.getBorder());
            genericToolbar.setBorderPainted(this.isBorderPainted());
            genericToolbar.setRollover(this.isRollover());
            genericToolbar.setFloatable(this.isFloatable());
            Icon icon = Icons.getIcon((String)"GeneralIcons.Save");
            genericToolbar.add(new JButton("Button", icon));
            genericToolbar.add(new JToggleButton("Button", icon));
            genericToolbar.add(new JTextField("Text"));
            JComboBox<Object> jComboBox = new JComboBox<Object>();
            jComboBox.setEditor(new BasicComboBoxEditor());
            jComboBox.setRenderer(new BasicComboBoxRenderer());
            genericToolbar.add(jComboBox);
            genericToolbar.addSeparator();
            PREFERRED_HEIGHT = genericToolbar.getSuperPreferredSize().height;
        }
        dimension.height = this.getParent() instanceof JToolBar ? 1 : Math.max(dimension.height, PREFERRED_HEIGHT);
        return dimension;
    }

    private Dimension getSuperPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void doLayout() {
        for (Component component : this.getComponents()) {
            component.setFocusable(this.isFocusableComponent(component));
        }
        super.doLayout();
    }

    protected boolean isFocusableComponent(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        if (component instanceof JLabel) {
            return false;
        }
        if (component instanceof JPanel) {
            return false;
        }
        if (component instanceof JSeparator) {
            return false;
        }
        if (component instanceof JToolBar) {
            return false;
        }
        return !(component instanceof Box.Filler);
    }
}

