/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.datalab.plugin.manipulators.general.AddEdgeToGraph;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddEdgeToGraphUI
extends JPanel
implements ManipulatorUI {
    private AddEdgeToGraph manipulator;
    private Node[] nodes;
    private Graph graph;
    private Workspace workspace;
    private JLabel descriptionLabel;
    private JRadioButton directedRadioButton;
    private ButtonGroup directedUndirectedRadioButtonGroup;
    private JComboBox edgeTypeComboBox;
    private JLabel edgeTypeLabel;
    private JLabel sourceNodeLabel;
    private JComboBox sourceNodesComboBox;
    private JLabel targetNodeLabel;
    private JComboBox targetNodesComboBox;
    private JRadioButton undirectedRadioButton;

    public AddEdgeToGraphUI() {
        this.initComponents();
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (AddEdgeToGraph)m;
        if (this.manipulator.isDirected()) {
            this.directedRadioButton.setSelected(true);
        } else {
            this.undirectedRadioButton.setSelected(true);
        }
        this.graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
        this.nodes = this.graph.getNodes().toArray();
        this.workspace = ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace();
        for (Node n : this.nodes) {
            this.sourceNodesComboBox.addItem(n.getId() + " - " + n.getLabel());
            this.targetNodesComboBox.addItem(n.getId() + " - " + n.getLabel());
        }
        SelectedOptions selectedOptions = (SelectedOptions)this.workspace.getLookup().lookup(SelectedOptions.class);
        if (selectedOptions != null) {
            this.setNodeComboBoxSelection(this.sourceNodesComboBox, selectedOptions.source);
            this.setNodeComboBoxSelection(this.targetNodesComboBox, selectedOptions.target);
            this.edgeTypeComboBox.setSelectedItem(selectedOptions.edgeType);
        } else {
            this.workspace.add((Object)new SelectedOptions());
        }
        this.refreshAvailableEdgeTypes();
        dialogControls.setOkButtonEnabled(this.nodes.length > 0);
    }

    private void setNodeComboBoxSelection(JComboBox comboBox, Node node) {
        if (node != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] != node) continue;
                comboBox.setSelectedIndex(i);
            }
        }
    }

    public void unSetup() {
        String edgeType = this.getSelectedEdgeType();
        boolean directed = this.directedRadioButton.isSelected();
        Node source = null;
        Node target = null;
        if (this.sourceNodesComboBox.getSelectedIndex() != -1) {
            source = this.nodes[this.sourceNodesComboBox.getSelectedIndex()];
        }
        if (this.targetNodesComboBox.getSelectedIndex() != -1) {
            target = this.nodes[this.targetNodesComboBox.getSelectedIndex()];
        }
        this.manipulator.setDirected(directed);
        this.manipulator.setEdgeTypeLabel(edgeType);
        this.manipulator.setSource(source);
        this.manipulator.setTarget(target);
        SelectedOptions selectedOptions = (SelectedOptions)this.workspace.getLookup().lookup(SelectedOptions.class);
        selectedOptions.directed = directed;
        selectedOptions.edgeType = edgeType;
        selectedOptions.source = source;
        selectedOptions.target = target;
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private String getSelectedEdgeType() {
        String edgeType;
        String string = edgeType = this.edgeTypeComboBox.getSelectedItem() != null ? this.edgeTypeComboBox.getSelectedItem().toString() : null;
        if (edgeType != null && edgeType.trim().isEmpty()) {
            edgeType = null;
        }
        return edgeType;
    }

    private void refreshAvailableEdgeTypes() {
        for (Object edgeType : this.graph.getModel().getEdgeTypeLabels()) {
            this.edgeTypeComboBox.addItem(edgeType);
        }
    }

    private void initComponents() {
        this.directedUndirectedRadioButtonGroup = new ButtonGroup();
        this.directedRadioButton = new JRadioButton();
        this.undirectedRadioButton = new JRadioButton();
        this.descriptionLabel = new JLabel();
        this.sourceNodesComboBox = new JComboBox();
        this.sourceNodeLabel = new JLabel();
        this.targetNodeLabel = new JLabel();
        this.targetNodesComboBox = new JComboBox();
        this.edgeTypeLabel = new JLabel();
        this.edgeTypeComboBox = new JComboBox();
        this.directedUndirectedRadioButtonGroup.add(this.directedRadioButton);
        this.directedRadioButton.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.directedRadioButton.text"));
        this.directedUndirectedRadioButtonGroup.add(this.undirectedRadioButton);
        this.undirectedRadioButton.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.undirectedRadioButton.text"));
        this.descriptionLabel.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.descriptionLabel.text"));
        this.sourceNodeLabel.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.sourceNodeLabel.text"));
        this.targetNodeLabel.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.targetNodeLabel.text"));
        this.edgeTypeLabel.setText(NbBundle.getMessage(AddEdgeToGraphUI.class, (String)"AddEdgeToGraphUI.edgeTypeLabel.text"));
        this.edgeTypeComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directedRadioButton).addComponent(this.sourceNodeLabel, -2, 73, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceNodesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.undirectedRadioButton))).addGroup(layout.createSequentialGroup().addComponent(this.targetNodeLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetNodesComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.edgeTypeLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeTypeComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directedRadioButton).addComponent(this.undirectedRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceNodesComboBox, -2, -1, -2).addComponent(this.sourceNodeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetNodesComboBox, -2, -1, -2).addComponent(this.targetNodeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edgeTypeLabel).addComponent(this.edgeTypeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class SelectedOptions {
        private Node source;
        private Node target;
        private Object edgeType;
        private boolean directed = false;
    }
}

