/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.SyntaxUtilities;

public class NumericTextField
extends JTextField
implements ComboBoxEditor {
    private final boolean positiveOnly;
    private final boolean integerOnly;
    private Number minValue;
    private Number maxValue;
    private SyntaxStyle invalidStyle;
    private Color defaultBackground;
    private Color defaultForeground;

    public NumericTextField(String string) {
        this(string, false);
    }

    public NumericTextField(String string, boolean bl) {
        super(string);
        this.positiveOnly = bl;
        this.integerOnly = true;
        this.minValue = bl ? Integer.valueOf(0) : Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String string, boolean bl, boolean bl2) {
        super(string);
        this.positiveOnly = bl;
        this.integerOnly = bl2;
        if (bl2) {
            this.minValue = bl ? Integer.valueOf(0) : Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else {
            this.minValue = Float.valueOf(bl ? Float.valueOf(0.0f).floatValue() : Float.MIN_VALUE);
            this.maxValue = Float.valueOf(Float.MAX_VALUE);
        }
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String string, int n, boolean bl) {
        super(string, n);
        this.positiveOnly = bl;
        this.integerOnly = true;
        this.minValue = bl ? Integer.valueOf(0) : Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.addFilter();
        this.loadInvalidStyle();
    }

    public NumericTextField(String string, int n, boolean bl, boolean bl2) {
        super(string, n);
        this.positiveOnly = bl;
        this.integerOnly = bl2;
        if (bl2) {
            this.minValue = bl ? Integer.valueOf(0) : Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else {
            this.minValue = Float.valueOf(bl ? Float.valueOf(0.0f).floatValue() : Float.MIN_VALUE);
            this.maxValue = Float.valueOf(Float.MAX_VALUE);
        }
        this.addFilter();
        this.loadInvalidStyle();
    }

    private void loadInvalidStyle() {
        Font font = this.getFont();
        String string = font.getFamily();
        int n = font.getSize();
        this.invalidStyle = SyntaxUtilities.parseStyle(jEdit.getProperty("view.style.invalid"), string, n, true);
        this.defaultForeground = this.getForeground();
        this.defaultBackground = this.getBackground();
    }

    public void setMinValue(Number number) {
        float f;
        int n;
        int n2;
        float f2;
        if (this.positiveOnly && (double)(f2 = number.floatValue()) < 0.0) {
            return;
        }
        if (this.integerOnly ? (n2 = number.intValue()) > (n = this.maxValue.intValue()) : (f2 = number.floatValue()) > (f = this.maxValue.floatValue())) {
            return;
        }
        this.minValue = number;
    }

    public void setMaxValue(Number number) {
        float f;
        int n;
        int n2;
        float f2;
        if (this.positiveOnly && (f2 = number.floatValue()) < 0.0f) {
            return;
        }
        if (this.integerOnly ? (n2 = number.intValue()) < (n = this.minValue.intValue()) : (f2 = number.floatValue()) < (f = this.minValue.floatValue())) {
            return;
        }
        this.maxValue = number;
    }

    public Number getValue() {
        if (this.integerOnly) {
            return Integer.valueOf(this.getText());
        }
        return Float.valueOf(this.getText());
    }

    private void addFilter() {
        if (this.integerOnly) {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new IntegerDocumentFilter());
        } else {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new FloatDocumentFilter());
        }
        try {
            String string = this.getText();
            ((AbstractDocument)this.getDocument()).getDocumentFilter().replace(null, 0, string.length(), string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object object) {
        if (object == null) {
            this.setText("");
        } else {
            this.setText(object.toString());
        }
    }

    class FloatDocumentFilter
    extends DocumentFilter {
        FloatDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = new StringBuilder(NumericTextField.this.getText()).insert(n, string).toString();
            if (!this.isFloat(string2)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(string2) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string2) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.insertString(filterBypass, n, string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            String string = new StringBuilder(NumericTextField.this.getText()).delete(n, n + n2).toString();
            NumericTextField.this.setBackground(this.inRange(string) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = new StringBuilder(NumericTextField.this.getText()).replace(n, n + n2, string).toString();
            if (!this.isFloat(string2)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(string2) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string2) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.replace(filterBypass, n, n2, string, attributeSet);
        }

        private boolean isFloat(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            try {
                if (".".equals(string)) {
                    return true;
                }
                if (!NumericTextField.this.positiveOnly && "-".equals(string)) {
                    return true;
                }
                Float.parseFloat(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean inRange(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            if (".".equals(string)) {
                return true;
            }
            float f = Float.parseFloat(string);
            boolean bl = f <= NumericTextField.this.maxValue.floatValue() && f >= NumericTextField.this.minValue.floatValue();
            return bl;
        }
    }

    class IntegerDocumentFilter
    extends DocumentFilter {
        IntegerDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = new StringBuilder(NumericTextField.this.getText()).insert(n, string).toString();
            if (!this.isInteger(string2)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(string2) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string2) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.insertString(filterBypass, n, string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            String string = new StringBuilder(NumericTextField.this.getText()).delete(n, n + n2).toString();
            NumericTextField.this.setBackground(this.inRange(string) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0) {
                return;
            }
            String string2 = new StringBuilder(NumericTextField.this.getText()).replace(n, n + n2, string).toString();
            if (!this.isInteger(string2)) {
                return;
            }
            NumericTextField.this.setBackground(this.inRange(string2) ? NumericTextField.this.defaultBackground : NumericTextField.this.invalidStyle.getBackgroundColor());
            NumericTextField.this.setForeground(this.inRange(string2) ? NumericTextField.this.defaultForeground : NumericTextField.this.invalidStyle.getForegroundColor());
            super.replace(filterBypass, n, n2, string, attributeSet);
        }

        private boolean isInteger(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            try {
                if (!NumericTextField.this.positiveOnly && "-".equals(string)) {
                    return true;
                }
                Integer.parseInt(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean inRange(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            int n = Integer.parseInt(string);
            return n <= NumericTextField.this.maxValue.intValue() && n >= NumericTextField.this.minValue.intValue();
        }
    }
}

