/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.tray.JEditSwingTrayIcon;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class JTrayIconManager {
    private static JEditTrayIcon trayIcon;
    private static Image originalTrayIconImage;
    private static boolean restore;
    private static String userDir;
    private static String[] args;

    public static void setTrayIconArgs(boolean bl, String string, String[] stringArray) {
        restore = bl;
        userDir = string;
        args = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTrayIcon() {
        if (trayIcon == null && SystemTray.isSupported()) {
            String string = jEdit.getProperty("systrayicon.service", "swing");
            trayIcon = ServiceManager.getService(JEditTrayIcon.class, string);
            if (trayIcon == null) {
                if ("swing".equals(string)) {
                    Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                    return;
                }
                Log.log(7, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name " + string);
                trayIcon = ServiceManager.getService(JEditTrayIcon.class, "swing");
            }
            if (trayIcon == null) {
                Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                return;
            }
            trayIcon.setTrayIconArgs(restore, userDir, args);
            originalTrayIconImage = trayIcon.getImage();
            SystemTray systemTray = SystemTray.getSystemTray();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            switch (jEdit.getProperty("systrayicon.background", "autodetect").toLowerCase()) {
                case "default": {
                    bl = true;
                    break;
                }
                case "fixed": {
                    bl2 = true;
                    break;
                }
                case "picked": {
                    bl3 = true;
                    break;
                }
                default: {
                    bl4 = true;
                }
            }
            if (OperatingSystem.isX11() && !bl) {
                try {
                    int n6;
                    Object object = null;
                    if (bl4) {
                        object = new Robot();
                    }
                    Dimension dimension = systemTray.getTrayIconSize();
                    BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
                    CompletableFuture<Integer> completableFuture2 = new CompletableFuture<Integer>();
                    int n7 = originalTrayIconImage.getWidth((image, n, n2, n3, n4, n5) -> {
                        if ((n & 1) == 1) {
                            completableFuture.complete(n4);
                        }
                        return !completableFuture.isDone();
                    });
                    if (n7 != -1) {
                        completableFuture.complete(n7);
                    }
                    if ((n6 = originalTrayIconImage.getHeight((image, n, n2, n3, n4, n5) -> {
                        if ((n & 2) == 2) {
                            completableFuture2.complete(n5);
                        }
                        return !completableFuture2.isDone();
                    })) != -1) {
                        completableFuture2.complete(n6);
                    }
                    try {
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        double d = dimension.getWidth() / (double)((Integer)completableFuture.join()).intValue();
                        double d2 = dimension.getHeight() / (double)((Integer)completableFuture2.join()).intValue();
                        graphics2D.drawImage(originalTrayIconImage, AffineTransform.getScaleInstance(d, d2), null);
                    }
                    finally {
                        graphics2D.dispose();
                    }
                    Color[][] colorArray = null;
                    int n8 = 0;
                    int n9 = 0;
                    if (bl3 && (colorArray = jEdit.getColorMatrixProperty("systrayicon.bgPixel")) != null) {
                        n8 = colorArray[0].length;
                        n9 = colorArray.length;
                    }
                    Color color = null;
                    if (bl2) {
                        color = jEdit.getColorProperty("systrayicon.bgColor");
                    }
                    Color color2 = null;
                    if (bl3) {
                        color2 = new JPanel().getBackground();
                    }
                    for (int i = 0; i < dimension.height; ++i) {
                        if (bl4) {
                            color = ((Robot)object).getPixelColor(1, i);
                        }
                        for (int j = 0; j < dimension.width; ++j) {
                            if (bl3) {
                                color = j >= n8 || i >= n9 ? color2 : colorArray[i][j];
                            }
                            int n10 = bufferedImage.getRGB(j, i);
                            Color color3 = new Color(n10);
                            float f = (float)(n10 >> 24 & 0xFF) / 255.0f;
                            float f2 = 1.0f - f;
                            int n11 = Math.round(f * (float)color3.getRed() + f2 * (float)color.getRed());
                            int n12 = Math.round(f * (float)color3.getGreen() + f2 * (float)color.getGreen());
                            int n13 = Math.round(f * (float)color3.getBlue() + f2 * (float)color.getBlue());
                            bufferedImage.setRGB(j, i, new Color(n11, n12, n13).getRGB());
                        }
                    }
                    trayIcon.setImage(bufferedImage);
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            }
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                Log.log(9, JEditSwingTrayIcon.class, "Unable to add Tray icon", aWTException);
                trayIcon = null;
                return;
            }
            EditBus.addToBus(trayIcon);
        }
    }

    public static void removeTrayIcon() {
        if (trayIcon != null) {
            SystemTray.getSystemTray().remove(trayIcon);
            EditBus.removeFromBus(trayIcon);
            trayIcon.setImage(originalTrayIconImage);
            trayIcon = null;
        }
    }
}

