/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;

class Roster {
    private static final Pattern HOST_REGEX = Pattern.compile("(?<=/)\\w++(?=\\.dl\\.sourceforge\\.net)");
    private static File downloadDir;
    private final List<Operation> operations = new ArrayList<Operation>();
    private final List<String> toLoad = new ArrayList<String>();

    Roster() {
    }

    void addRemove(String string) {
        this.addOperation(new Remove(string));
    }

    void addInstall(String string, String string2, String string3, int n) {
        this.addOperation(new Install(string, string2, string3, n));
    }

    void addLoad(String string) {
        this.toLoad.add(string);
    }

    public Operation getOperation(int n) {
        return this.operations.get(n);
    }

    int getOperationCount() {
        return this.operations.size();
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void performOperationsInWorkThread(PluginManagerProgress pluginManagerProgress) {
        for (Operation operation : this.operations) {
            operation.runInWorkThread(pluginManagerProgress);
            pluginManagerProgress.done();
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    void performOperationsInAWTThread(Component component) {
        PluginJAR pluginJAR;
        for (Operation object : this.operations) {
            object.runInAWTThread(component);
        }
        for (String string : this.toLoad) {
            if (jEdit.getPluginJAR(string) != null) {
                Log.log(7, this, "Already loaded: " + string);
                continue;
            }
            jEdit.addPluginJAR(string);
        }
        for (String string : this.toLoad) {
            pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) continue;
            pluginJAR.checkDependencies();
        }
        for (String string : this.toLoad) {
            pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null) continue;
            pluginJAR.activatePluginIfNecessary();
        }
    }

    private void addOperation(Operation operation) {
        for (Operation operation2 : this.operations) {
            if (!operation2.equals(operation)) continue;
            return;
        }
        this.operations.add(operation);
    }

    private static String getDownloadDir() {
        if (downloadDir == null) {
            String string = jEdit.getSettingsDirectory();
            if (string == null) {
                string = System.getProperty("user.home");
            }
            downloadDir = new File(MiscUtilities.constructPath(string, "PluginManager.download"));
            downloadDir.mkdirs();
        }
        return downloadDir.getPath();
    }

    class Install
    extends Operation {
        int size;
        private final String installed;
        private final String url;
        private final String installDirectory;
        private String path;

        Install(@Nonnull String string, String string2, String string3, int n) {
            Objects.requireNonNull(string2);
            this.installed = string;
            this.url = string2;
            this.installDirectory = string3;
            this.size = n;
        }

        @Override
        public int getMaximum() {
            return this.size;
        }

        @Override
        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
            this.path = this.download(pluginManagerProgress, this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInAWTThread(Component component) {
            String string;
            Object object;
            Object object2;
            Object object3;
            if (this.path == null) {
                return;
            }
            if (this.installed != null) {
                object3 = jEdit.getPluginJAR(this.installed);
                object2 = new LinkedList<String>();
                object2.add(this.installed);
                if (object3 == null) {
                    Log.log(9, Remove.class, "unable to get PluginJAR for " + this.installed);
                } else {
                    object2.addAll(((PluginJAR)object3).getJars());
                    object2.addAll(((PluginJAR)object3).getFiles());
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    new Remove(string).runInAWTThread(component);
                }
            }
            object3 = null;
            try {
                object3 = new ZipFile(this.path);
                object2 = ((ZipFile)object3).entries();
                while (object2.hasMoreElements()) {
                    object = (ZipEntry)object2.nextElement();
                    string = ((ZipEntry)object).getName().replace('/', File.separatorChar);
                    File file = new File(this.installDirectory, string);
                    if (((ZipEntry)object).isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    new File(file.getParent()).mkdirs();
                    InputStream inputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        inputStream = ((ZipFile)object3).getInputStream((ZipEntry)object);
                        if (inputStream == null) {
                            throw new ZipException("Entry " + ((ZipEntry)object).getName() + " from archive " + ((ZipFile)object3).getName() + " could not be processed.");
                        }
                        fileOutputStream = new FileOutputStream(file);
                        IOUtilities.copyStream(4096, null, inputStream, (OutputStream)fileOutputStream, false);
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(inputStream);
                        IOUtilities.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(inputStream);
                    IOUtilities.closeQuietly(fileOutputStream);
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    Roster.this.toLoad.add(file.getPath());
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (ZipException zipException) {
                Log.log(9, this, zipException);
                GUIUtilities.error(null, "plugin-error-download", new Object[]{""});
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                object = new String[]{iOException.getMessage()};
                GUIUtilities.error(null, "ioerror", (Object[])object);
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
            finally {
                try {
                    if (object3 != null) {
                        ((ZipFile)object3).close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
                if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                    new File(this.path).delete();
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof Install && ((Install)object).url.equals(this.url);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String download(ProgressObserver progressObserver, String string) {
            try {
                Object object;
                Object object2;
                String string2 = jEdit.getProperty("plugin-manager.mirror.id");
                if (string2 == null || string2.equals("NONE")) {
                    string2 = "default";
                }
                boolean bl = false;
                String string3 = string;
                URLConnection uRLConnection = null;
                while (!bl) {
                    Log.log(1, this, String.format("Trying URL '%s'", string3));
                    uRLConnection = new URL(string3).openConnection();
                    object2 = (HttpURLConnection)uRLConnection;
                    ((HttpURLConnection)object2).setInstanceFollowRedirects(false);
                    ((URLConnection)object2).connect();
                    int n = ((HttpURLConnection)object2).getResponseCode();
                    object = ((URLConnection)object2).getHeaderField("Location");
                    if (n >= 300 && n < 400 && object != null) {
                        string3 = ((String)object).replaceFirst("^https:", "http:");
                        continue;
                    }
                    bl = true;
                }
                Log.log(1, this, String.format("Final URL '%s' found", string3));
                object2 = MiscUtilities.getFileName(string3);
                String string4 = MiscUtilities.constructPath(Roster.getDownloadDir(), (String)object2);
                object = HOST_REGEX.matcher(string3);
                if (((Matcher)object).find()) {
                    string2 = ((Matcher)object).group();
                }
                String string5 = jEdit.getProperty("plugin-manager.progress", new String[]{object2, string2});
                progressObserver.setStatus(string5);
                try (InputStream inputStream = uRLConnection.getInputStream();
                     FileOutputStream fileOutputStream = new FileOutputStream(string4);){
                    if (IOUtilities.copyStream(progressObserver, string5, inputStream, (OutputStream)fileOutputStream, true)) return string4;
                    String string6 = null;
                    return string6;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log(9, this, fileNotFoundException);
                SwingUtilities.invokeLater(() -> GUIUtilities.error(null, "plugin-error-download", new Object[]{""}));
                return null;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                SwingUtilities.invokeLater(() -> {
                    Object[] objectArray = new String[]{iOException.getMessage()};
                    GUIUtilities.error(null, "plugin-error-download", objectArray);
                });
                return null;
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                return null;
            }
        }
    }

    class Remove
    extends Operation {
        private final String jar;

        Remove(String string) {
            this.jar = string;
        }

        @Override
        public void runInAWTThread(Component component) {
            PluginJAR pluginJAR = jEdit.getPluginJAR(this.jar);
            if (pluginJAR != null) {
                this.unloadPluginJAR(pluginJAR);
            }
            Roster.this.toLoad.remove(this.jar);
            File file = new File(this.jar);
            File file2 = new File(this.jar.substring(0, this.jar.length() - 4));
            if (file.exists()) {
                Log.log(5, this, "Deleting " + file);
                boolean bl = file.delete();
                if (bl) {
                    EditBus.send(new PluginUpdate(file, PluginUpdate.REMOVED, false));
                }
                if (file2.exists()) {
                    bl &= FileVFS.recursiveDelete(file2);
                }
                if (!bl) {
                    Object[] objectArray = new String[]{this.jar};
                    GUIUtilities.error(component, "plugin-manager.remove-failed", objectArray);
                }
            }
        }

        private void unloadPluginJAR(PluginJAR pluginJAR) {
            String[] stringArray;
            for (String string : stringArray = pluginJAR.getDependentPlugins()) {
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(string);
                if (pluginJAR2 == null) continue;
                Roster.this.toLoad.add(string);
                this.unloadPluginJAR(pluginJAR2);
            }
            jEdit.removePluginJAR(pluginJAR, false);
        }

        public boolean equals(Object object) {
            return object instanceof Remove && ((Remove)object).jar.equals(this.jar);
        }
    }

    static abstract class Operation {
        Operation() {
        }

        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
        }

        public void runInAWTThread(Component component) {
        }

        public int getMaximum() {
            return 0;
        }
    }
}

