/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OsmOAuthAuthorizationClient {
    private final OAuthParameters oauthProviderParameters;
    private final OAuthConsumer consumer;
    private final OAuthProvider provider;
    private boolean canceled;
    private HttpClient connection;

    public OsmOAuthAuthorizationClient(OAuthParameters parameters) {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters parameters, OAuthToken requestToken) {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(requestToken.getKey(), requestToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.canceled = true;
        OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
        synchronized (osmOAuthAuthorizationClient) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(this.consumer, "", new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(this.consumer, null, new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken requestToken) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?oauth_token=").append(requestToken.getKey());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractToken() {
        try (BufferedReader r = this.connection.getResponse().getContentReader();){
            String c;
            Pattern p = Pattern.compile(".*authenticity_token.*value=\"([^\"]+)\".*");
            while ((c = r.readLine()) != null) {
                Matcher m = p.matcher(c);
                if (!m.find()) continue;
                String string = m.group(1);
                return string;
            }
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
        Logging.warn("No authenticity_token found in response!");
        return null;
    }

    protected SessionId extractOsmSession() throws IOException, URISyntaxException {
        List<String> setCookies = CookieHandler.getDefault().get(this.connection.getURL().toURI(), Collections.emptyMap()).get("Cookie");
        if (setCookies == null) {
            Logging.warn("No 'Set-Cookie' in response header!");
            return null;
        }
        for (String setCookie : setCookies) {
            String[] kvPairs = setCookie.split(";", -1);
            if (kvPairs.length == 0) continue;
            for (String kvPair : kvPairs) {
                String[] kv = (kvPair = kvPair.trim()).split("=", -1);
                if (kv.length != 2 || !"_osm_session".equals(kv[0])) continue;
                String token = this.extractToken();
                if (token == null) {
                    return null;
                }
                SessionId si = new SessionId();
                si.id = kv[1];
                si.token = token;
                return si;
            }
        }
        Logging.warn("No suitable 'Set-Cookie' in response header found! {0}", setCookies);
        return null;
    }

    protected static String buildPostRequest(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder(32);
        Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String value = entry.getValue();
            value = value == null ? "" : value;
            sb.append(entry.getKey()).append('=').append(Utils.encodeUrl(value));
            if (!it.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionId fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLoginUrl() + "?cookie_test=true");
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = HttpClient.create(url).useCache(false);
                this.connection.connect();
            }
            SessionId sessionId = this.extractOsmSession();
            if (sessionId == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", url.toString()));
            }
            SessionId sessionId2 = sessionId;
            return sessionId2;
        }
        catch (IOException | URISyntaxException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchOAuthToken(SessionId sessionId, OAuthToken requestToken) throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.getAuthoriseUrl(requestToken));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = HttpClient.create(url).useCache(false).setHeader("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
                this.connection.connect();
            }
            sessionId.token = this.extractToken();
            if (sessionId.token == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", url.toString()));
            }
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(SessionId sessionId, String userName, String password) throws OsmLoginFailedException {
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLoginUrl());
            HttpClient client = HttpClient.create(url, "POST").useCache(false);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", userName);
            parameters.put("password", password);
            parameters.put("referer", "/");
            parameters.put("commit", "Login");
            parameters.put("authenticity_token", sessionId.token);
            client.setRequestBody(OsmOAuthAuthorizationClient.buildPostRequest(parameters).getBytes(StandardCharsets.UTF_8));
            client.setHeader("Content-Type", "application/x-www-form-urlencoded");
            client.setHeader("Cookie", "_osm_session=" + sessionId.id);
            client.setMaxRedirects(-1);
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = client;
                this.connection.connect();
            }
            int retCode = this.connection.getResponse().getResponseCode();
            if (retCode != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", userName));
            }
        }
        catch (IOException | OsmOAuthAuthorizationException e) {
            throw new OsmLoginFailedException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(SessionId sessionId) throws OsmOAuthAuthorizationException {
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = HttpClient.create(url).setMaxRedirects(-1);
                this.connection.connect();
            }
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(SessionId sessionId, OAuthToken requestToken, OsmPrivileges privileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.fetchOAuthToken(sessionId, requestToken);
        parameters.put("oauth_token", requestToken.getKey());
        parameters.put("oauth_callback", "");
        parameters.put("authenticity_token", sessionId.token);
        if (privileges.isAllowWriteApi()) {
            parameters.put("allow_write_api", "yes");
        }
        if (privileges.isAllowWriteGpx()) {
            parameters.put("allow_write_gpx", "yes");
        }
        if (privileges.isAllowReadGpx()) {
            parameters.put("allow_read_gpx", "yes");
        }
        if (privileges.isAllowWritePrefs()) {
            parameters.put("allow_write_prefs", "yes");
        }
        if (privileges.isAllowReadPrefs()) {
            parameters.put("allow_read_prefs", "yes");
        }
        if (privileges.isAllowModifyNotes()) {
            parameters.put("allow_write_notes", "yes");
        }
        parameters.put("commit", "Save changes");
        String request = OsmOAuthAuthorizationClient.buildPostRequest(parameters);
        try {
            URL url = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            HttpClient client = HttpClient.create(url, "POST").useCache(false);
            client.setHeader("Content-Type", "application/x-www-form-urlencoded");
            client.setHeader("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            client.setMaxRedirects(-1);
            client.setRequestBody(request.getBytes(StandardCharsets.UTF_8));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = client;
                this.connection.connect();
            }
            int retCode = this.connection.getResponse().getResponseCode();
            if (retCode != 200) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", requestToken.getKey()));
            }
        }
        catch (IOException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    public void authorise(OAuthToken requestToken, String userName, String password, OsmPrivileges privileges, ProgressMonitor monitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        CheckParameterUtil.ensureParameterNotNull(requestToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        CheckParameterUtil.ensureParameterNotNull(password, "password");
        CheckParameterUtil.ensureParameterNotNull(privileges, "privileges");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", requestToken.getKey()));
            monitor.setTicksCount(4);
            monitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website...", new Object[0]));
            SessionId sessionId = this.fetchOsmWebsiteSessionId();
            sessionId.userName = userName;
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", userName));
            this.authenticateOsmSession(sessionId, userName, password);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", requestToken.getKey()));
            this.sendAuthorisationRequest(sessionId, requestToken, privileges);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            monitor.worked(1);
            monitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", sessionId));
            this.logoutOsmSession(sessionId);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            monitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException e) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(e);
            }
            throw e;
        }
        finally {
            monitor.finishTask();
        }
    }

    protected static class SessionId {
        protected String id;
        protected String token;
        protected String userName;

        protected SessionId() {
        }
    }
}

