/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class RemoteRuleMetrics {
    private static final double[] LATENCY_BUCKETS = new double[]{0.025, 0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 15.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 20000.0, 40000.0};
    private static final Counter retries = (Counter)((Counter.Builder)Counter.build((String)"languagetool_remote_rule_retries_total", (String)"Amount of retries for the given rule").labelNames(new String[]{"rule_id"})).register();
    private static final Counter downtime = (Counter)((Counter.Builder)Counter.build((String)"languagetool_remote_rule_downtime_seconds_total", (String)"Time remote rules were deactivated because of errors").labelNames(new String[]{"rule_id"})).register();
    private static final Histogram requestLatency = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_latency_seconds", (String)"Request duration summary").labelNames(new String[]{"rule_id", "result"})).buckets(LATENCY_BUCKETS).register();
    private static final Histogram requestThroughput = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_throughput_characters", (String)"Request size summary").labelNames(new String[]{"rule_id", "result"})).buckets(SIZE_BUCKETS).register();
    private static final Gauge failures = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_remote_rule_consecutive_failures", (String)"Amount of consecutive failures").labelNames(new String[]{"rule_id"})).register();
    private static final Gauge up = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_remote_rule_up", (String)"Status of remote rule").labelNames(new String[]{"rule_id"})).register();

    private RemoteRuleMetrics() {
        throw new IllegalStateException("RemoteRuleMetrics should only be used via static methods.");
    }

    public static void request(String rule, int numRetries, long nanoseconds, long characters, RequestResult result) {
        ((Histogram.Child)requestLatency.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)nanoseconds / 1.0E9);
        ((Histogram.Child)requestThroughput.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)characters);
        ((Counter.Child)retries.labels(new String[]{rule})).inc((double)numRetries);
    }

    public static void failures(String rule, int count) {
        ((Gauge.Child)failures.labels(new String[]{rule})).set((double)count);
    }

    public static void up(String rule, boolean isUp) {
        ((Gauge.Child)up.labels(new String[]{rule})).set(isUp ? 1.0 : 0.0);
    }

    public static void downtime(String rule, long milliseconds) {
        ((Counter.Child)downtime.labels(new String[]{rule})).inc((double)milliseconds / 1000.0);
    }

    public static enum RequestResult {
        SUCCESS,
        SKIPPED,
        TIMEOUT,
        INTERRUPTED,
        DOWN,
        ERROR;

    }
}

