import { ILogger } from "./ILogger";
/**
 * The log levels to log at.
 * @category Logging
 */
export declare class LogLevel {
    private level;
    private sequence;
    /**
     * The DEBUG channel
     */
    static readonly DEBUG: LogLevel;
    /**
     * The INFO channel
     */
    static readonly INFO: LogLevel;
    /**
     * The WARN channel
     */
    static readonly WARN: LogLevel;
    /**
     * The ERROR channel
     */
    static readonly ERROR: LogLevel;
    private constructor();
    includes(level: LogLevel): boolean;
    toString(): string;
    static fromString(level: string, defaultLevel?: LogLevel): LogLevel;
}
/**
 * Service class for logging in the bot-sdk
 * @category Logging
 */
export declare class LogService {
    private static logger;
    private static logLevel;
    private constructor();
    /**
     * The level at which the LogService is running.
     */
    static get level(): LogLevel;
    /**
     * Sets the log level for this logger. Defaults to DEBUG.
     * @param {LogLevel} level the new log level
     */
    static setLevel(level: LogLevel): void;
    /**
     * Sets a new logger for the Log Service
     * @param {ILogger} logger the new logger
     */
    static setLogger(logger: ILogger): void;
    /**
     * Logs to the DEBUG channel
     * @param {string} module The module being logged
     * @param {any[]} messageOrObject The data to log
     */
    static debug(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the ERROR channel
     * @param {string} module The module being logged
     * @param {any[]} messageOrObject The data to log
     */
    static error(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the INFO channel
     * @param {string} module The module being logged
     * @param {any[]} messageOrObject The data to log
     */
    static info(module: string, ...messageOrObject: any[]): void;
    /**
     * Logs to the WARN channel
     * @param {string} module The module being logged
     * @param {any[]} messageOrObject The data to log
     */
    static warn(module: string, ...messageOrObject: any[]): void;
}
