package PDF::Builder::Resource::Font::CoreFont::timesroman;

use strict;
use warnings;

our $VERSION = '3.019'; # VERSION
my $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::timesroman - font-specific information for regular (roman) Times font

=cut

sub data { return {
    'fontname' => 'Times-Roman',
    'type' => 'Type1',
    'apiname' => 'TiRo',
    'ascender' => '683',
    'capheight' => '662',
    'descender' => '-217',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'italicangle' => '0',
    'missingwidth' => '250',
    'stdhw' => '28',
    'stdvw' => '84',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '450',
    'firstchar' => '32',
    'lastchar' => '255',
    'fontbbox' => [-168, -218, 1000, 898],
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
# source: \Windows\Fonts\times.ttf
# font underline position = -223
# CIDS 0 .. 4684 to be output
# fontbbox = (-568 -306 2045 1039)
    'wx' => { # HORIZ. WIDTH TABLE
	# +1  official .afm spec one larger than what TTF reports
	# (+1)  not in .afm spec, but increased (by 1) per base letter
	# -1  official .afm spec one smaller than what TTF reports
	# others as noted (.afm spec or original .pm plus some %)
        'A'       => 722,
        'AE'       => 889,
        'AEacute'       => 889,
        'AEmacron'       => 889,
        'Aacute'       => 722,
        'Abreve'       => 722,
        'Abreveacute'       => 722,
        'Abrevecyrillic'       => 722,
        'Abrevedotbelow'       => 722,
        'Abrevegrave'       => 722,
        'Abrevehookabove'       => 722,
        'Abrevetilde'       => 722,
        'Acaron'       => 722,
        'Acircumflex'       => 722,
        'Acircumflexacute'       => 722,
        'Acircumflexdotbelow'       => 722,
        'Acircumflexgrave'       => 722,
        'Acircumflexhookabove'       => 722,
        'Acircumflextilde'       => 722,
        'Adblgrave'       => 722,
        'Adieresis'       => 722,
        'Adieresiscyrillic'       => 722,
        'Adieresismacron'       => 722,
        'Adotbelow'       => 722,
        'Adotmacron'       => 722,
        'Agrave'       => 722,
        'Ahookabove'       => 722,
        'Aiecyrillic'       => 889,
        'Ainvertedbreve'       => 722,
        'Alpha'       => 722,
        'Alphatonos'       => 722,
        'Amacron'       => 722,
        'Aogonek'       => 722,
        'Aring'       => 722,
        'Aringacute'       => 722,
        'Aringbelow'       => 722,
        'Atilde'       => 722,
        'Aybarmenian'       => 754,
        'B'       => 667,                                         # +1
        'Bdotaccent'       => 667,                                # (+1)
        'Bdotbelow'       => 667,                                 # (+1)
        'Benarmenian'       => 695,
        'Beta'       => 667,                                      # (+1)
        'Bhook'       => 759,
        'Blinebelow'       => 667,                                # (+1)
        'Btopbar'       => 574,
        'C'       => 667,                                         # +1
        'Caarmenian'       => 729,
        'Cacute'       => 667,                                    # +1
        'Ccaron'       => 667,                                    # +1
        'Ccedilla'       => 667,                                  # +1
        'Ccedillaacute'       => 667,                             # (+1)
        'Ccircumflex'       => 667,                               # (+1)
        'Cdotaccent'       => 667,                                # (+1)
        'Chaarmenian'       => 696,
        'Cheabkhasiancyrillic'       => 878,
        'Chedescenderabkhasiancyrillic'       => 878,
        'Chedescendercyrillic'       => 649,
        'Chedieresiscyrillic'       => 649,
        'Cheharmenian'       => 719,
        'Chekhakassiancyrillic'       => 649,
        'Cheverticalstrokecyrillic'       => 649,
        'Chi'       => 722,
        'Chook'       => 667,                                     # (+1)
        'Coarmenian'       => 690,
        'D'       => 722,
        'DZ'       => 1333,
        'DZcaron'       => 1333,
        'Daarmenian'       => 760,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 475,
        'Delta'       => 643,                         # afm 612, too narrow
        'Dhook'       => 814,
        'Digammagreek'       => 556,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 574,
        'Dz'       => 1166,
        'Dzcaron'       => 1166,
        'Dzeabkhasiancyrillic'       => 500,
        'E'       => 611,                                         # +1
        'Eacute'       => 611,                                    # +1
        'Ebreve'       => 611,                                    # (+1)
        'Ecaron'       => 611,                                    # +1
        'Ecedillabreve'       => 611,                             # (+1)
        'Echarmenian'       => 697,
        'Ecircumflex'       => 611,                               # +1
        'Ecircumflexacute'       => 611,                          # (+1)
        'Ecircumflexbelow'       => 611,                          # (+1)
        'Ecircumflexdotbelow'       => 611,                       # (+1)
        'Ecircumflexgrave'       => 611,                          # (+1)
        'Ecircumflexhookabove'       => 611,                      # (+1)
        'Ecircumflextilde'       => 611,                          # (+1)
        'Edblgrave'       => 611,                                 # (+1)
        'Edieresis'       => 611,                                 # +1
        'Edotaccent'       => 611,                                # +1
        'Edotbelow'       => 611,                                 # (+1)
        'Egrave'       => 611,                                    # +1
        'Eharmenian'       => 636,
        'Ehookabove'       => 611,                                # (+1)
        'Eightroman'       => 1673,
        'Einvertedbreve'       => 611,                            # (+1)
        'Eiotifiedcyrillic'       => 967,
        'Elevenroman'       => 1047,
        'Emacron'       => 611,                                   # +1
        'Emacronacute'       => 611,                              # (+1)
        'Emacrongrave'       => 611,                              # (+1)
        'Endescendercyrillic'       => 722,
        'Eng'       => 701,
        'Enghecyrillic'       => 850,
        'Enhookcyrillic'       => 722,
        'Eogonek'       => 611,                                   # +1
        'Eopen'       => 500,
        'Epsilon'       => 611,                                   # (+1)
        'Epsilontonos'       => 693,
        'Ereversed'       => 611,                                 # (+1)
        'Esdescendercyrillic'       => 666,
        'Esh'       => 582,
        'Eta'       => 722,
        'Etarmenian'       => 716,
        'Etatonos'       => 808,
        'Eth'       => 722,
        'Etilde'       => 611,                                    # (+1)
        'Etildebelow'       => 611,                               # (+1)
        'Euro'       => 500,
        'Ezh'       => 539,
        'Ezhcaron'       => 539,
        'Ezhreversed'       => 539,
        'F'       => 556,
        'Fdotaccent'       => 556,
        'Feharmenian'       => 788,
        'Feicoptic'       => 615,
        'Fhook'       => 556,
        'Fiveroman'       => 722,
        'Fourroman'       => 1051,
        'G'       => 722,
        'Gacute'       => 722,
        'Gamma'       => 578,
        'Gammaafrican'       => 722,
        'Gangiacoptic'       => 656,
        'Gbreve'       => 722,
        'Gcaron'       => 722,
        'Gcircumflex'       => 722,
        'Gcommaaccent'       => 722,
        'Gdotaccent'       => 722,
        'Ghadarmenian'       => 746,
        'Ghemiddlehookcyrillic'       => 631,
        'Ghestrokecyrillic'       => 578,
        'Ghook'       => 722,
        'Gimarmenian'       => 746,
        'Gmacron'       => 722,
        'Gsmallhook'       => 453,
        'Gstroke'       => 722,
        'H'       => 722,
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 666,
        'Hadescendercyrillic'       => 722,
        'Hbar'       => 722,
        'Hbrevebelow'       => 722,
        'Hcedilla'       => 722,
        'Hcircumflex'       => 722,
        'Hdieresis'       => 722,
        'Hdotaccent'       => 722,
        'Hdotbelow'       => 722,
        'Hoarmenian'       => 574,
        'Horicoptic'       => 541,
        'I'       => 333,
        'IJ'       => 708,
        'Iacute'       => 333,
        'Ibreve'       => 333,
        'Icaron'       => 333,
        'Icircumflex'       => 333,
        'Idblgrave'       => 333,
        'Idieresis'       => 333,
        'Idieresisacute'       => 333,
        'Idieresiscyrillic'       => 722,
        'Idotaccent'       => 333,
        'Idotbelow'       => 333,
        'Iebrevecyrillic'       => 610,
        'Ifraktur'       => 553,
        'Igrave'       => 333,
        'Ihookabove'       => 333,
        'Iinvertedbreve'       => 333,
        'Imacron'       => 333,
        'Imacroncyrillic'       => 722,
        'Iniarmenian'       => 672,
        'Iogonek'       => 333,
        'Iota'       => 333,
        'Iotaafrican'       => 253,
        'Iotadieresis'       => 333,
        'Iotatonos'       => 411,
        'Istroke'       => 333,
        'Itilde'       => 333,
        'Itildebelow'       => 333,
        'Izhitsadblgravecyrillic'       => 813,
        'J'       => 389,
        'Jaarmenian'       => 726,
        'Jcircumflex'       => 389,
        'Jheharmenian'       => 712,
        'K'       => 722,
        'Kabashkircyrillic'       => 785,
        'Kacute'       => 722,
        'Kadescendercyrillic'       => 666,
        'Kahookcyrillic'       => 666,
        'Kappa'       => 722,
        'Kastrokecyrillic'       => 666,
        'Kaverticalstrokecyrillic'       => 666,
        'Kcaron'       => 722,
        'Kcommaaccent'       => 722,
        'Kdotbelow'       => 722,
        'Keharmenian'       => 812,
        'Kenarmenian'       => 719,
        'Kheicoptic'       => 661,
        'Khook'       => 722,
        'Klinebelow'       => 722,
        'Koppacyrillic'       => 666,
        'Koppagreek'       => 575,
        'Ksicyrillic'       => 500,
        'L'       => 611,                                         # +1
        'LJ'       => 1000,
        'Lacute'       => 611,                                    # +1
        'Lambda'       => 725,
        'Lcaron'       => 611,                                    # +1
        'Lcircumflexbelow'       => 611,                          # (+1)
        'Lcommaaccent'       => 611,                              # +1
        'Ldot'       => 611,                                      # (+1)
        'Ldotbelow'       => 611,                                 # (+1)
        'Ldotbelowmacron'       => 611,                           # (+1)
        'Liwnarmenian'       => 543,
        'Lj'       => 888,
        'Llinebelow'       => 611,                                # (+1)
        'Lslash'       => 611,                                    # +1
        'M'       => 889,
        'Macute'       => 889,
        'Mdotaccent'       => 889,
        'Mdotbelow'       => 889,
        'Menarmenian'       => 812,
        'Mturned'       => 816,
        'Mu'       => 889,
        'N'       => 722,
        'NJ'       => 1111,
        'Nacute'       => 722,
        'Ncaron'       => 722,
        'Ncircumflexbelow'       => 722,
        'Ncommaaccent'       => 722,
        'Ndotaccent'       => 722,
        'Ndotbelow'       => 722,
        'Nhookleft'       => 722,
        'Nineroman'       => 1052,
        'Nj'       => 1000,
        'Nlinebelow'       => 722,
        'Nowarmenian'       => 719,
        'Ntilde'       => 722,
        'Nu'       => 722,
        'O'       => 722,
        'OE'       => 889,
        'Oacute'       => 722,
        'Obarredcyrillic'       => 722,
        'Obarreddieresiscyrillic'       => 722,
        'Obreve'       => 722,
        'Ocaron'       => 722,
        'Ocenteredtilde'       => 722,
        'Ocircumflex'       => 722,
        'Ocircumflexacute'       => 722,
        'Ocircumflexdotbelow'       => 722,
        'Ocircumflexgrave'       => 722,
        'Ocircumflexhookabove'       => 722,
        'Ocircumflextilde'       => 722,
        'Odblgrave'       => 722,
        'Odieresis'       => 722,
        'Odieresiscyrillic'       => 722,
        'Odotbelow'       => 722,
        'Ograve'       => 722,
        'Oharmenian'       => 738,
        'Ohookabove'       => 722,
        'Ohorn'       => 722,
        'Ohornacute'       => 722,
        'Ohorndotbelow'       => 722,
        'Ohorngrave'       => 722,
        'Ohornhookabove'       => 722,
        'Ohorntilde'       => 722,
        'Ohungarumlaut'       => 722,
        'Oi'       => 924,
        'Oinvertedbreve'       => 722,
        'Omacron'       => 722,
        'Omacronacute'       => 722,
        'Omacrongrave'       => 722,
        'Omega'       => 743,
        'Omegacyrillic'       => 1172,
        'Omegaroundcyrillic'       => 762,
        'Omegatitlocyrillic'       => 1212,
        'Omegatonos'       => 743,
        'Omicron'       => 722,
        'Omicrontonos'       => 722,
        'Oneroman'       => 333,
        'Oogonek'       => 722,
        'Oogonekmacron'       => 722,
        'Oopen'       => 666,
        'Oslash'       => 722,
        'Oslashacute'       => 722,
        'Otcyrillic'       => 1172,
        'Otilde'       => 722,
        'Otildeacute'       => 722,
        'Otildedieresis'       => 722,
        'P'       => 556,
        'Pacute'       => 556,
        'Pdotaccent'       => 556,
        'Peharmenian'       => 848,
        'Pemiddlehookcyrillic'       => 1032,
        'Phi'       => 730,
        'Phook'       => 649,
        'Pi'       => 722,
        'Piwrarmenian'       => 780,
        'Psi'       => 737,
        'Psicyrillic'       => 737,
        'Q'       => 722,
        'R'       => 667,                                         # +1
        'Raarmenian'       => 807,
        'Racute'       => 667,                                    # +1
        'Rcaron'       => 667,                                    # +1
        'Rcommaaccent'       => 667,                              # +1
        'Rdblgrave'       => 667,                                 # (+1)
        'Rdotaccent'       => 667,                                # (+1)
        'Rdotbelow'       => 667,                                 # (+1)
        'Rdotbelowmacron'       => 667,                           # (+1)
        'Reharmenian'       => 672,
        'Rfraktur'       => 794,
        'Rho'       => 556,
        'Rinvertedbreve'       => 667,                            # (+1)
        'Rlinebelow'       => 667,                                # (+1)
        'Rsmallinverted'       => 487,
        'Rsmallinvertedsuperior'       => 293,
        'S'       => 556,
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 708,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 556,
        'Sacutedotaccent'       => 556,
        'Sampigreek'       => 731,
        'Scaron'       => 556,
        'Scarondotaccent'       => 556,
        'Scedilla'       => 556,
        'Schwacyrillic'       => 722,
        'Schwadieresiscyrillic'       => 722,
        'Scircumflex'       => 556,
        'Scommaaccent'       => 556,
        'Sdotaccent'       => 556,
        'Sdotbelow'       => 556,
        'Sdotbelowdotaccent'       => 556,
        'Seharmenian'       => 718,
        'Sevenroman'       => 1360,
        'Shaarmenian'       => 690,
        'Sheicoptic'       => 828,
        'Shhacyrillic'       => 649,
        'Shimacoptic'       => 699,
        'Sigma'       => 582,
        'Sixroman'       => 1047,
        'Stigmagreek'       => 666,
        'T'       => 611,                                         # +1
        'Tau'       => 611,                                       # (+1)
        'Tbar'       => 611,                                      # (+1)
        'Tcaron'       => 611,                                    # +1
        'Tcedilla'       => 611,                                  # (+1)
        'Tcircumflexbelow'       => 611,                          # (+1)
        'Tcommaaccent'       => 611,                              # +1
        'Tdotaccent'       => 611,                                # (+1)
        'Tdotbelow'       => 611,                                 # (+1)
        'Tedescendercyrillic'       => 610,
        'Tenroman'       => 722,
        'Tetsecyrillic'       => 796,
        'Theta'       => 722,
        'Thook'       => 611,                                     # (+1)
        'Thorn'       => 556,
        'Threeroman'       => 959,
        'Tiwnarmenian'       => 647,
        'Tlinebelow'       => 611,                                # (+1)
        'Toarmenian'       => 895,
        'Tonefive'       => 500,
        'Tonesix'       => 574,
        'Tonetwo'       => 556,
        'Tretroflexhook'       => 611,                            # (+1)
        'Twelveroman'       => 1360,
        'Tworoman'       => 646,
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 708,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 775,
        'Uhornacute'       => 775,
        'Uhorndotbelow'       => 775,
        'Uhorngrave'       => 775,
        'Uhornhookabove'       => 775,
        'Uhorntilde'       => 775,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 708,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1095,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 708,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 722,
        'Upsilon1'       => 722,
        'Upsilonacutehooksymbolgreek'       => 890,
        'Upsilonafrican'       => 743,
        'Upsilondieresis'       => 722,
        'Upsilondieresishooksymbolgreek'       => 722,
        'Upsilontonos'       => 815,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 722,
        'Ustraightstrokecyrillic'       => 722,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 722,
        'Vdotbelow'       => 722,
        'Vewarmenian'       => 764,
        'Vhook'       => 722,
        'Voarmenian'       => 718,
        'Vtilde'       => 722,
        'W'       => 944,                                         # +1
        'Wacute'       => 944,                                    # (+1)
        'Wcircumflex'       => 944,                               # (+1)
        'Wdieresis'       => 944,                                 # (+1)
        'Wdotaccent'       => 944,                                # (+1)
        'Wdotbelow'       => 944,                                 # (+1)
        'Wgrave'       => 944,                                    # (+1)
        'X'       => 722,
        'Xdieresis'       => 722,
        'Xdotaccent'       => 722,
        'Xeharmenian'       => 932,
        'Xi'       => 643,
        'Y'       => 722,
        'Yacute'       => 722,
        'Ycircumflex'       => 722,
        'Ydieresis'       => 722,
        'Ydotaccent'       => 722,
        'Ydotbelow'       => 722,
        'Yerudieresiscyrillic'       => 872,
        'Ygrave'       => 722,
        'Yhook'       => 780,
        'Yhookabove'       => 722,
        'Yiarmenian'       => 690,
        'Yiwnarmenian'       => 561,
        'Ytilde'       => 722,
        'Yusbigcyrillic'       => 895,
        'Yusbigiotifiedcyrillic'       => 1208,
        'Yuslittlecyrillic'       => 722,
        'Yuslittleiotifiedcyrillic'       => 1032,
        'Z'       => 611,                                         # +1
        'Zaarmenian'       => 706,
        'Zacute'       => 611,                                    # +1
        'Zcaron'       => 611,                                    # +1
        'Zcircumflex'       => 611,                               # (+1)
        'Zdotaccent'       => 611,                                # +1
        'Zdotbelow'       => 611,                                 # (+1)
        'Zedescendercyrillic'       => 500,
        'Zedieresiscyrillic'       => 500,
        'Zeta'       => 610,
        'Zhearmenian'       => 761,
        'Zhebrevecyrillic'       => 895,
        'Zhedescendercyrillic'       => 895,
        'Zhedieresiscyrillic'       => 895,
        'Zlinebelow'       => 611,                                # (+1)
        'Zstroke'       => 611,                                   # (+1)
        'a'       => 444,                                         # +1
        'aacute'       => 444,                                    # +1
        'abbreviationmarkarmenian'       => 557,
        'abreve'       => 444,                                    # +1
        'abreveacute'       => 444,                               # (+1)
        'abrevecyrillic'       => 443,
        'abrevedotbelow'       => 444,                            # (+1)
        'abrevegrave'       => 444,                               # (+1)
        'abrevehookabove'       => 444,                           # (+1)
        'abrevetilde'       => 444,                               # (+1)
        'acaron'       => 444,                                    # (+1)
        'acircumflex'       => 444,                               # +1
        'acircumflexacute'       => 444,                          # (+1)
        'acircumflexdotbelow'       => 444,                       # (+1)
        'acircumflexgrave'       => 444,                          # (+1)
        'acircumflexhookabove'       => 444,                      # (+1)
        'acircumflextilde'       => 444,                          # (+1)
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 444,                                 # (+1)
        'adieresis'       => 444,                                 # +1
        'adieresiscyrillic'       => 443,
        'adieresismacron'       => 444,                           # (+1)
        'adotbelow'       => 444,                                 # (+1)
        'adotmacron'       => 444,                                # (+1)
        'ae'       => 667,                                        # +1
        'aeacute'       => 666,
        'aemacron'       => 666,
        'afii00208'       => 1000,
        'afii10017'       => 722,
        'afii10018'       => 574,
        'afii10019'       => 666,
        'afii10020'       => 578,
        'afii10021'       => 682,
        'afii10022'       => 610,
        'afii10023'       => 610,
        'afii10024'       => 895,
        'afii10025'       => 500,
        'afii10026'       => 722,
        'afii10027'       => 722,
        'afii10028'       => 666,
        'afii10029'       => 678,
        'afii10030'       => 889,
        'afii10031'       => 722,
        'afii10032'       => 722,
        'afii10033'       => 722,
        'afii10034'       => 556,
        'afii10035'       => 666,
        'afii10036'       => 610,
        'afii10037'       => 708,
        'afii10038'       => 790,
        'afii10039'       => 722,
        'afii10040'       => 722,
        'afii10041'       => 649,
        'afii10042'       => 1008,
        'afii10043'       => 1008,
        'afii10044'       => 706,
        'afii10045'       => 872,
        'afii10046'       => 574,
        'afii10047'       => 660,
        'afii10048'       => 1027,
        'afii10049'       => 666,
        'afii10050'       => 450,
        'afii10051'       => 751,
        'afii10052'       => 578,
        'afii10053'       => 660,
        'afii10054'       => 556,
        'afii10055'       => 333,
        'afii10056'       => 333,
        'afii10057'       => 389,
        'afii10058'       => 872,
        'afii10059'       => 872,
        'afii10060'       => 741,
        'afii10061'       => 666,
        'afii10062'       => 708,
        'afii10065'       => 443,
        'afii10066'       => 508,
        'afii10067'       => 472,
        'afii10068'       => 410,
        'afii10069'       => 508,
        'afii10070'       => 443,
        'afii10071'       => 443,
        'afii10072'       => 690,
        'afii10073'       => 395,
        'afii10074'       => 535,
        'afii10075'       => 535,
        'afii10076'       => 485,
        'afii10077'       => 499,
        'afii10078'       => 632,
        'afii10079'       => 535,
        'afii10080'       => 500,
        'afii10081'       => 535,
        'afii10082'       => 500,
        'afii10083'       => 443,
        'afii10084'       => 437,
        'afii10085'       => 500,
        'afii10086'       => 647,
        'afii10087'       => 500,
        'afii10088'       => 535,
        'afii10089'       => 502,
        'afii10090'       => 770,
        'afii10091'       => 770,
        'afii10092'       => 517,
        'afii10093'       => 671,
        'afii10094'       => 456,
        'afii10095'       => 429,
        'afii10096'       => 747,
        'afii10097'       => 459,
        'afii10098'       => 351,
        'afii10099'       => 482,
        'afii10100'       => 410,
        'afii10101'       => 429,
        'afii10102'       => 389,
        'afii10103'       => 277,
        'afii10104'       => 277,
        'afii10105'       => 277,
        'afii10106'       => 727,
        'afii10107'       => 723,
        'afii10108'       => 500,
        'afii10109'       => 485,
        'afii10110'       => 500,
        'afii10145'       => 722,
        'afii10146'       => 670,
        'afii10147'       => 722,
        'afii10148'       => 813,
        'afii10193'       => 535,
        'afii10194'       => 542,
        'afii10195'       => 500,
        'afii10196'       => 588,
        'afii10846'       => 443,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57381'       => 525,
        'afii57388'       => 318,
        'afii57396'       => 525,
        'afii57397'       => 525,
        'afii57398'       => 525,
        'afii57403'       => 318,
        'afii57407'       => 356,
        'afii57409'       => 412,
        'afii57440'       => 207,
        'afii57451'       => 0,
        'afii57452'       => 0,
        'afii57453'       => 0,
        'afii57454'       => 0,
        'afii57455'       => 0,
        'afii57456'       => 0,
        'afii57457'       => 0,
        'afii57458'       => 0,
        'afii57534'       => 282,
        'afii57636'       => 776,
        'afii57645'       => 355,
        'afii57658'       => 277,
        'afii57664'       => 481,
        'afii57665'       => 455,
        'afii57666'       => 335,
        'afii57667'       => 418,
        'afii57668'       => 471,
        'afii57669'       => 278,
        'afii57670'       => 286,
        'afii57671'       => 476,
        'afii57672'       => 475,
        'afii57673'       => 266,
        'afii57674'       => 452,
        'afii57675'       => 432,
        'afii57676'       => 431,
        'afii57677'       => 507,
        'afii57678'       => 485,
        'afii57679'       => 274,
        'afii57680'       => 304,
        'afii57681'       => 475,
        'afii57682'       => 454,
        'afii57683'       => 454,
        'afii57684'       => 440,
        'afii57685'       => 482,
        'afii57686'       => 459,
        'afii57687'       => 473,
        'afii57688'       => 468,
        'afii57689'       => 610,
        'afii57690'       => 500,
        'afii57694'       => 610,
        'afii57695'       => 610,
        'afii57700'       => 278,
        'afii57705'       => 533,
        'afii57716'       => 557,
        'afii57717'       => 545,
        'afii57718'       => 533,
        'afii57723'       => 278,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 291,
        'afii57929'       => 333,
        'afii61248'       => 833,
        'afii61289'       => 479,
        'afii61352'       => 954,
        'afii61573'       => 750,
        'afii61574'       => 750,
        'afii61575'       => 750,
        'afii61664'       => 0,
        'afii63167'       => 525,
        'afii64937'       => 333,
        'agrave'       => 444,                                    # +1
        'ahookabove'       => 444,                                # (+1)
        'aiecyrillic'       => 666,
        'ainfinalarabic'       => 450,
        'aininitialarabic'       => 525,
        'ainmedialarabic'       => 394,
        'ainvertedbreve'       => 444,                            # (+1)
        'alefdageshhebrew'       => 481,
        'aleffinalarabic'       => 229,
        'alefhamzaabovefinalarabic'       => 229,
        'alefhamzabelowfinalarabic'       => 229,
        'aleflamedhebrew'       => 501,
        'alefmaddaabovefinalarabic'       => 229,
        'alefmaksurafinalarabic'       => 588,
        'alefmaksurainitialarabic'       => 244,
        'alefmaksuramedialarabic'       => 244,
        'alefpatahhebrew'       => 481,
        'alefqamatshebrew'       => 481,
        'aleph'       => 592,
        'alpha'       => 523,
        'alphatonos'       => 523,
        'amacron'       => 444,                                   # +1
        'ampersand'       => 778,                                 # +1
        'angstrom'       => 722,
        'anoteleia'       => 277,
        'aogonek'       => 444,                                   # +1
        'apostrophearmenian'       => 249,
        'approxequal'       => 548,
        'arighthalfring'       => 444,                            # (+1)
        'aring'       => 444,                                     # +1
        'aringacute'       => 444,                                # (+1)
        'aringbelow'       => 444,                                # (+1)
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 563,
        'arrowheadleftmod'       => 563,
        'arrowheadrightmod'       => 563,
        'arrowheadupmod'       => 563,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 469,
        'asciitilde'       => 541,
        'ascript'       => 522,
        'ascriptturned'       => 522,
        'asterisk'       => 500,
        'asterism'       => 938,
        'at'       => 921,                                        # +1
        'atilde'       => 444,                                    # +1
        'aturned'       => 444,                                   # (+1)
        'aybarmenian'       => 777,
        'ayinaltonehebrew'       => 454,
        'b'       => 500,
        'backslash'       => 278,                                 # +1
        'bar'       => 200,
        'bdotaccent'       => 500,
        'bdotbelow'       => 500,
        'behfinalarabic'       => 713,
        'behinitialarabic'       => 244,
        'behmedialarabic'       => 244,
        'benarmenian'       => 499,
        'bernou'       => 926,
        'beta'       => 508,
        'betasymbolgreek'       => 508,
        'betdagesh'       => 455,
        'beth'       => 559,
        'betrafehebrew'       => 455,
        'bhook'       => 500,
        'bilabialclick'       => 722,
        'blinebelow'       => 500,
        'block'       => 708,
        'braceleft'       => 480,                                 # +1
        'braceright'       => 480,                                # +1
        'bracketleft'       => 333,
        'bracketright'       => 333,
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 200,
        'bstroke'       => 500,
        'btopbar'       => 500,
        'bullet'       => 350,
        'c'       => 444,                                         # +1
        'caarmenian'       => 523,
        'cacute'       => 444,                                    # +1
        'candrabinducmb'       => 0,
        'caret'       => 326,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 444,                                    # +1
        'ccedilla'       => 444,                                  # +1
        'ccedillaacute'       => 444,                             # (+1)
        'ccircumflex'       => 444,                               # (+1)
        'ccurl'       => 444,                                     # (+1)
        'cdotaccent'       => 444,                                # (+1)
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 500,
        'centigrade'       => 1023,
        'chaarmenian'       => 284,
        'cheabkhasiancyrillic'       => 546,
        'chedescenderabkhasiancyrillic'       => 546,
        'chedescendercyrillic'       => 502,
        'chedieresiscyrillic'       => 502,
        'cheharmenian'       => 529,
        'chekhakassiancyrillic'       => 502,
        'cheverticalstrokecyrillic'       => 502,
        'chi'       => 443,
        'chook'       => 444,                                     # (+1)
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 249,
        'clickdental'       => 200,
        'clickretroflex'       => 333,
        'club'       => 656,
        'coarmenian'       => 506,
        'colon'       => 278,                                     # +1
        'colonmonetary'       => 666,
        'colontriangularhalfmod'       => 277,
        'colontriangularmod'       => 277,
        'comma'       => 250,
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
	'commaaccent'	=> 250,
        'commaarmenian'       => 207,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 333,
        'copyright'       => 760,                                 # +1
        'copysr'       => 736,
        'cruzeiro'       => 666,
        'cstretched'       => 444,                                # (+1)
        'currency'       => 500,
        'd'       => 500,
        'daarmenian'       => 560,
        'dadfinalarabic'       => 1098,
        'dadinitialarabic'       => 846,
        'dadmedialarabic'       => 846,
        'dagger'       => 500,
        'daggerdbl'       => 500,
        'daletdagesh'       => 418,
        'daleth'       => 515,
        'dalfinalarabic'       => 337,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 365,
        'dblverticalbar'       => 280,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 650,                        # afm 588 too narrow
        'dcedilla'       => 500,
        'dcircumflexbelow'       => 500,
        'dcroat'       => 500,
        'ddalfinalarabic'       => 337,
        'ddotaccent'       => 500,
        'ddotbelow'       => 500,
        'decimalseparatorarabic'       => 318,
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 385,
        'delta'       => 471,
        'deltaturned'       => 471,
        'dezh'       => 844,
        'dhook'       => 500,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 564,                        # was TTF 548
        'dkshade'       => 729,
        'dlinebelow'       => 500,
        'dnblock'       => 708,
        'dollar'       => 500,
        'dong'       => 512,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 277,
        'dotlessjstrokehook'       => 333,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 500,
        'dtopbar'       => 500,
        'dz'       => 943,
        'dzaltone'       => 802,
        'dzcaron'       => 943,
        'dzcurl'       => 853,
        'dzeabkhasiancyrillic'       => 443,
        'e'       => 444,                                         # +1
        'eacute'       => 444,                                    # +1
        'ebreve'       => 444,                                    # (+1)
        'ecaron'       => 444,                                    # +1
        'ecedillabreve'       => 444,                             # (+1)
        'echarmenian'       => 520,
        'echyiwnarmenian'       => 649,
        'ecircumflex'       => 444,                               # +1
        'ecircumflexacute'       => 444,                          # (+1)
        'ecircumflexbelow'       => 444,                          # (+1)
        'ecircumflexdotbelow'       => 444,                       # (+1)
        'ecircumflexgrave'       => 444,                          # (+1)
        'ecircumflexhookabove'       => 444,                      # (+1)
        'ecircumflextilde'       => 444,                          # (+1)
        'edblgrave'       => 444,                                 # (+1)
        'edieresis'       => 444,                                 # +1
        'edotaccent'       => 444,                                # +1
        'edotbelow'       => 444,                                 # (+1)
        'egrave'       => 444,                                    # +1
        'eharmenian'       => 432,
        'ehookabove'       => 444,                                # (+1)
        'eight'       => 500,
        'eightinferior'       => 299,
        'eightpersian'       => 525,
        'eightroman'       => 1254,
        'eightsuperior'       => 299,
        'einvertedbreve'       => 444,                            # (+1)
        'eiotifiedcyrillic'       => 677,
        'elevenroman'       => 758,
        'ellipsis'       => 1000,
        'emacron'       => 444,                                   # +1
        'emacronacute'       => 444,                              # (+1)
        'emacrongrave'       => 444,                              # (+1)
        'emdash'       => 1000,
        'emphasismarkarmenian'       => 166,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 500,
        'endescendercyrillic'       => 535,
        'eng'       => 494,
        'enghecyrillic'       => 623,
        'enhookcyrillic'       => 535,
        'enspace'       => 500,
        'eogonek'       => 444,                                   # +1
        'eopen'       => 419,
        'eopenclosed'       => 442,
        'eopenreversed'       => 419,
        'eopenreversedclosed'       => 442,
        'eopenreversedhook'       => 587,
        'epsilon'       => 419,
        'epsilontonos'       => 419,
        'equal'       => 564,                                     # +1
        'equalsuperior'       => 338,
        'equivalence'       => 563,
        'ereversed'       => 444,                                 # (+1)
        'esdescendercyrillic'       => 443,
        'esh'       => 333,
        'eshcurl'       => 333,
        'eshreversedloop'       => 343,
        'eshsquatreversed'       => 436,
        'estimated'       => 600,
        'eta'       => 522,
        'etarmenian'       => 509,
        'etatonos'       => 522,
        'eth'       => 500,
        'etilde'       => 444,                                    # (+1)
        'etildebelow'       => 444,                               # (+1)
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 444,                                   # (+1)
        'exclam'       => 333,
        'exclamarmenian'       => 120,
        'exclamdbl'       => 572,
        'exclamdown'       => 333,
        'ezh'       => 443,
        'ezhcaron'       => 443,
        'ezhcurl'       => 443,
        'ezhreversed'       => 443,
        'ezhtail'       => 443,
        'f'       => 333,
        'fahrenheit'       => 913,
        'fdotaccent'       => 333,
        'feharmenian'       => 689,
        'fehfinalarabic'       => 788,
        'fehinitialarabic'       => 267,
        'fehmedialarabic'       => 262,
        'feicoptic'       => 520,
        'female'       => 750,
        'ff'       => 604,
        'ffi'       => 847,
        'ffl'       => 832,
        'fi'       => 556,
        'figuredash'       => 500,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 452,
        'five'       => 500,
        'fiveeighths'       => 750,
        'fiveinferior'       => 299,
        'fivepersian'       => 525,
        'fiveroman'       => 500,
        'fivesuperior'       => 299,
        'fl'       => 556,
        'florin'       => 500,
        'four'       => 500,
        'fourinferior'       => 299,
        'fourpersian'       => 525,
        'fourroman'       => 739,
        'foursuperior'       => 299,
        'fourthtonechinese'       => 333,
        'frac15'       => 750,
        'frac16'       => 750,
        'frac25'       => 750,
        'frac35'       => 750,
        'frac45'       => 750,
        'frac56'       => 750,
        'fraction'       => 167,                                  # +1
        'franc'       => 500,
        'g'       => 500,
        'gacute'       => 500,
        'gaffinalarabic'       => 932,
        'gafinitialarabic'       => 394,
        'gafmedialarabic'       => 514,
        'gamma'       => 441,
        'gammad'       => 446,
        'gammalatinsmall'       => 500,
        'gammasuperior'       => 292,
        'gangiacoptic'       => 581,
        'gbreve'       => 500,
        'gcaron'       => 500,
        'gcircumflex'       => 500,
        'gcommaaccent'       => 500,
        'gdotaccent'       => 500,
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 208,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 500,
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 371,
        'ghadarmenian'       => 530,
        'ghainfinalarabic'       => 450,
        'ghaininitialarabic'       => 525,
        'ghainmedialarabic'       => 394,
        'ghemiddlehookcyrillic'       => 515,
        'ghestrokecyrillic'       => 410,
        'ghook'       => 500,
        'gimarmenian'       => 541,
        'gimel'       => 412,
        'gimeldagesh'       => 335,
        'glottalinvertedstroke'       => 421,
        'glottalstop'       => 443,
        'glottalstopinverted'       => 443,
        'glottalstopmod'       => 248,
        'glottalstopreversed'       => 443,
        'glottalstopreversedmod'       => 248,
        'glottalstopreversedsuperior'       => 248,
        'glottalstopstroke'       => 443,
        'glottalstopstrokereversed'       => 443,
        'gmacron'       => 500,
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 564,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 500,
        'gstroke'       => 500,
        'guillemotleft'       => 500,
        'guillemotright'       => 500,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 500,
        'haabkhasiancyrillic'       => 443,
        'hadescendercyrillic'       => 500,
        'hahfinalarabic'       => 525,
        'hahinitialarabic'       => 529,
        'hahmedialarabic'       => 529,
        'hairsp'       => 83,
        'hamilt'       => 905,
        'hbar'       => 500,
        'hbrevebelow'       => 500,
        'hcedilla'       => 500,
        'hcircumflex'       => 500,
        'hdieresis'       => 500,
        'hdotaccent'       => 500,
        'hdotbelow'       => 500,
        'heart'       => 593,
        'hedagesh'       => 471,
        'hehfinalaltonearabic'       => 387,
        'hehfinalalttwoarabic'       => 375,
        'hehhamzaabovefinalarabic'       => 375,
        'hehhamzaaboveisolatedarabic'       => 282,
        'hehinitialaltonearabic'       => 244,
        'hehinitialarabic'       => 450,
        'hehmedialaltonearabic'       => 320,
        'hehmedialarabic'       => 394,
        'henghook'       => 500,
        'hhook'       => 500,
        'hhooksuperior'       => 321,
        'hlinebelow'       => 500,
        'hoarmenian'       => 519,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 541,
        'horncmb'       => 0,
        'house'       => 600,
        'hsuperior'       => 321,
        'hturned'       => 500,
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 770,
        'hybull'       => 333,
        'hyphen'       => 333,
        'hyphentwo'       => 333,
        'i'       => 278,                                         # +1
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 278,                                    # (+1)
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 535,
        'idotbelow'       => 278,                                 # (+1)
        'iebrevecyrillic'       => 443,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 278,                                # (+1)
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 552,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 535,
        'infinity'       => 712,
        'iniarmenian'       => 514,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 722,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 278,                                   # +1
        'iota'       => 269,
        'iotadieresis'       => 269,
        'iotadieresistonos'       => 269,
        'iotalatin'       => 269,
        'iotatonos'       => 269,
        'istroke'       => 278,                                   # (+1)
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 278,                               # (+1)
        'izhitsadblgravecyrillic'       => 588,
        'j'       => 278,                                         # +1
        'jaarmenian'       => 510,
        'jcaron'       => 278,                                    # (+1)
        'jcircumflex'       => 278,                               # (+1)
        'jcrossedtail'       => 278,                              # (+1)
        'jdotlessstroke'       => 333,
        'jeemfinalarabic'       => 525,
        'jeeminitialarabic'       => 529,
        'jeemmedialarabic'       => 529,
        'jehfinalarabic'       => 488,
        'jheharmenian'       => 446,
        'jsuperior'       => 155,
        'k'       => 500,
        'kabashkircyrillic'       => 573,
        'kacute'       => 500,
        'kadescendercyrillic'       => 485,
        'kafdagesh'       => 432,
        'kaffinalarabic'       => 601,
        'kafinitialarabic'       => 394,
        'kafmedialarabic'       => 394,
        'kafrafehebrew'       => 432,
        'kahookcyrillic'       => 515,
        'kappa'       => 503,
        'kappasymbolgreek'       => 560,
        'kastrokecyrillic'       => 485,
        'kaverticalstrokecyrillic'       => 485,
        'kcaron'       => 500,
        'kcommaaccent'       => 500,
        'kdotbelow'       => 500,
        'keharmenian'       => 519,
        'kenarmenian'       => 514,
        'kgreenlandic'       => 500,
        'khahfinalarabic'       => 525,
        'khahinitialarabic'       => 529,
        'khahmedialarabic'       => 529,
        'kheicoptic'       => 443,
        'khook'       => 500,
        'klinebelow'       => 500,
        'koppacyrillic'       => 443,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 395,
        'kturned'       => 500,
        'l'       => 278,                                         # +1
        'lacute'       => 278,                                    # +1
        'lagran'       => 708,
        'lamaleffinalarabic'       => 600,
        'lamalefhamzaabovefinalarabic'       => 600,
        'lamalefhamzaaboveisolatedarabic'       => 543,
        'lamalefhamzabelowfinalarabic'       => 600,
        'lamalefhamzabelowisolatedarabic'       => 543,
        'lamalefisolatedarabic'       => 543,
        'lamalefmaddaabovefinalarabic'       => 600,
        'lamalefmaddaaboveisolatedarabic'       => 543,
        'lambda'       => 484,
        'lambdastroke'       => 484,
        'lameddagesh'       => 431,
        'lamfinalarabic'       => 506,
        'laminitialarabic'       => 207,
        'lamlamhehisolatedarabic'       => 792,
        'lammedialarabic'       => 207,
        'lbar'       => 278,                                      # (+1)
        'lbelt'       => 278,                                     # (+1)
        'lcaron'       => 400,          # afm 344 too narrow, TTF 406 too wide
        'lcircumflexbelow'       => 278,                          # (+1)
        'lcommaaccent'       => 278,                              # +1
        'ldot'       => 343,
        'ldotbelow'       => 278,                                 # (+1)
        'ldotbelowmacron'       => 278,                           # (+1)
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 564,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 577,
        'lfblock'       => 708,
        'lhookretroflex'       => 278,                            # (+1)
        'lira'       => 500,
        'liwnarmenian'       => 232,
        'lj'       => 555,
        'llinebelow'       => 278,                                # (+1)
        'lmiddletilde'       => 278,                              # (+1)
        'logicalnot'       => 564,                                # +1
        'longs'       => 277,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,                       # afm 471 too narrow
        'lslash'       => 278,                                    # +1
        'ltshade'       => 708,
        'm'       => 778,                                         # +1
        'macron'       => 500,                        # afm 333 too narrow
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 778,                                    # (+1)
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 778,                                # (+1)
        'mdotbelow'       => 778,                                 # (+1)
        'meemfinalarabic'       => 337,
        'meeminitialarabic'       => 394,
        'meemmedialarabic'       => 394,
        'memdagesh'       => 485,
        'menarmenian'       => 531,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 778,                                     # (+1)
        'minus'       => 564,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 218,
        'mlonglegturned'       => 778,                            # (+1)
        'mturned'       => 778,                                   # (+1)
        'mu'       => 536,                            # afm 500 too narrow
        'multiply'       => 564,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 500,
        'nacute'       => 500,
        'napostrophe'       => 604,
        'ncaron'       => 500,
        'ncircumflexbelow'       => 500,
        'ncommaaccent'       => 500,
        'ndotaccent'       => 500,
        'ndotbelow'       => 500,
        'nhookleft'       => 500,
        'nhookretroflex'       => 500,
        'nine'       => 500,
        'nineinferior'       => 299,
        'ninepersian'       => 525,
        'nineroman'       => 766,
        'ninesuperior'       => 299,
        'nj'       => 777,
        'nlegrightlong'       => 500,
        'nlinebelow'       => 500,
        'noonfinalarabic'       => 525,
        'noonghunnafinalarabic'       => 525,
        'noonhehinitialarabic'       => 244,
        'noonmedialarabic'       => 244,
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 514,
        'nsuperior'       => 314,
        'ntilde'       => 500,
        'nu'       => 452,
        'numbersign'       => 500,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 500,
        'nundagesh'       => 304,
        'o'       => 500,
        'oacute'       => 500,
        'obarred'       => 500,
        'obarredcyrillic'       => 500,
        'obarreddieresiscyrillic'       => 500,
        'obreve'       => 500,
        'ocaron'       => 500,
        'ocircumflex'       => 500,
        'ocircumflexacute'       => 500,
        'ocircumflexdotbelow'       => 500,
        'ocircumflexgrave'       => 500,
        'ocircumflexhookabove'       => 500,
        'ocircumflextilde'       => 500,
        'odblgrave'       => 500,
        'odieresis'       => 500,
        'odieresiscyrillic'       => 500,
        'odotbelow'       => 500,
        'oe'       => 722,
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 500,
        'oharmenian'       => 520,
        'ohookabove'       => 500,
        'ohorn'       => 528,
        'ohornacute'       => 528,
        'ohorndotbelow'       => 528,
        'ohorngrave'       => 528,
        'ohornhookabove'       => 528,
        'ohorntilde'       => 528,
        'ohungarumlaut'       => 500,
        'oi'       => 691,
        'oinvertedbreve'       => 500,
        'olehebrew'       => 0,
        'omacron'       => 500,
        'omacronacute'       => 500,
        'omacrongrave'       => 500,
        'omega'       => 658,
        'omega1'       => 658,
        'omegacyrillic'       => 633,
        'omegalatinclosed'       => 658,
        'omegaroundcyrillic'       => 565,
        'omegatitlocyrillic'       => 791,
        'omegatonos'       => 658,
        'omicron'       => 500,
        'omicrontonos'       => 500,
        'one'       => 500,
        'onedotenleader'       => 333,
        'oneeighth'       => 750,
        'onehalf'       => 750,
        'oneinferior'       => 299,
        'onepersian'       => 525,
        'onequarter'       => 750,
        'oneroman'       => 277,
        'onesuperior'       => 300,                               # +1
        'onethird'       => 750,
        'oogonek'       => 500,
        'oogonekmacron'       => 500,
        'oopen'       => 443,
        'openbullet'       => 354,
        'order'       => 405,
        'ordfeminine'       => 276,                               # +1
        'ordmasculine'       => 310,
        'orthogonal'       => 979,
        'oslash'       => 500,
        'oslashacute'       => 500,
        'otcyrillic'       => 633,
        'otilde'       => 500,
        'otildeacute'       => 500,
        'otildedieresis'       => 500,
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 500,
        'pacute'       => 500,
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 333,
        'paragraph'       => 453,
        'parenleft'       => 333,
        'parenleftaltonearabic'       => 318,
        'parenleftinferior'       => 199,
        'parenleftsuperior'       => 199,
        'parenright'       => 333,
        'parenrightaltonearabic'       => 318,
        'parenrightinferior'       => 199,
        'parenrightsuperior'       => 199,
        'partialdiff'       => 500,         # both afm 476 TTF 494 too narrow
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 500,
        'pedagesh'       => 440,
        'pefinaldageshhebrew'       => 454,
        'peharmenian'       => 772,
        'pehfinalarabic'       => 713,
        'pehinitialarabic'       => 244,
        'pehmedialarabic'       => 244,
        'pemiddlehookcyrillic'       => 789,
        'perafehebrew'       => 440,
        'percent'       => 833,
        'period'       => 250,
        'periodarmenian'       => 277,
        'periodcentered'       => 250,
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 968,
        'phi'       => 577,
        'phi1'       => 526,
        'philatin'       => 553,
        'phmmat'       => 1115,
        'phook'       => 500,
        'pi'       => 504,
        'piwrarmenian'       => 776,
        'planck'       => 500,
        'plus'       => 564,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 564,                     # was TTF 548
        'plusmod'       => 333,
        'plussuperior'       => 338,
        'prescription'       => 666,
        'primemod'       => 218,
        'primereversed'       => 218,
        'product'       => 823,
        'psi'       => 625,
        'psicyrillic'       => 625,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 250,
        'q'       => 500,
        'qadmahebrew'       => 0,
        'qaffinalarabic'       => 581,
        'qafinitialarabic'       => 267,
        'qafmedialarabic'       => 262,
        'qarneyparahebrew'       => 0,
        'qhook'       => 500,
        'qofdagesh'       => 473,
        'question'       => 444,                                  # +1
        'questionarmenian'       => 242,
        'questiondown'       => 444,                              # +1
        'questiongreek'       => 277,
        'quotedbl'       => 408,
        'quotedblbase'       => 444,                              # +1
        'quotedblleft'       => 444,                              # +1
        'quotedblright'       => 444,                             # +1
        'quoteleft'       => 333,
        'quotereversed'       => 333,
        'quoteright'       => 333,
        'quotesinglbase'       => 333,
        'quotesingle'       => 180,
        'r'       => 333,
        'raarmenian'       => 534,
        'racute'       => 333,
        'radical'       => 553,             # afm 453 TTF 548 too narrow
        'ramshorn'       => 443,
        'rcaron'       => 333,
        'rcommaaccent'       => 333,
        'rdblgrave'       => 333,
        'rdotaccent'       => 333,
        'rdotbelow'       => 333,
        'rdotbelowmacron'       => 333,
        'referencemark'       => 1000,
        'registered'       => 760,                                # +1
        'reharmenian'       => 509,
        'rehfinalarabic'       => 488,
        'reshdageshhebrew'       => 468,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 563,
        'rfishhook'       => 333,
        'rfishhookreversed'       => 333,
        'rho'       => 499,
        'rhook'       => 333,
        'rhookturned'       => 333,
        'rhookturnedsuperior'       => 217,
        'rhosymbolgreek'       => 508,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 199,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 333,
        'rlinebelow'       => 333,
        'rlongleg'       => 333,
        'rlonglegturned'       => 333,
        'rrehfinalarabic'       => 488,
        'rtblock'       => 708,
        'rturned'       => 333,
        'rturnedsuperior'       => 217,
        's'       => 389,
        'sacute'       => 389,
        'sacutedotaccent'       => 389,
        'sadfinalarabic'       => 1098,
        'sadinitialarabic'       => 846,
        'sadmedialarabic'       => 846,
        'sallallahoualayhewasallamarabic'       => 731,
        'samekhdagesh'       => 475,
        'scaron'       => 389,
        'scarondotaccent'       => 389,
        'scedilla'       => 389,
        'schwadieresiscyrillic'       => 443,
        'schwahook'       => 626,
        'scircumflex'       => 389,
        'scommaaccent'       => 389,
        'sdotaccent'       => 389,
        'sdotbelow'       => 389,
        'sdotbelowdotaccent'       => 389,
        'seagullbelowcmb'       => 0,
        'second'       => 416,
        'secondtonechinese'       => 333,
        'section'       => 500,
        'seenfinalarabic'       => 821,
        'seeninitialarabic'       => 530,
        'seenmedialarabic'       => 530,
        'segoltahebrew'       => 0,
        'seharmenian'       => 511,
	'semicolon'	=> 278,
        'seven'       => 500,
        'seveneighths'       => 750,
        'seveninferior'       => 299,
        'sevenpersian'       => 525,
        'sevenroman'       => 1007,
        'sevensuperior'       => 299,
        'shaarmenian'       => 391,
        'shaddadammaarabic'       => 0,
        'shaddadammatanarabic'       => 0,
        'shaddafathaarabic'       => 0,
        'shaddakasraarabic'       => 0,
        'shaddakasratanarabic'       => 0,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheenfinalarabic'       => 821,
        'sheeninitialarabic'       => 530,
        'sheenmedialarabic'       => 530,
        'sheicoptic'       => 777,
        'shhacyrillic'       => 500,
        'shimacoptic'       => 508,
        'shindagesh'       => 610,
        'shindageshshindot'       => 610,
        'shindageshsindot'       => 610,
        'shook'       => 389,
        'sigma'       => 539,
        'sigma1'       => 395,
        'sigmalunatesymbolgreek'       => 443,
        'six'       => 500,
        'sixinferior'       => 299,
        'sixpersian'       => 525,
        'sixroman'       => 761,
        'sixsuperior'       => 299,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 277,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 250,
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 500,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 712,                     # afm 600 too narrow
        'sun'       => 916,
        't'       => 278,                                         # +1
        'tahfinalarabic'       => 581,
        'tahinitialarabic'       => 581,
        'tahmedialarabic'       => 581,
        'tau'       => 401,
        'tavdages'       => 500,
        'tbar'       => 278,                                      # (+1)
        'tcaron'       => 430,                        # afm 326 too narrow
        'tccurl'       => 648,
        'tcedilla'       => 278,                                  # (+1)
        'tchehfinalarabic'       => 525,
        'tchehinitialarabic'       => 529,
        'tchehmedialarabic'       => 529,
        'tcircumflexbelow'       => 278,                          # (+1)
        'tcommaaccent'       => 278,                              # +1
        'tdieresis'       => 278,                                 # (+1)
        'tdotaccent'       => 278,                                # (+1)
        'tdotbelow'       => 278,                                 # (+1)
        'tedescendercyrillic'       => 437,
        'tehfinalarabic'       => 713,
        'tehinitialarabic'       => 244,
        'tehmarbutafinalarabic'       => 375,
        'tehmedialarabic'       => 244,
        'telephone'       => 1197,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tenroman'       => 500,
        'tesh'       => 459,
        'tetdagesh'       => 475,
        'tetsecyrillic'       => 603,
        'tevirhebrew'       => 0,
        'thalfinalarabic'       => 337,
        'thehfinalarabic'       => 713,
        'thehinitialarabic'       => 244,
        'thehmedialarabic'       => 244,
        'theta'       => 479,
        'theta1'       => 495,
        'thook'       => 278,                                     # (+1)
        'thorn'       => 500,
        'thousandcyrillic'       => 333,
        'thousandsseparatorarabic'       => 318,
        'three'       => 500,
        'threeeighths'       => 750,
        'threeinferior'       => 299,
        'threepersian'       => 525,
        'threequarters'       => 750,
        'threeroman'       => 770,
        'threesuperior'       => 300,                             # +1
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 777,
        'tlinebelow'       => 278,                                # (+1)
        'toarmenian'       => 642,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 443,
        'tonesix'       => 500,
        'tonetwo'       => 389,
        'tonos'       => 333,
        'tpalatalhook'       => 278,                              # (+1)
        'tprime'       => 416,
        'trademark'       => 980,                                 # +1
        'tretroflexhook'       => 278,                            # (+1)
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 564,
        'tsadidagesh'       => 459,
        'ttehfinalarabic'       => 713,
        'tturned'       => 278,                                   # (+1)
        'twelveroman'       => 1005,
        'two'       => 500,
        'twodotenleader'       => 666,
        'twoinferior'       => 299,
        'twopersian'       => 525,
        'tworoman'       => 524,
        'twostroke'       => 500,
        'twosuperior'       => 300,                               # +1
        'twothirds'       => 750,
        'u'       => 500,
        'uacute'       => 500,
        'ubar'       => 500,
        'ubreve'       => 500,
        'ucaron'       => 500,
        'ucircumflex'       => 500,
        'ucircumflexbelow'       => 500,
        'udblgrave'       => 500,
        'udieresis'       => 500,
        'udieresisacute'       => 500,
        'udieresisbelow'       => 500,
        'udieresiscaron'       => 500,
        'udieresiscyrillic'       => 500,
        'udieresisgrave'       => 500,
        'udieresismacron'       => 500,
        'udotbelow'       => 500,
        'ugrave'       => 500,
        'uhookabove'       => 500,
        'uhorn'       => 541,
        'uhornacute'       => 541,
        'uhorndotbelow'       => 541,
        'uhorngrave'       => 541,
        'uhornhookabove'       => 541,
        'uhorntilde'       => 541,
        'uhungarumlaut'       => 500,
        'uhungarumlautcyrillic'       => 500,
        'uinvertedbreve'       => 500,
        'ukcyrillic'       => 879,
        'umacron'       => 500,
        'umacroncyrillic'       => 500,
        'umacrondieresis'       => 500,
        'underscore'       => 500,
        'underscoredbl'       => 500,
        'uni01F6'       => 949,
        'uni01F7'       => 560,
        'uni01F8'       => 722,
        'uni01F9'       => 500,
        'uni021C'       => 562,
        'uni021D'       => 395,
        'uni021E'       => 722,
        'uni021F'       => 500,
        'uni0220'       => 649,
        'uni0221'       => 500,
        'uni0222'       => 603,
        'uni0223'       => 500,
        'uni0224'       => 610,
        'uni0225'       => 443,
        'uni0226'       => 722,
        'uni0227'       => 443,
        'uni0228'       => 610,
        'uni0229'       => 443,
        'uni022A'       => 722,
        'uni022B'       => 500,
        'uni022C'       => 722,
        'uni022D'       => 500,
        'uni022E'       => 722,
        'uni022F'       => 500,
        'uni0230'       => 722,
        'uni0231'       => 500,
        'uni0232'       => 722,
        'uni0233'       => 500,
        'uni0234'       => 277,
        'uni0235'       => 500,
        'uni0236'       => 316,
        'uni0238'       => 773,
        'uni0239'       => 772,
        'uni023A'       => 722,
        'uni023B'       => 666,
        'uni023C'       => 500,
        'uni023D'       => 610,
        'uni023E'       => 610,
        'uni023F'       => 389,
        'uni0240'       => 443,
        'uni0241'       => 533,
        'uni0242'       => 397,
        'uni0243'       => 666,
        'uni0244'       => 722,
        'uni0245'       => 725,
        'uni0246'       => 610,
        'uni0247'       => 443,
        'uni0248'       => 389,
        'uni0249'       => 277,
        'uni024A'       => 702,
        'uni024B'       => 500,
        'uni024C'       => 666,
        'uni024D'       => 333,
        'uni024E'       => 722,
        'uni024F'       => 500,
        'uni0262'       => 453,
        'uni026A'       => 277,
        'uni0274'       => 497,
        'uni0276'       => 629,
        'uni0280'       => 487,
        'uni028F'       => 492,
        'uni0299'       => 472,
        'uni029C'       => 535,
        'uni029F'       => 429,
        'uni02A9'       => 787,
        'uni02AA'       => 565,
        'uni02AB'       => 559,
        'uni02AC'       => 514,
        'uni02AD'       => 480,
        'uni02AE'       => 624,
        'uni02AF'       => 615,
        'uni02B3'       => 217,
        'uni02DF'       => 381,
        'uni02E1'       => 166,
        'uni02E2'       => 212,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 443,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 277,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 0,
        'uni0364'       => 0,
        'uni0365'       => 0,
        'uni0366'       => 0,
        'uni0367'       => 0,
        'uni0368'       => 0,
        'uni0369'       => 0,
        'uni036A'       => 0,
        'uni036B'       => 0,
        'uni036C'       => 0,
        'uni036D'       => 0,
        'uni036E'       => 0,
        'uni036F'       => 0,
        'uni0370'       => 551,
        'uni0371'       => 413,
        'uni0372'       => 610,
        'uni0373'       => 437,
        'uni0376'       => 722,
        'uni0377'       => 542,
        'uni037B'       => 443,
        'uni037C'       => 443,
        'uni037D'       => 443,
        'uni037F'       => 389,
        'uni03CF'       => 660,
        'uni03D7'       => 560,
        'uni03D8'       => 722,
        'uni03D9'       => 500,
        'uni03DB'       => 419,
        'uni03DF'       => 451,
        'uni03E1'       => 553,
        'uni03F4'       => 722,
        'uni03F5'       => 404,
        'uni03F6'       => 404,
        'uni03F7'       => 556,
        'uni03F8'       => 500,
        'uni03F9'       => 666,
        'uni03FA'       => 889,
        'uni03FB'       => 632,
        'uni03FC'       => 499,
        'uni03FD'       => 666,
        'uni03FE'       => 666,
        'uni03FF'       => 666,
        'uni0400'       => 610,
        'uni040D'       => 722,
        'uni0450'       => 443,
        'uni045D'       => 535,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 722,
        'uni048B'       => 535,
        'uni048C'       => 574,
        'uni048D'       => 470,
        'uni048E'       => 556,
        'uni048F'       => 500,
        'uni04C5'       => 678,
        'uni04C6'       => 499,
        'uni04C9'       => 722,
        'uni04CA'       => 535,
        'uni04CD'       => 889,
        'uni04CE'       => 632,
        'uni04CF'       => 277,
        'uni04EC'       => 660,
        'uni04ED'       => 429,
        'uni04F6'       => 578,
        'uni04F7'       => 410,
        'uni04FA'       => 578,
        'uni04FB'       => 410,
        'uni04FC'       => 722,
        'uni04FD'       => 500,
        'uni04FE'       => 722,
        'uni04FF'       => 500,
        'uni0500'       => 574,
        'uni0501'       => 500,
        'uni0502'       => 803,
        'uni0503'       => 770,
        'uni0504'       => 802,
        'uni0505'       => 705,
        'uni0506'       => 573,
        'uni0507'       => 452,
        'uni0508'       => 906,
        'uni0509'       => 751,
        'uni050A'       => 949,
        'uni050B'       => 787,
        'uni050C'       => 722,
        'uni050D'       => 453,
        'uni050E'       => 695,
        'uni050F'       => 601,
        'uni0510'       => 500,
        'uni0511'       => 395,
        'uni0512'       => 678,
        'uni0513'       => 499,
        'uni0514'       => 1030,
        'uni0515'       => 714,
        'uni0516'       => 818,
        'uni0517'       => 689,
        'uni0518'       => 937,
        'uni0519'       => 707,
        'uni051A'       => 722,
        'uni051B'       => 500,
        'uni051C'       => 943,
        'uni051D'       => 722,
        'uni051E'       => 666,
        'uni051F'       => 539,
        'uni0520'       => 953,
        'uni0521'       => 764,
        'uni0522'       => 996,
        'uni0523'       => 799,
        'uni0524'       => 722,
        'uni0525'       => 535,
        'uni0526'       => 649,
        'uni0527'       => 500,
        'uni0528'       => 716,
        'uni0529'       => 550,
        'uni052A'       => 1397,
        'uni052B'       => 1022,
        'uni052C'       => 665,
        'uni052D'       => 502,
        'uni052E'       => 678,
        'uni052F'       => 499,
        'uni058A'       => 369,
        'uni058D'       => 934,
        'uni058E'       => 934,
        'uni058F'       => 760,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 304,
        'uni05C7'       => 0,
        'uni0600'       => 936,
        'uni0601'       => 1299,
        'uni0602'       => 438,
        'uni0603'       => 1272,
        'uni0604'       => 1299,
        'uni0605'       => 0,
        'uni0606'       => 615,
        'uni0607'       => 615,
        'uni0608'       => 755,
        'uni0609'       => 604,
        'uni060A'       => 735,
        'uni060B'       => 262,
        'uni060D'       => 238,
        'uni060E'       => 656,
        'uni060F'       => 543,
        'uni0610'       => 0,
        'uni0611'       => 0,
        'uni0612'       => 0,
        'uni0613'       => 0,
        'uni0614'       => 0,
        'uni0615'       => 269,
        'uni0616'       => 0,
        'uni0617'       => 0,
        'uni0618'       => 0,
        'uni0619'       => 0,
        'uni061A'       => 0,
        'uni061C'       => 1000,
        'uni061E'       => 289,
        'uni0620'       => 638,
        'uni063B'       => 812,
        'uni063C'       => 812,
        'uni063D'       => 638,
        'uni063E'       => 638,
        'uni063F'       => 638,
        'uni0653'       => 0,
        'uni0655'       => 0,
        'uni0656'       => 0,
        'uni0657'       => 0,
        'uni0658'       => 0,
        'uni0659'       => 0,
        'uni065A'       => 0,
        'uni065B'       => 0,
        'uni065C'       => 0,
        'uni065D'       => 0,
        'uni065E'       => 0,
        'uni065F'       => 207,
        'uni066E'       => 713,
        'uni066F'       => 581,
        'uni0670'       => 0,
        'uni0672'       => 207,
        'uni0673'       => 207,
        'uni0674'       => 207,
        'uni0675'       => 207,
        'uni0676'       => 432,
        'uni0678'       => 638,
        'uni067C'       => 713,
        'uni067D'       => 713,
        'uni0681'       => 562,
        'uni0682'       => 562,
        'uni0685'       => 562,
        'uni0689'       => 337,
        'uni068A'       => 337,
        'uni068B'       => 337,
        'uni068F'       => 337,
        'uni0690'       => 337,
        'uni0692'       => 488,
        'uni0693'       => 488,
        'uni0694'       => 488,
        'uni0695'       => 488,
        'uni0696'       => 488,
        'uni0697'       => 488,
        'uni0699'       => 488,
        'uni069A'       => 821,
        'uni069B'       => 821,
        'uni069C'       => 821,
        'uni069D'       => 1098,
        'uni069E'       => 1098,
        'uni069F'       => 581,
        'uni06A0'       => 543,
        'uni06A1'       => 788,
        'uni06A2'       => 788,
        'uni06A3'       => 788,
        'uni06A5'       => 788,
        'uni06A7'       => 581,
        'uni06A8'       => 581,
        'uni06AA'       => 1155,
        'uni06AB'       => 812,
        'uni06AC'       => 601,
        'uni06AE'       => 601,
        'uni06B0'       => 812,
        'uni06B2'       => 812,
        'uni06B4'       => 812,
        'uni06B5'       => 506,
        'uni06B6'       => 506,
        'uni06B7'       => 506,
        'uni06B8'       => 506,
        'uni06B9'       => 525,
        'uni06BC'       => 525,
        'uni06BD'       => 525,
        'uni06BF'       => 562,
        'uni06C2'       => 387,
        'uni06C3'       => 387,
        'uni06C4'       => 432,
        'uni06CA'       => 432,
        'uni06CD'       => 638,
        'uni06CE'       => 638,
        'uni06CF'       => 432,
        'uni06D4'       => 207,
        'uni06D6'       => 0,
        'uni06D7'       => 0,
        'uni06D8'       => 0,
        'uni06D9'       => 0,
        'uni06DA'       => 0,
        'uni06DB'       => 0,
        'uni06DC'       => 0,
        'uni06DD'       => 1123,
        'uni06DE'       => 1084,
        'uni06DF'       => 0,
        'uni06E0'       => 0,
        'uni06E1'       => 0,
        'uni06E2'       => 0,
        'uni06E3'       => 0,
        'uni06E4'       => 0,
        'uni06E5'       => 193,
        'uni06E6'       => 370,
        'uni06E7'       => 0,
        'uni06E8'       => 0,
        'uni06E9'       => 600,
        'uni06EA'       => 0,
        'uni06EB'       => 0,
        'uni06EC'       => 0,
        'uni06ED'       => 0,
        'uni06EE'       => 337,
        'uni06EF'       => 488,
        'uni06FA'       => 821,
        'uni06FB'       => 1098,
        'uni06FC'       => 543,
        'uni06FD'       => 412,
        'uni06FE'       => 337,
        'uni06FF'       => 450,
        'uni0750'       => 713,
        'uni0751'       => 713,
        'uni0752'       => 713,
        'uni0753'       => 713,
        'uni0754'       => 713,
        'uni0755'       => 713,
        'uni0756'       => 713,
        'uni0757'       => 562,
        'uni0758'       => 562,
        'uni0759'       => 337,
        'uni075A'       => 337,
        'uni075B'       => 488,
        'uni075C'       => 821,
        'uni075D'       => 543,
        'uni075E'       => 543,
        'uni075F'       => 543,
        'uni0760'       => 788,
        'uni0761'       => 788,
        'uni0762'       => 812,
        'uni0763'       => 812,
        'uni0764'       => 812,
        'uni0765'       => 337,
        'uni0766'       => 337,
        'uni0767'       => 525,
        'uni0768'       => 525,
        'uni0769'       => 525,
        'uni076A'       => 506,
        'uni076B'       => 488,
        'uni076C'       => 488,
        'uni076D'       => 821,
        'uni076E'       => 562,
        'uni076F'       => 562,
        'uni0770'       => 821,
        'uni0771'       => 488,
        'uni0772'       => 562,
        'uni0773'       => 207,
        'uni0774'       => 207,
        'uni0775'       => 638,
        'uni0776'       => 638,
        'uni0777'       => 638,
        'uni0778'       => 432,
        'uni0779'       => 432,
        'uni077A'       => 812,
        'uni077B'       => 812,
        'uni077C'       => 562,
        'uni077D'       => 821,
        'uni077E'       => 821,
        'uni077F'       => 601,
        'uni08A0'       => 713,
        'uni08A1'       => 713,
        'uni08A2'       => 562,
        'uni08A3'       => 581,
        'uni08A4'       => 788,
        'uni08A5'       => 581,
        'uni08A6'       => 506,
        'uni08A7'       => 337,
        'uni08A8'       => 638,
        'uni08A9'       => 638,
        'uni08AA'       => 464,
        'uni08AB'       => 432,
        'uni08AC'       => 427,
        'uni08AD'       => 170,
        'uni08AE'       => 337,
        'uni08AF'       => 1098,
        'uni08B0'       => 812,
        'uni08B1'       => 282,
        'uni08B2'       => 488,
        'uni08B3'       => 543,
        'uni08B4'       => 601,
        'uni08B6'       => 713,
        'uni08B7'       => 713,
        'uni08B8'       => 713,
        'uni08B9'       => 488,
        'uni08BA'       => 638,
        'uni08BB'       => 788,
        'uni08BC'       => 581,
        'uni08BD'       => 525,
        'uni08D4'       => 0,
        'uni08D5'       => 0,
        'uni08D6'       => 0,
        'uni08D7'       => 0,
        'uni08D8'       => 0,
        'uni08D9'       => 0,
        'uni08DA'       => 0,
        'uni08DB'       => 0,
        'uni08DC'       => 0,
        'uni08DD'       => 0,
        'uni08DE'       => 0,
        'uni08DF'       => 0,
        'uni08E0'       => 0,
        'uni08E1'       => 0,
        'uni08E2'       => 483,
        'uni08E3'       => 0,
        'uni08E4'       => 0,
        'uni08E5'       => 0,
        'uni08E6'       => 0,
        'uni08E7'       => 0,
        'uni08E8'       => 0,
        'uni08E9'       => 0,
        'uni08EA'       => 0,
        'uni08EB'       => 0,
        'uni08EC'       => 0,
        'uni08ED'       => 0,
        'uni08EE'       => 0,
        'uni08EF'       => 0,
        'uni08F0'       => 0,
        'uni08F1'       => 0,
        'uni08F2'       => 0,
        'uni08F3'       => 0,
        'uni08F4'       => 0,
        'uni08F5'       => 0,
        'uni08F6'       => 0,
        'uni08F7'       => 0,
        'uni08F8'       => 0,
        'uni08F9'       => 0,
        'uni08FA'       => 0,
        'uni08FB'       => 0,
        'uni08FC'       => 0,
        'uni08FD'       => 0,
        'uni08FE'       => 0,
        'uni08FF'       => 0,
        'uni1D00'       => 502,
        'uni1D01'       => 645,
        'uni1D02'       => 666,
        'uni1D03'       => 464,
        'uni1D04'       => 478,
        'uni1D05'       => 524,
        'uni1D06'       => 524,
        'uni1D07'       => 444,
        'uni1D08'       => 395,
        'uni1D09'       => 277,
        'uni1D0A'       => 296,
        'uni1D0B'       => 539,
        'uni1D0C'       => 444,
        'uni1D0D'       => 632,
        'uni1D0E'       => 535,
        'uni1D0F'       => 500,
        'uni1D10'       => 478,
        'uni1D11'       => 541,
        'uni1D12'       => 537,
        'uni1D13'       => 541,
        'uni1D14'       => 722,
        'uni1D15'       => 436,
        'uni1D16'       => 500,
        'uni1D17'       => 500,
        'uni1D18'       => 456,
        'uni1D19'       => 459,
        'uni1D1A'       => 459,
        'uni1D1B'       => 437,
        'uni1D1C'       => 537,
        'uni1D1D'       => 504,
        'uni1D1E'       => 654,
        'uni1D1F'       => 504,
        'uni1D20'       => 500,
        'uni1D21'       => 722,
        'uni1D22'       => 443,
        'uni1D23'       => 395,
        'uni1D24'       => 397,
        'uni1D25'       => 538,
        'uni1D26'       => 410,
        'uni1D27'       => 500,
        'uni1D28'       => 535,
        'uni1D29'       => 456,
        'uni1D2A'       => 528,
        'uni1D2B'       => 499,
        'uni1D2C'       => 421,
        'uni1D2D'       => 538,
        'uni1D2E'       => 386,
        'uni1D2F'       => 386,
        'uni1D30'       => 429,
        'uni1D31'       => 370,
        'uni1D32'       => 370,
        'uni1D33'       => 432,
        'uni1D34'       => 440,
        'uni1D35'       => 199,
        'uni1D36'       => 246,
        'uni1D37'       => 458,
        'uni1D38'       => 371,
        'uni1D39'       => 540,
        'uni1D3A'       => 462,
        'uni1D3B'       => 440,
        'uni1D3C'       => 417,
        'uni1D3D'       => 335,
        'uni1D3E'       => 331,
        'uni1D3F'       => 409,
        'uni1D40'       => 362,
        'uni1D41'       => 453,
        'uni1D42'       => 553,
        'uni1D43'       => 273,
        'uni1D44'       => 273,
        'uni1D45'       => 313,
        'uni1D46'       => 390,
        'uni1D47'       => 309,
        'uni1D48'       => 311,
        'uni1D49'       => 256,
        'uni1D4A'       => 256,
        'uni1D4B'       => 241,
        'uni1D4C'       => 241,
        'uni1D4D'       => 300,
        'uni1D4E'       => 163,
        'uni1D4F'       => 315,
        'uni1D50'       => 488,
        'uni1D51'       => 281,
        'uni1D52'       => 288,
        'uni1D53'       => 255,
        'uni1D54'       => 288,
        'uni1D55'       => 288,
        'uni1D56'       => 311,
        'uni1D57'       => 191,
        'uni1D58'       => 327,
        'uni1D59'       => 305,
        'uni1D5A'       => 488,
        'uni1D5B'       => 293,
        'uni1D5C'       => 318,
        'uni1D5D'       => 282,
        'uni1D5E'       => 265,
        'uni1D5F'       => 270,
        'uni1D60'       => 334,
        'uni1D61'       => 282,
        'uni1D62'       => 163,
        'uni1D63'       => 229,
        'uni1D64'       => 327,
        'uni1D65'       => 293,
        'uni1D66'       => 282,
        'uni1D67'       => 265,
        'uni1D68'       => 295,
        'uni1D69'       => 334,
        'uni1D6A'       => 282,
        'uni1D6B'       => 760,
        'uni1D6C'       => 500,
        'uni1D6D'       => 500,
        'uni1D6E'       => 333,
        'uni1D6F'       => 777,
        'uni1D70'       => 500,
        'uni1D71'       => 500,
        'uni1D72'       => 333,
        'uni1D73'       => 333,
        'uni1D74'       => 389,
        'uni1D75'       => 277,
        'uni1D76'       => 443,
        'uni1D77'       => 500,
        'uni1D78'       => 323,
        'uni1D79'       => 471,
        'uni1D7A'       => 766,
        'uni1D7B'       => 277,
        'uni1D7C'       => 269,
        'uni1D7D'       => 500,
        'uni1D7E'       => 537,
        'uni1D7F'       => 548,
        'uni1D80'       => 500,
        'uni1D81'       => 500,
        'uni1D82'       => 333,
        'uni1D83'       => 596,
        'uni1D84'       => 500,
        'uni1D85'       => 277,
        'uni1D86'       => 777,
        'uni1D87'       => 500,
        'uni1D88'       => 500,
        'uni1D89'       => 333,
        'uni1D8A'       => 389,
        'uni1D8B'       => 424,
        'uni1D8C'       => 500,
        'uni1D8D'       => 500,
        'uni1D8E'       => 443,
        'uni1D8F'       => 443,
        'uni1D90'       => 522,
        'uni1D91'       => 500,
        'uni1D92'       => 443,
        'uni1D93'       => 419,
        'uni1D94'       => 419,
        'uni1D95'       => 443,
        'uni1D96'       => 277,
        'uni1D97'       => 443,
        'uni1D98'       => 439,
        'uni1D99'       => 500,
        'uni1D9A'       => 443,
        'uni1D9B'       => 313,
        'uni1D9C'       => 255,
        'uni1D9D'       => 255,
        'uni1D9E'       => 287,
        'uni1D9F'       => 241,
        'uni1DA0'       => 208,
        'uni1DA1'       => 208,
        'uni1DA2'       => 266,
        'uni1DA3'       => 321,
        'uni1DA4'       => 163,
        'uni1DA5'       => 182,
        'uni1DA6'       => 164,
        'uni1DA7'       => 164,
        'uni1DA8'       => 192,
        'uni1DA9'       => 163,
        'uni1DAA'       => 163,
        'uni1DAB'       => 270,
        'uni1DAC'       => 447,
        'uni1DAD'       => 488,
        'uni1DAE'       => 327,
        'uni1DAF'       => 327,
        'uni1DB0'       => 321,
        'uni1DB1'       => 288,
        'uni1DB2'       => 320,
        'uni1DB3'       => 212,
        'uni1DB4'       => 215,
        'uni1DB5'       => 191,
        'uni1DB6'       => 327,
        'uni1DB7'       => 316,
        'uni1DB8'       => 325,
        'uni1DB9'       => 290,
        'uni1DBA'       => 293,
        'uni1DBB'       => 273,
        'uni1DBC'       => 273,
        'uni1DBD'       => 303,
        'uni1DBE'       => 265,
        'uni1DBF'       => 269,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 333,
        'uni1E9D'       => 333,
        'uni1E9E'       => 713,
        'uni1E9F'       => 471,
        'uni1EFA'       => 854,
        'uni1EFB'       => 526,
        'uni1EFC'       => 541,
        'uni1EFD'       => 496,
        'uni1EFE'       => 650,
        'uni1EFF'       => 548,
        'uni1F00'       => 523,
        'uni1F01'       => 523,
        'uni1F02'       => 523,
        'uni1F03'       => 523,
        'uni1F04'       => 523,
        'uni1F05'       => 523,
        'uni1F06'       => 523,
        'uni1F07'       => 523,
        'uni1F08'       => 722,
        'uni1F09'       => 722,
        'uni1F0A'       => 791,
        'uni1F0B'       => 791,
        'uni1F0C'       => 791,
        'uni1F0D'       => 791,
        'uni1F0E'       => 791,
        'uni1F0F'       => 791,
        'uni1F10'       => 419,
        'uni1F11'       => 419,
        'uni1F12'       => 419,
        'uni1F13'       => 419,
        'uni1F14'       => 419,
        'uni1F15'       => 419,
        'uni1F18'       => 748,
        'uni1F19'       => 748,
        'uni1F1A'       => 904,
        'uni1F1B'       => 904,
        'uni1F1C'       => 904,
        'uni1F1D'       => 904,
        'uni1F20'       => 522,
        'uni1F21'       => 522,
        'uni1F22'       => 522,
        'uni1F23'       => 522,
        'uni1F24'       => 522,
        'uni1F25'       => 522,
        'uni1F26'       => 522,
        'uni1F27'       => 522,
        'uni1F28'       => 859,
        'uni1F29'       => 859,
        'uni1F2A'       => 1015,
        'uni1F2B'       => 1015,
        'uni1F2C'       => 1015,
        'uni1F2D'       => 1015,
        'uni1F2E'       => 1015,
        'uni1F2F'       => 1015,
        'uni1F30'       => 269,
        'uni1F31'       => 269,
        'uni1F32'       => 269,
        'uni1F33'       => 269,
        'uni1F34'       => 269,
        'uni1F35'       => 269,
        'uni1F36'       => 269,
        'uni1F37'       => 269,
        'uni1F38'       => 470,
        'uni1F39'       => 470,
        'uni1F3A'       => 626,
        'uni1F3B'       => 626,
        'uni1F3C'       => 626,
        'uni1F3D'       => 626,
        'uni1F3E'       => 626,
        'uni1F3F'       => 626,
        'uni1F40'       => 500,
        'uni1F41'       => 500,
        'uni1F42'       => 500,
        'uni1F43'       => 500,
        'uni1F44'       => 500,
        'uni1F45'       => 500,
        'uni1F48'       => 791,
        'uni1F49'       => 791,
        'uni1F4A'       => 996,
        'uni1F4B'       => 996,
        'uni1F4C'       => 898,
        'uni1F4D'       => 898,
        'uni1F50'       => 495,
        'uni1F51'       => 495,
        'uni1F52'       => 495,
        'uni1F53'       => 495,
        'uni1F54'       => 495,
        'uni1F55'       => 495,
        'uni1F56'       => 495,
        'uni1F57'       => 495,
        'uni1F59'       => 859,
        'uni1F5B'       => 1020,
        'uni1F5D'       => 1020,
        'uni1F5F'       => 1020,
        'uni1F60'       => 658,
        'uni1F61'       => 658,
        'uni1F62'       => 658,
        'uni1F63'       => 658,
        'uni1F64'       => 658,
        'uni1F65'       => 658,
        'uni1F66'       => 658,
        'uni1F67'       => 658,
        'uni1F68'       => 812,
        'uni1F69'       => 812,
        'uni1F6A'       => 997,
        'uni1F6B'       => 997,
        'uni1F6C'       => 929,
        'uni1F6D'       => 929,
        'uni1F6E'       => 929,
        'uni1F6F'       => 929,
        'uni1F70'       => 523,
        'uni1F71'       => 523,
        'uni1F72'       => 419,
        'uni1F73'       => 419,
        'uni1F74'       => 522,
        'uni1F75'       => 522,
        'uni1F76'       => 269,
        'uni1F77'       => 269,
        'uni1F78'       => 500,
        'uni1F79'       => 500,
        'uni1F7A'       => 495,
        'uni1F7B'       => 495,
        'uni1F7C'       => 658,
        'uni1F7D'       => 658,
        'uni1F80'       => 523,
        'uni1F81'       => 523,
        'uni1F82'       => 523,
        'uni1F83'       => 523,
        'uni1F84'       => 523,
        'uni1F85'       => 523,
        'uni1F86'       => 523,
        'uni1F87'       => 523,
        'uni1F88'       => 722,
        'uni1F89'       => 722,
        'uni1F8A'       => 791,
        'uni1F8B'       => 791,
        'uni1F8C'       => 791,
        'uni1F8D'       => 791,
        'uni1F8E'       => 791,
        'uni1F8F'       => 791,
        'uni1F90'       => 522,
        'uni1F91'       => 522,
        'uni1F92'       => 522,
        'uni1F93'       => 522,
        'uni1F94'       => 522,
        'uni1F95'       => 522,
        'uni1F96'       => 522,
        'uni1F97'       => 522,
        'uni1F98'       => 859,
        'uni1F99'       => 859,
        'uni1F9A'       => 1015,
        'uni1F9B'       => 1015,
        'uni1F9C'       => 1015,
        'uni1F9D'       => 1015,
        'uni1F9E'       => 1015,
        'uni1F9F'       => 1015,
        'uni1FA0'       => 658,
        'uni1FA1'       => 658,
        'uni1FA2'       => 658,
        'uni1FA3'       => 658,
        'uni1FA4'       => 658,
        'uni1FA5'       => 658,
        'uni1FA6'       => 658,
        'uni1FA7'       => 658,
        'uni1FA8'       => 812,
        'uni1FA9'       => 812,
        'uni1FAA'       => 997,
        'uni1FAB'       => 997,
        'uni1FAC'       => 929,
        'uni1FAD'       => 929,
        'uni1FAE'       => 929,
        'uni1FAF'       => 929,
        'uni1FB0'       => 523,
        'uni1FB1'       => 523,
        'uni1FB2'       => 523,
        'uni1FB3'       => 523,
        'uni1FB4'       => 523,
        'uni1FB6'       => 523,
        'uni1FB7'       => 523,
        'uni1FB8'       => 722,
        'uni1FB9'       => 722,
        'uni1FBA'       => 722,
        'uni1FBB'       => 722,
        'uni1FBC'       => 722,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 522,
        'uni1FC3'       => 522,
        'uni1FC4'       => 522,
        'uni1FC6'       => 522,
        'uni1FC7'       => 522,
        'uni1FC8'       => 748,
        'uni1FC9'       => 759,
        'uni1FCA'       => 859,
        'uni1FCB'       => 870,
        'uni1FCC'       => 722,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 269,
        'uni1FD1'       => 269,
        'uni1FD2'       => 269,
        'uni1FD3'       => 269,
        'uni1FD6'       => 269,
        'uni1FD7'       => 269,
        'uni1FD8'       => 333,
        'uni1FD9'       => 333,
        'uni1FDA'       => 470,
        'uni1FDB'       => 481,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 495,
        'uni1FE1'       => 495,
        'uni1FE2'       => 495,
        'uni1FE3'       => 495,
        'uni1FE4'       => 499,
        'uni1FE5'       => 499,
        'uni1FE6'       => 495,
        'uni1FE7'       => 495,
        'uni1FE8'       => 722,
        'uni1FE9'       => 722,
        'uni1FEA'       => 879,
        'uni1FEB'       => 899,
        'uni1FEC'       => 693,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 658,
        'uni1FF3'       => 658,
        'uni1FF4'       => 658,
        'uni1FF6'       => 658,
        'uni1FF7'       => 658,
        'uni1FF8'       => 850,
        'uni1FF9'       => 772,
        'uni1FFA'       => 861,
        'uni1FFB'       => 774,
        'uni1FFC'       => 743,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni2011'       => 333,
        'uni201F'       => 443,
        'uni2023'       => 350,
        'uni2027'       => 250,
        'uni2028'       => 1000,
        'uni2029'       => 1000,
        'uni202A'       => 750,
        'uni202B'       => 750,
        'uni202F'       => 200,
        'uni2031'       => 1324,
        'uni2036'       => 416,
        'uni2037'       => 416,
        'uni2038'       => 312,
        'uni203D'       => 443,
        'uni203F'       => 956,
        'uni2040'       => 956,
        'uni2045'       => 333,
        'uni2046'       => 333,
        'uni2047'       => 851,
        'uni2048'       => 674,
        'uni2049'       => 669,
        'uni204A'       => 487,
        'uni204B'       => 453,
        'uni204C'       => 453,
        'uni204D'       => 453,
        'uni204E'       => 500,
        'uni204F'       => 277,
        'uni2050'       => 956,
        'uni2051'       => 500,
        'uni2052'       => 500,
        'uni2053'       => 541,
        'uni2054'       => 956,
        'uni2055'       => 500,
        'uni2056'       => 499,
        'uni2057'       => 556,
        'uni2058'       => 615,
        'uni2059'       => 639,
        'uni205A'       => 273,
        'uni205B'       => 882,
        'uni205C'       => 639,
        'uni205D'       => 273,
        'uni205E'       => 277,
        'uni205F'       => 222,
        'uni2060'       => 0,
        'uni2061'       => 1000,
        'uni2062'       => 1000,
        'uni2063'       => 1000,
        'uni2064'       => 1000,
        'uni2066'       => 1000,
        'uni2067'       => 1000,
        'uni2068'       => 1000,
        'uni2069'       => 1000,
        'uni206A'       => 750,
        'uni206B'       => 750,
        'uni206C'       => 750,
        'uni206D'       => 750,
        'uni206E'       => 750,
        'uni206F'       => 750,
        'uni2071'       => 166,
        'uni207B'       => 338,
        'uni208A'       => 338,
        'uni208B'       => 338,
        'uni208C'       => 338,
        'uni2090'       => 273,
        'uni2091'       => 256,
        'uni2092'       => 288,
        'uni2093'       => 290,
        'uni2094'       => 256,
        'uni2095'       => 299,
        'uni2096'       => 299,
        'uni2097'       => 166,
        'uni2098'       => 466,
        'uni2099'       => 299,
        'uni209A'       => 299,
        'uni209B'       => 233,
        'uni209C'       => 166,
        'uni20A0'       => 616,
        'uni20A5'       => 777,
        'uni20A6'       => 722,
        'uni20A8'       => 1101,
        'uni20AD'       => 722,
        'uni20AE'       => 610,
        'uni20AF'       => 1000,
        'uni20B0'       => 500,
        'uni20B1'       => 556,
        'uni20B2'       => 722,
        'uni20B3'       => 722,
        'uni20B4'       => 556,
        'uni20B5'       => 666,
        'uni20B6'       => 500,
        'uni20B7'       => 500,
        'uni20B8'       => 610,
        'uni20B9'       => 500,
        'uni20BA'       => 500,
        'uni20BB'       => 682,
        'uni20BC'       => 715,
        'uni20BD'       => 500,
        'uni20BE'       => 758,
        'uni20BF'       => 666,
        'uni20F0'       => 0,
        'uni2100'       => 833,
        'uni2101'       => 810,
        'uni2102'       => 666,
        'uni2104'       => 610,
        'uni2106'       => 877,
        'uni2107'       => 500,
        'uni2108'       => 666,
        'uni210A'       => 509,
        'uni210C'       => 987,
        'uni210D'       => 722,
        'uni210E'       => 500,
        'uni2110'       => 687,
        'uni2114'       => 777,
        'uni2115'       => 722,
        'uni2119'       => 556,
        'uni211A'       => 722,
        'uni211B'       => 926,
        'uni211D'       => 666,
        'uni211F'       => 666,
        'uni2120'       => 906,
        'uni2123'       => 722,
        'uni2124'       => 610,
        'uni2125'       => 443,
        'uni2127'       => 743,
        'uni2128'       => 698,
        'uni2129'       => 269,
        'uni212A'       => 722,
        'uni212D'       => 645,
        'uni212F'       => 384,
        'uni2130'       => 615,
        'uni2131'       => 687,
        'uni2132'       => 556,
        'uni2139'       => 326,
        'uni213A'       => 915,
        'uni213B'       => 1177,
        'uni213C'       => 548,
        'uni213D'       => 441,
        'uni213E'       => 578,
        'uni213F'       => 722,
        'uni2140'       => 712,
        'uni2141'       => 777,
        'uni2142'       => 556,
        'uni2143'       => 556,
        'uni2144'       => 666,
        'uni2145'       => 722,
        'uni2146'       => 500,
        'uni2147'       => 443,
        'uni2148'       => 277,
        'uni2149'       => 277,
        'uni214A'       => 635,
        'uni214B'       => 777,
        'uni214C'       => 776,
        'uni214D'       => 881,
        'uni214E'       => 416,
        'uni214F'       => 1051,
        'uni2150'       => 750,
        'uni2151'       => 750,
        'uni2152'       => 1014,
        'uni215F'       => 464,
        'uni216C'       => 610,
        'uni216D'       => 666,
        'uni216E'       => 722,
        'uni216F'       => 889,
        'uni217C'       => 277,
        'uni217D'       => 443,
        'uni217E'       => 500,
        'uni217F'       => 777,
        'uni2180'       => 1125,
        'uni2181'       => 722,
        'uni2182'       => 1125,
        'uni2183'       => 666,
        'uni2184'       => 443,
        'uni2185'       => 732,
        'uni2186'       => 688,
        'uni2187'       => 722,
        'uni2188'       => 1125,
        'uni2189'       => 750,
        'uni218A'       => 500,
        'uni218B'       => 500,
        'uni2C60'       => 610,
        'uni2C61'       => 277,
        'uni2C62'       => 610,
        'uni2C63'       => 556,
        'uni2C64'       => 666,
        'uni2C65'       => 443,
        'uni2C66'       => 277,
        'uni2C67'       => 722,
        'uni2C68'       => 500,
        'uni2C69'       => 722,
        'uni2C6A'       => 500,
        'uni2C6B'       => 610,
        'uni2C6C'       => 443,
        'uni2C6D'       => 723,
        'uni2C6E'       => 889,
        'uni2C6F'       => 722,
        'uni2C70'       => 723,
        'uni2C71'       => 596,
        'uni2C72'       => 998,
        'uni2C73'       => 823,
        'uni2C74'       => 471,
        'uni2C75'       => 659,
        'uni2C76'       => 504,
        'uni2C77'       => 577,
        'uni2C78'       => 571,
        'uni2C79'       => 333,
        'uni2C7A'       => 500,
        'uni2C7B'       => 444,
        'uni2C7C'       => 155,
        'uni2C7D'       => 500,
        'uni2C7E'       => 556,
        'uni2C7F'       => 610,
        'uni2E00'       => 333,
        'uni2E01'       => 333,
        'uni2E02'       => 333,
        'uni2E03'       => 333,
        'uni2E04'       => 333,
        'uni2E05'       => 333,
        'uni2E06'       => 428,
        'uni2E07'       => 428,
        'uni2E08'       => 419,
        'uni2E09'       => 419,
        'uni2E0A'       => 419,
        'uni2E0B'       => 436,
        'uni2E0C'       => 436,
        'uni2E0D'       => 436,
        'uni2E0E'       => 838,
        'uni2E0F'       => 0,
        'uni2E10'       => 0,
        'uni2E11'       => 0,
        'uni2E12'       => 234,
        'uni2E13'       => 500,
        'uni2E14'       => 613,
        'uni2E15'       => 613,
        'uni2E16'       => 563,
        'uni2E17'       => 333,
        'uni2E18'       => 443,
        'uni2E19'       => 500,
        'uni2E1A'       => 333,
        'uni2E1B'       => 541,
        'uni2E1C'       => 437,
        'uni2E1D'       => 437,
        'uni2E1E'       => 541,
        'uni2E1F'       => 541,
        'uni2E20'       => 333,
        'uni2E21'       => 333,
        'uni2E22'       => 333,
        'uni2E23'       => 333,
        'uni2E24'       => 333,
        'uni2E25'       => 333,
        'uni2E26'       => 744,
        'uni2E27'       => 744,
        'uni2E28'       => 510,
        'uni2E29'       => 510,
        'uni2E2A'       => 615,
        'uni2E2B'       => 615,
        'uni2E2C'       => 639,
        'uni2E2D'       => 639,
        'uni2E2E'       => 443,
        'uni2E2F'       => 333,
        'uni2E30'       => 354,
        'uni2E31'       => 333,
        'uni2E32'       => 250,
        'uni2E33'       => 250,
        'uni2E34'       => 250,
        'uni2E35'       => 277,
        'uni2E36'       => 500,
        'uni2E37'       => 500,
        'uni2E38'       => 500,
        'uni2E39'       => 500,
        'uni2E3A'       => 1000,
        'uni2E3B'       => 1000,
        'uni2E3C'       => 250,
        'uni2E3D'       => 277,
        'uni2E3E'       => 277,
        'uni2E3F'       => 666,
        'uni2E40'       => 333,
        'uni2E41'       => 250,
        'uni2E42'       => 443,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 333,
        'uniA71E'       => 333,
        'uniA71F'       => 333,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 253,
        'uniA723'       => 216,
        'uniA724'       => 253,
        'uniA725'       => 216,
        'uniA726'       => 722,
        'uniA727'       => 500,
        'uniA728'       => 737,
        'uniA729'       => 601,
        'uniA72A'       => 500,
        'uniA72B'       => 500,
        'uniA72C'       => 435,
        'uniA72D'       => 435,
        'uniA72E'       => 525,
        'uniA72F'       => 525,
        'uniA730'       => 421,
        'uniA731'       => 369,
        'uniA732'       => 1161,
        'uniA733'       => 690,
        'uniA734'       => 1130,
        'uniA735'       => 750,
        'uniA736'       => 1068,
        'uniA737'       => 707,
        'uniA738'       => 923,
        'uniA739'       => 618,
        'uniA73A'       => 923,
        'uniA73B'       => 618,
        'uniA73C'       => 923,
        'uniA73D'       => 618,
        'uniA73E'       => 666,
        'uniA73F'       => 443,
        'uniA740'       => 722,
        'uniA741'       => 500,
        'uniA742'       => 722,
        'uniA743'       => 500,
        'uniA744'       => 722,
        'uniA745'       => 500,
        'uniA746'       => 704,
        'uniA747'       => 358,
        'uniA748'       => 610,
        'uniA749'       => 277,
        'uniA74A'       => 837,
        'uniA74B'       => 583,
        'uniA74C'       => 773,
        'uniA74D'       => 558,
        'uniA74E'       => 1259,
        'uniA74F'       => 840,
        'uniA750'       => 556,
        'uniA751'       => 500,
        'uniA752'       => 619,
        'uniA753'       => 607,
        'uniA754'       => 771,
        'uniA755'       => 757,
        'uniA756'       => 722,
        'uniA757'       => 500,
        'uniA758'       => 855,
        'uniA759'       => 611,
        'uniA75A'       => 667,
        'uniA75B'       => 488,
        'uniA75C'       => 636,
        'uniA75D'       => 545,
        'uniA75E'       => 722,
        'uniA75F'       => 500,
        'uniA760'       => 943,
        'uniA761'       => 722,
        'uniA762'       => 540,
        'uniA763'       => 503,
        'uniA764'       => 556,
        'uniA765'       => 500,
        'uniA766'       => 556,
        'uniA767'       => 500,
        'uniA768'       => 545,
        'uniA769'       => 423,
        'uniA76A'       => 397,
        'uniA76B'       => 397,
        'uniA76C'       => 543,
        'uniA76D'       => 543,
        'uniA76E'       => 500,
        'uniA76F'       => 500,
        'uniA770'       => 291,
        'uniA771'       => 677,
        'uniA772'       => 433,
        'uniA773'       => 955,
        'uniA774'       => 676,
        'uniA775'       => 395,
        'uniA776'       => 667,
        'uniA777'       => 641,
        'uniA778'       => 463,
        'uniA779'       => 722,
        'uniA77A'       => 500,
        'uniA77B'       => 441,
        'uniA77C'       => 333,
        'uniA77D'       => 471,
        'uniA77E'       => 471,
        'uniA77F'       => 471,
        'uniA780'       => 610,
        'uniA781'       => 277,
        'uniA782'       => 760,
        'uniA783'       => 555,
        'uniA784'       => 441,
        'uniA785'       => 333,
        'uniA786'       => 632,
        'uniA787'       => 430,
        'uniA788'       => 333,
        'uniA789'       => 277,
        'uniA78A'       => 368,
        'uniA78B'       => 180,
        'uniA78C'       => 180,
        'uniA78D'       => 722,
        'uniA78E'       => 455,
        'uniA78F'       => 333,
        'uniA790'       => 722,
        'uniA791'       => 500,
        'uniA792'       => 666,
        'uniA793'       => 443,
        'uniA794'       => 443,
        'uniA795'       => 500,
        'uniA796'       => 745,
        'uniA797'       => 643,
        'uniA798'       => 556,
        'uniA799'       => 333,
        'uniA79A'       => 680,
        'uniA79B'       => 524,
        'uniA79C'       => 700,
        'uniA79D'       => 509,
        'uniA79E'       => 725,
        'uniA79F'       => 540,
        'uniA7A0'       => 722,
        'uniA7A1'       => 500,
        'uniA7A2'       => 722,
        'uniA7A3'       => 500,
        'uniA7A4'       => 722,
        'uniA7A5'       => 500,
        'uniA7A6'       => 666,
        'uniA7A7'       => 333,
        'uniA7A8'       => 556,
        'uniA7A9'       => 389,
        'uniA7AA'       => 799,
        'uniA7AB'       => 500,
        'uniA7AC'       => 723,
        'uniA7AD'       => 688,
        'uniA7AE'       => 610,
        'uniA7B0'       => 722,
        'uniA7B1'       => 610,
        'uniA7B2'       => 389,
        'uniA7B3'       => 722,
        'uniA7B4'       => 666,
        'uniA7B5'       => 508,
        'uniA7B6'       => 902,
        'uniA7B7'       => 658,
        'uniA7F7'       => 740,
        'uniA7F8'       => 440,
        'uniA7F9'       => 473,
        'uniA7FA'       => 777,
        'uniA7FB'       => 556,
        'uniA7FC'       => 556,
        'uniA7FD'       => 889,
        'uniA7FE'       => 333,
        'uniA7FF'       => 1163,
        'uniAB30'       => 523,
        'uniAB31'       => 681,
        'uniAB32'       => 404,
        'uniAB33'       => 443,
        'uniAB34'       => 569,
        'uniAB35'       => 333,
        'uniAB36'       => 500,
        'uniAB37'       => 315,
        'uniAB38'       => 327,
        'uniAB39'       => 264,
        'uniAB3A'       => 777,
        'uniAB3B'       => 500,
        'uniAB3C'       => 500,
        'uniAB3D'       => 405,
        'uniAB3E'       => 405,
        'uniAB3F'       => 500,
        'uniAB40'       => 725,
        'uniAB41'       => 722,
        'uniAB42'       => 722,
        'uniAB43'       => 840,
        'uniAB44'       => 840,
        'uniAB45'       => 485,
        'uniAB46'       => 514,
        'uniAB47'       => 319,
        'uniAB48'       => 488,
        'uniAB49'       => 382,
        'uniAB4A'       => 537,
        'uniAB4B'       => 412,
        'uniAB4C'       => 615,
        'uniAB4D'       => 333,
        'uniAB4E'       => 500,
        'uniAB4F'       => 500,
        'uniAB50'       => 777,
        'uniAB51'       => 777,
        'uniAB52'       => 532,
        'uniAB53'       => 443,
        'uniAB54'       => 443,
        'uniAB55'       => 428,
        'uniAB56'       => 532,
        'uniAB57'       => 500,
        'uniAB58'       => 532,
        'uniAB59'       => 500,
        'uniAB5A'       => 431,
        'uniAB5B'       => 333,
        'uniAB5C'       => 321,
        'uniAB5D'       => 211,
        'uniAB5E'       => 211,
        'uniAB5F'       => 327,
        'uniAB60'       => 704,
        'uniAB61'       => 691,
        'uniAB62'       => 722,
        'uniAB63'       => 798,
        'uniAB64'       => 522,
        'uniAB65'       => 565,
        'uniF301'       => 0,
        'uniFB05'       => 574,
        'uniFB06'       => 652,
        'uniFB13'       => 1045,
        'uniFB14'       => 1052,
        'uniFB15'       => 1045,
        'uniFB16'       => 1026,
        'uniFB17'       => 1310,
        'uniFB1D'       => 266,
        'uniFB1E'       => 0,
        'uniFB21'       => 627,
        'uniFB22'       => 565,
        'uniFB23'       => 617,
        'uniFB24'       => 579,
        'uniFB25'       => 578,
        'uniFB26'       => 653,
        'uniFB27'       => 615,
        'uniFB28'       => 646,
        'uniFB29'       => 563,
        'uniFB50'       => 207,
        'uniFB51'       => 229,
        'uniFB52'       => 713,
        'uniFB53'       => 713,
        'uniFB54'       => 244,
        'uniFB55'       => 244,
        'uniFB56'       => 713,
        'uniFB5A'       => 713,
        'uniFB5B'       => 713,
        'uniFB5C'       => 244,
        'uniFB5D'       => 244,
        'uniFB5E'       => 713,
        'uniFB5F'       => 713,
        'uniFB60'       => 244,
        'uniFB61'       => 244,
        'uniFB62'       => 713,
        'uniFB63'       => 713,
        'uniFB64'       => 244,
        'uniFB65'       => 244,
        'uniFB66'       => 713,
        'uniFB6A'       => 788,
        'uniFB6E'       => 788,
        'uniFB6F'       => 788,
        'uniFB70'       => 267,
        'uniFB71'       => 262,
        'uniFB72'       => 562,
        'uniFB73'       => 525,
        'uniFB74'       => 529,
        'uniFB75'       => 529,
        'uniFB76'       => 562,
        'uniFB77'       => 525,
        'uniFB78'       => 529,
        'uniFB79'       => 529,
        'uniFB7A'       => 562,
        'uniFB7E'       => 562,
        'uniFB7F'       => 525,
        'uniFB80'       => 529,
        'uniFB81'       => 529,
        'uniFB82'       => 337,
        'uniFB83'       => 337,
        'uniFB84'       => 337,
        'uniFB85'       => 337,
        'uniFB86'       => 337,
        'uniFB87'       => 337,
        'uniFB88'       => 337,
        'uniFB8A'       => 488,
        'uniFB8C'       => 488,
        'uniFB8E'       => 812,
        'uniFB8F'       => 932,
        'uniFB90'       => 394,
        'uniFB91'       => 514,
        'uniFB92'       => 812,
        'uniFB96'       => 812,
        'uniFB97'       => 932,
        'uniFB98'       => 394,
        'uniFB99'       => 514,
        'uniFB9A'       => 812,
        'uniFB9B'       => 932,
        'uniFB9C'       => 394,
        'uniFB9D'       => 514,
        'uniFB9E'       => 525,
        'uniFBA0'       => 525,
        'uniFBA1'       => 525,
        'uniFBA2'       => 244,
        'uniFBA3'       => 244,
        'uniFBA6'       => 282,
        'uniFBAE'       => 812,
        'uniFBB0'       => 812,
        'uniFBB1'       => 812,
        'uniFBB2'       => 244,
        'uniFBB3'       => 244,
        'uniFBB4'       => 244,
        'uniFBB5'       => 244,
        'uniFBB6'       => 244,
        'uniFBB7'       => 244,
        'uniFBB8'       => 244,
        'uniFBB9'       => 244,
        'uniFBBA'       => 244,
        'uniFBBB'       => 244,
        'uniFBBC'       => 272,
        'uniFBBD'       => 244,
        'uniFBBE'       => 244,
        'uniFBBF'       => 199,
        'uniFBC0'       => 343,
        'uniFBC1'       => 343,
        'uniFBD3'       => 601,
        'uniFBD4'       => 601,
        'uniFBD5'       => 394,
        'uniFBD6'       => 394,
        'uniFBD7'       => 432,
        'uniFBD8'       => 432,
        'uniFBD9'       => 432,
        'uniFBDA'       => 432,
        'uniFBDB'       => 432,
        'uniFBDC'       => 432,
        'uniFBDD'       => 432,
        'uniFBDE'       => 432,
        'uniFBDF'       => 432,
        'uniFBE0'       => 432,
        'uniFBE1'       => 432,
        'uniFBE2'       => 432,
        'uniFBE3'       => 432,
        'uniFBE4'       => 638,
        'uniFBE5'       => 588,
        'uniFBE6'       => 244,
        'uniFBE7'       => 244,
        'uniFBE9'       => 244,
        'uniFBEA'       => 364,
        'uniFBEB'       => 364,
        'uniFBEC'       => 519,
        'uniFBED'       => 519,
        'uniFBEE'       => 638,
        'uniFBEF'       => 638,
        'uniFBF0'       => 638,
        'uniFBF1'       => 638,
        'uniFBF2'       => 638,
        'uniFBF3'       => 638,
        'uniFBF4'       => 638,
        'uniFBF5'       => 638,
        'uniFBF6'       => 562,
        'uniFBF7'       => 562,
        'uniFBF8'       => 486,
        'uniFBF9'       => 562,
        'uniFBFA'       => 562,
        'uniFBFB'       => 486,
        'uniFBFC'       => 638,
        'uniFBFD'       => 588,
        'uniFC63'       => 0,
        'uniFCF2'       => 207,
        'uniFCF3'       => 207,
        'uniFCF4'       => 207,
        'uniFD3C'       => 229,
        'uniFD3D'       => 207,
        'uniFDF4'       => 919,
        'uniFDFB'       => 634,
        'uniFDFC'       => 1221,
        'uniFDFD'       => 1483,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFE70'       => 207,
        'uniFE71'       => 207,
        'uniFE72'       => 207,
        'uniFE73'       => 289,
        'uniFE74'       => 207,
        'uniFE76'       => 207,
        'uniFE77'       => 207,
        'uniFE78'       => 207,
        'uniFE79'       => 207,
        'uniFE7A'       => 207,
        'uniFE7B'       => 207,
        'uniFE7C'       => 207,
        'uniFE7D'       => 207,
        'uniFE7E'       => 207,
        'uniFE7F'       => 207,
        'uniFE80'       => 412,
        'uniFE81'       => 207,
        'uniFE83'       => 207,
        'uniFE85'       => 432,
        'uniFE87'       => 207,
        'uniFE89'       => 638,
        'uniFE8D'       => 207,
        'uniFE8F'       => 713,
        'uniFE93'       => 282,
        'uniFE95'       => 713,
        'uniFE99'       => 713,
        'uniFE9D'       => 562,
        'uniFEA1'       => 562,
        'uniFEA5'       => 562,
        'uniFEA9'       => 337,
        'uniFEAB'       => 337,
        'uniFEAD'       => 488,
        'uniFEAF'       => 488,
        'uniFEB1'       => 821,
        'uniFEB5'       => 821,
        'uniFEB9'       => 1098,
        'uniFEBD'       => 1098,
        'uniFEC1'       => 581,
        'uniFEC5'       => 581,
        'uniFEC9'       => 543,
        'uniFECD'       => 543,
        'uniFED1'       => 788,
        'uniFED5'       => 581,
        'uniFED9'       => 601,
        'uniFEDD'       => 506,
        'uniFEE1'       => 337,
        'uniFEE5'       => 525,
        'uniFEE9'       => 282,
        'uniFEED'       => 432,
        'uniFEEF'       => 638,
        'uniFEF1'       => 638,
        'uniFFFC'       => 1000,
        'uogonek'       => 500,
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 495,
        'upsilondieresis'       => 495,
        'upsilondieresistonos'       => 495,
        'upsilonlatin'       => 548,
        'upsilontonos'       => 495,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 500,
        'ustraightcyrillic'       => 500,
        'ustraightstrokecyrillic'       => 500,
        'utilde'       => 500,
        'utildeacute'       => 500,
        'utildebelow'       => 500,
        'v'       => 500,
        'vdotbelow'       => 500,
        'vehfinalarabic'       => 788,
        'vehinitialarabic'       => 267,
        'vehmedialarabic'       => 262,
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 511,
        'vhook'       => 469,
        'voarmenian'       => 531,
        'vtilde'       => 500,
        'vturned'       => 500,
        'w'       => 722,
        'wacute'       => 722,
        'wawfinalarabic'       => 432,
        'wawhamzaabovefinalarabic'       => 432,
        'wcircumflex'       => 722,
        'wdieresis'       => 722,
        'wdotaccent'       => 722,
        'wdotbelow'       => 722,
        'weierstrass'       => 740,
        'wgrave'       => 722,
        'won'       => 943,
        'wring'       => 722,
        'wsuperior'       => 428,
        'wturned'       => 722,
        'wynn'       => 500,
        'x'       => 500,
        'xabovecmb'       => 0,
        'xdieresis'       => 500,
        'xdotaccent'       => 500,
        'xeharmenian'       => 779,
        'xi'       => 445,
        'xsuperior'       => 289,
        'y'       => 500,
        'yacute'       => 500,
        'ycircumflex'       => 500,
        'ydieresis'       => 500,
        'ydotaccent'       => 500,
        'ydotbelow'       => 500,
        'yehbarreefinalarabic'       => 812,
        'yehfinalarabic'       => 588,
        'yehhamzaabovefinalarabic'       => 588,
        'yehhamzaaboveinitialarabic'       => 244,
        'yehhamzaabovemedialarabic'       => 244,
        'yehthreedotsbelowarabic'       => 638,
        'yen'       => 500,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 671,
        'yetivhebrew'       => 0,
        'ygrave'       => 500,
        'yhook'       => 500,
        'yhookabove'       => 500,
        'yiarmenian'       => 251,
        'yiwnarmenian'       => 388,
        'yoddagesh'       => 266,
        'yotgreek'       => 277,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 556,
        'yring'       => 500,
        'ysuperior'       => 296,
        'ytilde'       => 500,
        'yturned'       => 500,
        'yusbigcyrillic'       => 690,
        'yusbigiotifiedcyrillic'       => 935,
        'yuslittlecyrillic'       => 589,
        'yuslittleiotifiedcyrillic'       => 833,
        'z'       => 444,                                         # +1
        'zaarmenian'       => 510,
        'zacute'       => 444,                                    # +1
        'zahfinalarabic'       => 581,
        'zahinitialarabic'       => 581,
        'zahmedialarabic'       => 581,
        'zainfinalarabic'       => 488,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 309,
        'zcaron'       => 444,                                    # +1
        'zcircumflex'       => 444,                               # (+1)
        'zcurl'       => 495,
        'zdotaccent'       => 444,                                # +1
        'zdotbelow'       => 444,                                 # (+1)
        'zedescendercyrillic'       => 395,
        'zedieresiscyrillic'       => 395,
        'zero'       => 500,
        'zeroinferior'       => 299,
        'zeropersian'       => 525,
        'zerosuperior'       => 299,
        'zerowidthspace'       => 0,
        'zeta'       => 414,
        'zhearmenian'       => 554,
        'zhebrevecyrillic'       => 690,
        'zhedescendercyrillic'       => 690,
        'zhedieresiscyrillic'       => 690,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 444,                                # (+1)
        'zretroflexhook'       => 444,                            # (+1)
        'zstroke'       => 444,                                   # (+1)
    },
    'wxold' => {
        'a'                  => 444,
        'A'                  => 722,
        'Aacute'             => 722,
        'aacute'             => 444,
        'abreve'             => 444,
        'Abreve'             => 722,
        'acircumflex'        => 444,
        'Acircumflex'        => 722,
        'acute'              => 333,
        'adieresis'          => 444,
        'Adieresis'          => 722,
        'AE'                 => 889,
        'ae'                 => 667,
        'agrave'             => 444,
        'Agrave'             => 722,
        'amacron'            => 444,
        'Amacron'            => 722,
        'ampersand'          => 778,
        'Aogonek'            => 722,
        'aogonek'            => 444,
        'aring'              => 444,
        'Aring'              => 722,
        'asciicircum'        => 469,
        'asciitilde'         => 541,
        'asterisk'           => 500,
        'at'                 => 921,
        'atilde'             => 444,
        'Atilde'             => 722,
        'B'                  => 667,
        'b'                  => 500,
        'backslash'          => 278,
        'bar'                => 200,
        'braceleft'          => 480,
        'braceright'         => 480,
        'bracketleft'        => 333,
        'bracketright'       => 333,
        'breve'              => 333,
        'brokenbar'          => 200,
        'bullet'             => 350,
        'C'                  => 667,
        'c'                  => 444,
        'cacute'             => 444,
        'Cacute'             => 667,
        'caron'              => 333,
        'Ccaron'             => 667,
        'ccaron'             => 444,
        'ccedilla'           => 444,
        'Ccedilla'           => 667,
        'cedilla'            => 333,
        'cent'               => 500,
        'circumflex'         => 333,
        'colon'              => 278,
        'comma'              => 250,
        'commaaccent'        => 250,
        'copyright'          => 760,
        'currency'           => 500,
        'd'                  => 500,
        'D'                  => 722,
        'dagger'             => 500,
        'daggerdbl'          => 500,
        'dcaron'             => 588,
        'Dcaron'             => 722,
        'dcroat'             => 500,
        'Dcroat'             => 722,
        'degree'             => 400,
        'Delta'              => 612,
        'dieresis'           => 333,
        'divide'             => 564,
        'dollar'             => 500,
        'dotaccent'          => 333,
        'dotlessi'           => 278,
        'e'                  => 444,
        'E'                  => 611,
        'eacute'             => 444,
        'Eacute'             => 611,
        'ecaron'             => 444,
        'Ecaron'             => 611,
        'ecircumflex'        => 444,
        'Ecircumflex'        => 611,
        'edieresis'          => 444,
        'Edieresis'          => 611,
        'Edotaccent'         => 611,
        'edotaccent'         => 444,
        'egrave'             => 444,
        'Egrave'             => 611,
        'eight'              => 500,
        'ellipsis'           => 1000,
        'Emacron'            => 611,
        'emacron'            => 444,
        'emdash'             => 1000,
        'endash'             => 500,
        'eogonek'            => 444,
        'Eogonek'            => 611,
        'equal'              => 564,
        'Eth'                => 722,
        'eth'                => 500,
        'Euro'               => 500,
        'exclam'             => 333,
        'exclamdown'         => 333,
        'F'                  => 556,
        'f'                  => 333,
        'fi'                 => 556,
        'five'               => 500,
        'fl'                 => 556,
        'florin'             => 500,
        'four'               => 500,
        'fraction'           => 167,
        'G'                  => 722,
        'g'                  => 500,
        'Gbreve'             => 722,
        'gbreve'             => 500,
        'gcommaaccent'       => 500,
        'Gcommaaccent'       => 722,
        'germandbls'         => 500,
        'grave'              => 333,
        'greater'            => 564,
        'greaterequal'       => 549,
        'guillemotleft'      => 500,
        'guillemotright'     => 500,
        'guilsinglleft'      => 333,
        'guilsinglright'     => 333,
        'H'                  => 722,
        'h'                  => 500,
        'hungarumlaut'       => 333,
	    'dblgravecmb'        => 333,
        'hyphen'             => 333,
        'I'                  => 333,
        'i'                  => 278,
        'Iacute'             => 333,
        'iacute'             => 278,
        'Icircumflex'        => 333,
        'icircumflex'        => 278,
        'idieresis'          => 278,
        'Idieresis'          => 333,
        'Idotaccent'         => 333,
        'igrave'             => 278,
        'Igrave'             => 333,
        'Imacron'            => 333,
        'imacron'            => 278,
        'Iogonek'            => 333,
        'iogonek'            => 278,
        'j'                  => 278,
        'J'                  => 389,
        'k'                  => 500,
        'K'                  => 722,
        'Kcommaaccent'       => 722,
        'kcommaaccent'       => 500,
        'L'                  => 611,
        'l'                  => 278,
        'lacute'             => 278,
        'Lacute'             => 611,
        'lcaron'             => 344,
        'Lcaron'             => 611,
        'lcommaaccent'       => 278,
        'Lcommaaccent'       => 611,
        'less'               => 564,
        'lessequal'          => 549,
        'logicalnot'         => 564,
        'lozenge'            => 471,
        'Lslash'             => 611,
        'lslash'             => 278,
        'M'                  => 889,
        'm'                  => 778,
        'macron'             => 520,
        'minus'              => 564,
        'mu'                 => 500,
        'multiply'           => 564,
        'n'                  => 500,
        'N'                  => 722,
        'nacute'             => 500,
        'Nacute'             => 722,
        'ncaron'             => 500,
        'Ncaron'             => 722,
        'ncommaaccent'       => 500,
        'Ncommaaccent'       => 722,
        'nine'               => 500,
        'notequal'           => 549,
        'ntilde'             => 500,
        'Ntilde'             => 722,
        'numbersign'         => 500,
        'o'                  => 500,
        'O'                  => 722,
        'oacute'             => 500,
        'Oacute'             => 722,
        'Ocircumflex'        => 722,
        'ocircumflex'        => 500,
        'Odieresis'          => 722,
        'odieresis'          => 500,
        'oe'                 => 722,
        'OE'                 => 889,
        'ogonek'             => 333,
        'ograve'             => 500,
        'Ograve'             => 722,
        'ohungarumlaut'      => 500,
        'Ohungarumlaut'      => 722,
        'Omacron'            => 722,
        'omacron'            => 500,
        'one'                => 500,
        'onehalf'            => 750,
        'onequarter'         => 750,
        'onesuperior'        => 300,
        'ordfeminine'        => 276,
        'ordmasculine'       => 310,
        'Oslash'             => 722,
        'oslash'             => 500,
        'Otilde'             => 722,
        'otilde'             => 500,
        'P'                  => 556,
        'p'                  => 500,
        'paragraph'          => 453,
        'parenleft'          => 333,
        'parenright'         => 333,
        'partialdiff'        => 476,
        'percent'            => 833,
        'period'             => 250,
        'periodcentered'     => 250,
        'perthousand'        => 1000,
        'plus'               => 564,
        'plusminus'          => 564,
        'Q'                  => 722,
        'q'                  => 500,
        'question'           => 444,
        'questiondown'       => 444,
        'quotedbl'           => 408,
        'quotedblbase'       => 444,
        'quotedblleft'       => 444,
        'quotedblright'      => 444,
        'quoteleft'          => 333,
        'quoteright'         => 333,
        'quotesinglbase'     => 333,
        'quotesingle'        => 180,
        'R'                  => 667,
        'r'                  => 333,
        'racute'             => 333,
        'Racute'             => 667,
        'radical'            => 453,
        'rcaron'             => 333,
        'Rcaron'             => 667,
        'rcommaaccent'       => 333,
        'Rcommaaccent'       => 667,
        'registered'         => 760,
        'ring'               => 333,
        'S'                  => 556,
        's'                  => 389,
        'Sacute'             => 556,
        'sacute'             => 389,
        'Scaron'             => 556,
        'scaron'             => 389,
        'Scedilla'           => 556,
        'scedilla'           => 389,
        'Scommaaccent'       => 556,
        'scommaaccent'       => 389,
        'section'            => 500,
        'semicolon'          => 278,
        'seven'              => 500,
        'six'                => 500,
        'slash'              => 278,
        'space'              => 250,
        'sterling'           => 500,
        'summation'          => 600,
        'T'                  => 611,
        't'                  => 278,
        'Tcaron'             => 611,
        'tcaron'             => 326,
        'tcommaaccent'       => 278,
        'Tcommaaccent'       => 611,
        'Thorn'              => 556,
        'thorn'              => 500,
        'three'              => 500,
        'threequarters'      => 750,
        'threesuperior'      => 300,
        'tilde'              => 333,
        'trademark'          => 980,
        'two'                => 500,
        'twosuperior'        => 300,
        'u'                  => 500,
        'U'                  => 722,
        'Uacute'             => 722,
        'uacute'             => 500,
        'ucircumflex'        => 500,
        'Ucircumflex'        => 722,
        'udieresis'          => 500,
        'Udieresis'          => 722,
        'Ugrave'             => 722,
        'ugrave'             => 500,
        'uhungarumlaut'      => 500,
        'Uhungarumlaut'      => 722,
        'umacron'            => 500,
        'Umacron'            => 722,
        'underscore'         => 500,
        'Uogonek'            => 722,
        'uogonek'            => 500,
        'Uring'              => 722,
        'uring'              => 500,
        'V'                  => 722,
        'v'                  => 500,
        'w'                  => 722,
        'W'                  => 944,
        'X'                  => 722,
        'x'                  => 500,
        'y'                  => 500,
        'Y'                  => 722,
        'yacute'             => 500,
        'Yacute'             => 722,
        'Ydieresis'          => 722,
        'ydieresis'          => 500,
        'yen'                => 500,
        'Z'                  => 611,
        'z'                  => 444,
        'zacute'             => 444,
        'Zacute'             => 611,
        'Zcaron'             => 611,
        'zcaron'             => 444,
        'Zdotaccent'         => 611,
        'zdotaccent'         => 444,
        'zero'               => 500,
    },
} };

1;
