/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.Set;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class VerticalLine2
implements UDrawable {
    private final double y1;
    private final double y2;
    private final Set<Double> skip;

    public VerticalLine2(double y1, double y2, Set<Double> skip) {
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
        this.skip = skip;
    }

    @Override
    public void drawU(UGraphic ug) {
        boolean drawn = false;
        double current = this.y1;
        for (Double step : this.skip) {
            if (step < this.y1) continue;
            assert (step >= this.y1);
            drawn = true;
            if (step == this.y2) {
                this.drawVLine(ug, current, this.y2);
            } else {
                this.drawVLine(ug, current, Math.min(this.y2, step - 3.0));
                if (this.y2 > step) {
                    this.drawArc(ug, step - 3.0);
                }
            }
            if (!((current = step + 9.0) >= this.y2)) continue;
            break;
        }
        if (!drawn) {
            this.drawVLine(ug, this.y1, this.y2);
        }
    }

    private void drawArc(UGraphic ug, double y) {
        UEllipse arc = new UEllipse(11.0, 11.0, 90.0, -180.0);
        ug.apply(new HColorNone().bg()).apply(new UTranslate(-5.0, y)).draw(arc);
    }

    private void drawVLine(UGraphic ug, double start, double end) {
        ULine line = ULine.vline(end - start);
        ug.apply(UTranslate.dy(start)).draw(line);
    }
}

