/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.MomentImpl;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.core.TaskSeparator;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.TaskDrawDiamond;
import net.sourceforge.plantuml.project.draw.TaskDrawRegular;
import net.sourceforge.plantuml.project.draw.TaskDrawSeparator;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.draw.TimeHeaderDaily;
import net.sourceforge.plantuml.project.draw.TimeHeaderMonthly;
import net.sourceforge.plantuml.project.draw.TimeHeaderSimple;
import net.sourceforge.plantuml.project.draw.TimeHeaderWeekly;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class GanttDiagram
extends TitledDiagram
implements ToTaskDraw,
WithSprite {
    private final Map<Task, TaskDraw> draws = new LinkedHashMap<Task, TaskDraw>();
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final HColorSet colorSet = HColorSet.instance();
    private final OpenClose openClose = new OpenClose();
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private final Map<Day, HColor> colorDays = new HashMap<Day, HColor>();
    private final Map<DayOfWeek, HColor> colorDaysOfWeek = new HashMap<DayOfWeek, HColor>();
    private final Map<Day, String> nameDays = new HashMap<Day, String>();
    private PrintScale printScale = PrintScale.DAILY;
    private Day today;
    private double totalHeightWithoutFooter;
    private Day min = Day.create(0L);
    private Day max;
    private Day printStart;
    private Day printEnd;
    private HColor linksColor = null;
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private boolean showFootbox = true;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    public GanttDiagram() {
        super(UmlDiagramType.GANTT);
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int horizontalPages) {
        this.horizontalPages = horizontalPages;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int verticalPages) {
        this.verticalPages = verticalPages;
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return 96;
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption, long seed) throws IOException {
        int margin2;
        int margin1;
        Scale scale = this.getScale();
        if (UseStyle.useBetaStyle()) {
            margin1 = SkinParam.zeroMargin(0);
            margin2 = SkinParam.zeroMargin(0);
        } else {
            margin1 = 0;
            margin2 = 0;
        }
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ClockwiseTopRightBottomLeft margins = ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2);
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, dpiFactor, this.getMetadata(), "", margins, null);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
        TextBlockBackcolored result = this.getTextBlock(stringBounder);
        result = new AnnotatedWorker(this, this.getSkinParam(), stringBounder).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, seed, os);
    }

    public void setPrintScale(PrintScale printScale) {
        this.printScale = printScale;
    }

    private boolean isHidden(Task task) {
        if (this.printStart == null || task instanceof TaskSeparator) {
            return false;
        }
        if (task.getEnd().compareTo(this.min) < 0) {
            return true;
        }
        return task.getStart().compareTo(this.max) > 0;
    }

    private TextBlockBackcolored getTextBlock(StringBounder stringBounder) {
        if (this.printStart == null) {
            this.initMinMax();
        } else {
            this.min = this.printStart;
            this.max = this.printEnd;
        }
        final TimeHeader timeHeader = this.getTimeHeader();
        this.initTaskAndResourceDraws(timeHeader.getTimeScale(), timeHeader.getFullHeaderHeight(), stringBounder);
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                timeHeader.drawTimeHeader(ug, GanttDiagram.this.totalHeightWithoutFooter);
                GanttDiagram.this.drawConstraints(ug, timeHeader.getTimeScale());
                GanttDiagram.this.drawTasksRect(ug);
                GanttDiagram.this.drawTasksTitle(ug);
                GanttDiagram.this.drawResources(ug);
                if (GanttDiagram.this.showFootbox) {
                    timeHeader.drawTimeFooter(ug.apply(UTranslate.dy(GanttDiagram.this.totalHeightWithoutFooter)));
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double xmin = timeHeader.getTimeScale().getStartingPosition(GanttDiagram.this.min);
                double xmax = timeHeader.getTimeScale().getEndingPosition(GanttDiagram.this.max);
                return new Dimension2DDouble(xmax - xmin, GanttDiagram.this.getTotalHeight(timeHeader));
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private TimeHeader getTimeHeader() {
        if (this.openClose.getCalendar() == null) {
            return new TimeHeaderSimple(this.min, this.max);
        }
        if (this.printScale == PrintScale.WEEKLY) {
            return new TimeHeaderWeekly(this.openClose.getCalendar(), this.min, this.max, this.openClose, this.colorDays, this.colorDaysOfWeek, this.nameDays);
        }
        if (this.printScale == PrintScale.MONTHLY) {
            return new TimeHeaderMonthly(this.openClose.getCalendar(), this.min, this.max, this.openClose, this.colorDays, this.colorDaysOfWeek, this.nameDays);
        }
        return new TimeHeaderDaily(this.openClose.getCalendar(), this.min, this.max, this.openClose, this.colorDays, this.colorDaysOfWeek, this.nameDays, this.printStart, this.printEnd);
    }

    private double getTotalHeight(TimeHeader timeHeader) {
        if (this.showFootbox) {
            return this.totalHeightWithoutFooter + timeHeader.getTimeFooterHeight();
        }
        return this.totalHeightWithoutFooter;
    }

    private void drawTasksRect(UGraphic ug) {
        for (Task task : this.tasks.values()) {
            if (this.isHidden(task)) continue;
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.constraints) {
            if (this.printStart != null && constraint.isHidden(this.min, this.max)) continue;
            constraint.getUDrawable(timeScale, this.getLinkColor(), this).drawU(ug);
        }
    }

    private HColor getLinkColor() {
        if (this.linksColor == null) {
            Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.getCurrentStyleBuilder());
            return styleArrow.value(PName.LineColor).asColor(this.colorSet);
        }
        return this.linksColor;
    }

    public StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.arrow);
    }

    private void drawTasksTitle(UGraphic ug1) {
        for (Task task : this.tasks.values()) {
            if (this.isHidden(task)) continue;
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawTitle(ug1.apply(move));
        }
    }

    private void drawResources(UGraphic ug) {
        for (Resource res : this.resources.values()) {
            ResourceDraw draw = res.getResourceDraw();
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }

    public void closeDayOfWeek(DayOfWeek day) {
        this.openClose.close(day);
    }

    public void closeDayAsDate(Day day) {
        this.openClose.close(day);
    }

    public void openDayAsDate(Day day) {
        this.openClose.open(day);
    }

    private void initTaskAndResourceDraws(TimeScale timeScale, double headerHeight, StringBounder stringBounder) {
        UDrawable draw;
        double y = headerHeight;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) {
                draw = new TaskDrawSeparator(((TaskSeparator)task).getName(), timeScale, y, this.min, this.max);
            } else {
                TaskImpl tmp = (TaskImpl)task;
                if (tmp.isDiamond()) {
                    draw = new TaskDrawDiamond(timeScale, y, tmp.getPrettyDisplay(), this.getStart(tmp), this.getSkinParam(), task, this);
                } else {
                    boolean oddStart = this.printStart != null && this.min.compareTo(this.getStart(tmp)) == 0;
                    boolean oddEnd = this.printStart != null && this.max.compareTo(this.getEnd(tmp)) == 0;
                    draw = new TaskDrawRegular(timeScale, y, tmp.getPrettyDisplay(), this.getStart(tmp), this.getEnd(tmp), oddStart, oddEnd, this.getSkinParam(), task, this, this.getConstraints(task));
                }
                draw.setColorsAndCompletion(tmp.getColors(), tmp.getCompletion(), tmp.getUrl(), tmp.getNote());
            }
            if (task.getRow() == null) {
                y += draw.getHeightTask();
            }
            this.draws.put(task, (TaskDraw)draw);
        }
        while (this.magicPushOnce(stringBounder)) {
        }
        if (this.lastY(stringBounder) != 0.0) {
            y = this.lastY(stringBounder);
            for (Resource res : this.resources.values()) {
                draw = new ResourceDraw(this, res, timeScale, y, this.min, this.max);
                res.setTaskDraw((ResourceDraw)draw);
                y += ((ResourceDraw)draw).getHeight();
            }
        }
        this.totalHeightWithoutFooter = y;
    }

    private Collection<GanttConstraint> getConstraints(Task task) {
        ArrayList<GanttConstraint> result = new ArrayList<GanttConstraint>();
        for (GanttConstraint constraint : this.constraints) {
            if (!constraint.isOn(task)) continue;
            result.add(constraint);
        }
        return Collections.unmodifiableCollection(result);
    }

    private double lastY(StringBounder stringBounder) {
        double result = 0.0;
        for (TaskDraw td : this.draws.values()) {
            result = Math.max(result, td.getY() + td.getHeightMax(stringBounder));
        }
        return result;
    }

    private boolean magicPushOnce(StringBounder stringBounder) {
        ArrayList<FingerPrint> notes = new ArrayList<FingerPrint>();
        for (TaskDraw td : this.draws.values()) {
            FingerPrint taskPrint = td.getFingerPrint();
            for (FingerPrint note : notes) {
                double deltaY = note.overlap(taskPrint);
                if (!(deltaY > 0.0)) continue;
                this.pushIncluding(td, deltaY);
                return true;
            }
            FingerPrint fingerPrintNote = td.getFingerPrintNote(stringBounder);
            if (fingerPrintNote == null) continue;
            notes.add(fingerPrintNote);
        }
        return false;
    }

    private void pushIncluding(TaskDraw first, double deltaY) {
        boolean skipping = true;
        if (first.getTrueRow() != null) {
            first = first.getTrueRow();
        }
        for (TaskDraw td : this.draws.values()) {
            if (td == first) {
                skipping = false;
            }
            if (skipping) continue;
            td.pushMe(deltaY + 1.0);
        }
    }

    private Day getStart(TaskImpl tmp) {
        if (this.printStart == null) {
            return tmp.getStart();
        }
        return Day.max(this.min, tmp.getStart());
    }

    private Day getEnd(TaskImpl tmp) {
        if (this.printStart == null) {
            return tmp.getEnd();
        }
        return Day.min(this.max, tmp.getEnd());
    }

    private void initMinMax() {
        if (this.tasks.size() == 0) {
            this.max = this.min.increment();
        } else {
            this.max = null;
            for (Task task : this.tasks.values()) {
                if (task instanceof TaskSeparator) continue;
                Day start = task.getStart();
                Day end = task.getEnd();
                if (this.max != null && this.max.compareTo(end) >= 0) continue;
                this.max = end;
            }
        }
        if (this.openClose.getCalendar() != null) {
            for (Day d : this.colorDays.keySet()) {
                if (d.compareTo(this.max) <= 0) continue;
                this.max = d;
            }
            for (Day d : this.nameDays.keySet()) {
                if (d.compareTo(this.max) <= 0) continue;
                this.max = d;
            }
        }
    }

    public Day getThenDate() {
        Day result = this.getStartingDate();
        for (Day d : this.colorDays.keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        for (Day d : this.nameDays.keySet()) {
            if (d.compareTo(result) <= 0) continue;
            result = d;
        }
        return result;
    }

    public Task getExistingTask(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Task result = this.byShortName.get(id);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(id);
        return this.tasks.get(code);
    }

    public GanttConstraint forceTaskOrder(Task task1, Task task2) {
        TaskInstant end1 = new TaskInstant(task1, TaskAttribute.END);
        task2.setStart(end1.getInstantPrecise());
        GanttConstraint result = new GanttConstraint(end1, new TaskInstant(task2, TaskAttribute.START));
        this.addContraint(result);
        return result;
    }

    public Task getOrCreateTask(String codeOrShortName, String shortName, boolean linkedToPrevious) {
        Task result;
        if (codeOrShortName == null) {
            throw new IllegalArgumentException();
        }
        Task task = result = shortName == null ? null : this.byShortName.get(shortName);
        if (result != null) {
            return result;
        }
        result = this.byShortName.get(codeOrShortName);
        if (result != null) {
            return result;
        }
        TaskCode code = new TaskCode(codeOrShortName);
        result = this.tasks.get(code);
        if (result == null) {
            Task previous = null;
            if (linkedToPrevious) {
                previous = this.getLastCreatedTask();
            }
            result = new TaskImpl(code, this.openClose);
            this.tasks.put(code, result);
            if (this.byShortName != null) {
                this.byShortName.put(shortName, result);
            }
            if (previous != null) {
                this.forceTaskOrder(previous, result);
            }
        }
        return result;
    }

    private Task getLastCreatedTask() {
        ArrayList<Task> all = new ArrayList<Task>(this.tasks.values());
        for (int i = all.size() - 1; i >= 0; --i) {
            if (!(all.get(i) instanceof TaskImpl)) continue;
            return (Task)all.get(i);
        }
        return null;
    }

    public void addSeparator(String comment) {
        TaskSeparator separator = new TaskSeparator(comment, this.tasks.size());
        this.tasks.put(separator.getCode(), separator);
    }

    public void addContraint(GanttConstraint constraint) {
        this.constraints.add(constraint);
    }

    public HColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setStartingDate(Day start) {
        this.openClose.setCalendar(start);
        this.min = start;
    }

    public Day getStartingDate() {
        return this.openClose.getCalendar();
    }

    public Day getStartingDate(int nday) {
        if (this.openClose.getCalendar() == null) {
            return null;
        }
        return this.openClose.getCalendar().addDays(nday);
    }

    public int daysInWeek() {
        return this.openClose.daysInWeek();
    }

    public boolean isOpen(Day day) {
        return this.openClose.getLoadAt(day) > 0;
    }

    public boolean affectResource(Task result, String description) {
        Pattern p = Pattern.compile("([^:]+)(:(\\d+))?");
        Matcher m = p.matcher(description);
        if (!m.find()) {
            throw new IllegalArgumentException();
        }
        Resource resource = this.getResource(m.group(1));
        int percentage = 100;
        if (m.group(3) != null) {
            percentage = Integer.parseInt(m.group(3));
        }
        if (percentage == 0) {
            return false;
        }
        result.addResource(resource, percentage);
        return true;
    }

    public Resource getResource(String resourceName) {
        Resource resource = this.resources.get(resourceName);
        if (resource == null) {
            resource = new Resource(resourceName);
        }
        this.resources.put(resourceName, resource);
        return resource;
    }

    public int getLoadForResource(Resource res, Day i) {
        int result = 0;
        for (Task task : this.tasks.values()) {
            if (task instanceof TaskSeparator) continue;
            TaskImpl task2 = (TaskImpl)task;
            result += task2.loadForResource(res, i);
        }
        return result;
    }

    public Moment getExistingMoment(String id) {
        Moment result = this.getExistingTask(id);
        if (result == null) {
            Day start = null;
            Day end = null;
            for (Map.Entry<Day, String> ent : this.nameDays.entrySet()) {
                if (!ent.getValue().equalsIgnoreCase(id)) continue;
                start = this.min(start, ent.getKey());
                end = this.max(end, ent.getKey());
            }
            if (start != null) {
                result = new MomentImpl(start, end);
            }
        }
        return result;
    }

    private Day min(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) > 0) {
            return d2;
        }
        return d1;
    }

    private Day max(Day d1, Day d2) {
        if (d1 == null) {
            return d2;
        }
        if (d1.compareTo(d2) < 0) {
            return d2;
        }
        return d1;
    }

    public void colorDay(Day day, HColor color) {
        this.colorDays.put(day, color);
    }

    public void colorDay(DayOfWeek day, HColor color) {
        this.colorDaysOfWeek.put(day, color);
    }

    public void nameDay(Day day, String name) {
        this.nameDays.put(day, name);
    }

    public void setTodayColors(CenterBorderColor colors) {
        if (this.today == null) {
            this.today = Day.today();
        }
        this.colorDay(this.today, colors.getCenter());
    }

    public CommandExecutionResult setToday(Day date) {
        this.today = date;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult deleteTask(Task task) {
        task.setColors(new CenterBorderColor(HColorUtils.WHITE, HColorUtils.BLACK));
        return CommandExecutionResult.ok();
    }

    public void setPrintInterval(Day start, Day end) {
        this.printStart = start;
        this.printEnd = end;
    }

    public void setLinksColor(HColor color) {
        this.linksColor = color;
    }

    @Override
    public TaskDraw getTaskDraw(Task task) {
        return this.draws.get(task);
    }

    public CommandExecutionResult addNote(Display note) {
        Task last = null;
        Iterator<Task> iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            Task current;
            last = current = iterator.next();
        }
        if (last == null) {
            return CommandExecutionResult.error("No task defined");
        }
        last.setNote(note);
        return CommandExecutionResult.ok();
    }

    @Override
    public LoadPlanable getDefaultPlan() {
        return this.openClose;
    }

    public void setShowFootbox(boolean footbox) {
        this.showFootbox = footbox;
    }
}

