/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.hierarchy.creation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.core.util.Recommendation;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.tabbed.CreateHierarchyChangeGenerator;
import org.protege.editor.owl.model.hierarchy.tabbed.Edge;
import org.protege.editor.owl.model.hierarchy.tabbed.MakeSiblingsDisjointChangeGenerator;
import org.protege.editor.owl.model.hierarchy.tabbed.TabIndentedHierarchyParser;
import org.protege.editor.owl.ui.hierarchy.creation.CreateSubHierarchyWizard;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHierarchyExecutor<E extends OWLEntity> {
    private static final Logger logger = LoggerFactory.getLogger(CreateHierarchyExecutor.class);
    private final OWLEditorKit editorKit;
    private final EntityType<E> entityType;
    private final Optional<Recommendation> makeSiblingsDisjointRecommendation;
    private final CreateHierarchyChangeGenerator<E> hierarchyChangeGenerator;
    private final MakeSiblingsDisjointChangeGenerator<E> makeSiblingsDisjointChangeGenerator;

    public CreateHierarchyExecutor(@Nonnull OWLEditorKit editorKit, @Nonnull EntityType<E> entityType, @Nonnull Optional<Recommendation> makeSiblingsDisjointRecommendation, @Nonnull CreateHierarchyChangeGenerator<E> hierarchyChangeGenerator, @Nonnull MakeSiblingsDisjointChangeGenerator<E> makeSiblingsDisjointChangeGenerator) {
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)editorKit)));
        this.entityType = (EntityType)Preconditions.checkNotNull(entityType);
        this.hierarchyChangeGenerator = (CreateHierarchyChangeGenerator)Preconditions.checkNotNull(hierarchyChangeGenerator);
        this.makeSiblingsDisjointChangeGenerator = (MakeSiblingsDisjointChangeGenerator)Preconditions.checkNotNull(makeSiblingsDisjointChangeGenerator);
        this.makeSiblingsDisjointRecommendation = (Optional)Preconditions.checkNotNull(makeSiblingsDisjointRecommendation);
    }

    public void showWizardAndCreateHierarchy() {
        CreateSubHierarchyWizard wizard = new CreateSubHierarchyWizard(this.editorKit, this.entityType, this.makeSiblingsDisjointRecommendation);
        if (wizard.showModalDialog() != 0) {
            return;
        }
        try {
            this.createHierarchy(wizard);
        }
        catch (IOException ex) {
            logger.error("An error occurred whilst parsing the tab-indented hierarchy", (Throwable)ex);
        }
    }

    private void createHierarchy(CreateSubHierarchyWizard wizard) throws IOException {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        String termPrefix = wizard.getPrefix();
        String termSuffix = wizard.getSuffix();
        String tabIndentedHierarchy = wizard.getHierarchy();
        TabIndentedHierarchyParser parser = new TabIndentedHierarchyParser(4, termPrefix, termSuffix);
        List<Edge> edges = parser.parse(new StringReader(tabIndentedHierarchy));
        ImmutableSetMultimap<E, E> parent2ChildMap = this.hierarchyChangeGenerator.generateHierarchy(edges, changes);
        if (wizard.isMakeSiblingsDisjoint().orElse(false).booleanValue()) {
            List<OWLOntologyChange> disjointSibsChanges = this.makeSiblingsDisjointChangeGenerator.generateChanges((SetMultimap<E, E>)parent2ChildMap);
            changes.addAll(disjointSibsChanges);
        }
        OWLModelManager modelManager = this.editorKit.getOWLModelManager();
        modelManager.applyChanges(changes);
    }
}

