/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.logging.Logger;
import org.ice4j.StunResponseEvent;
import org.ice4j.ice.GoogleRelayedCandidate;
import org.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.GoogleRelayedCandidateDelegate;

public class GoogleRelayedCandidateDatagramSocket
extends DatagramSocket {
    private static final Logger logger = Logger.getLogger(GoogleRelayedCandidateDatagramSocket.class.getName());
    private boolean closed = false;
    private final GoogleRelayedCandidate relayedCandidate;
    private final GoogleTurnCandidateHarvest turnCandidateHarvest;
    private final GoogleRelayedCandidateDelegate socketDelegate;

    public GoogleRelayedCandidateDatagramSocket(GoogleRelayedCandidate relayedCandidate, GoogleTurnCandidateHarvest turnCandidateHarvest, String username) throws SocketException {
        super((SocketAddress)null);
        this.socketDelegate = new GoogleRelayedCandidateDelegate(turnCandidateHarvest, username);
        this.relayedCandidate = relayedCandidate;
        this.turnCandidateHarvest = turnCandidateHarvest;
        logger.finest("Create new GoogleRelayedCandidateDatagramSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GoogleRelayedCandidateDatagramSocket googleRelayedCandidateDatagramSocket = this;
        synchronized (googleRelayedCandidateDatagramSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.socketDelegate.close();
        this.turnCandidateHarvest.close(this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.getRelayedCandidate().getTransportAddress();
    }

    public final GoogleRelayedCandidate getRelayedCandidate() {
        return this.relayedCandidate;
    }

    public void processSuccess(Response response, Request request) {
        this.socketDelegate.processSuccess(response, request);
    }

    public void processResponse(StunResponseEvent response) {
        this.socketDelegate.processResponse(response);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.socketDelegate.receive(p);
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        this.socketDelegate.send(p);
    }
}

