/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.authentication;

import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.mysqla.authentication.AuthenticationPlugin;
import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.core.authentication.Security;
import com.mysql.cj.mysqla.io.Buffer;
import java.util.List;

public class MysqlNativePasswordPlugin
implements AuthenticationPlugin {
    private Protocol protocol;
    private String password = null;

    @Override
    public void init(Protocol prot) {
        this.protocol = prot;
    }

    @Override
    public void destroy() {
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return "mysql_native_password";
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
    }

    @Override
    public boolean nextAuthenticationStep(PacketPayload fromServer, List<PacketPayload> toServer) {
        toServer.clear();
        Buffer bresp = null;
        String pwd = this.password;
        bresp = fromServer == null || pwd == null || pwd.length() == 0 ? new Buffer(new byte[0]) : new Buffer(Security.scramble411(pwd, fromServer.readBytes(NativeProtocol.StringSelfDataType.STRING_TERM), this.protocol.getPasswordCharacterEncoding()));
        toServer.add(bresp);
        return true;
    }
}

