/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.uihandler.api.Deactivated;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EnabledModulesCollector
implements Deactivated {
    private List<ModuleInfo> previouslyEnabled = Collections.emptyList();
    private List<ModuleInfo> previouslyDisabled = Collections.emptyList();

    @Override
    public void deactivated(Logger uiLogger) {
        LogRecord rec;
        ArrayList<ModuleInfo> enabled = new ArrayList<ModuleInfo>();
        ArrayList<ModuleInfo> disabled = new ArrayList<ModuleInfo>();
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (m.isEnabled()) {
                enabled.add(m);
                continue;
            }
            disabled.add(m);
        }
        ArrayList<ModuleInfo> newEnabled = new ArrayList<ModuleInfo>(enabled);
        newEnabled.removeAll(this.previouslyEnabled);
        ArrayList<ModuleInfo> newDisabled = new ArrayList<ModuleInfo>(disabled);
        newDisabled.removeAll(this.previouslyDisabled);
        if (!newEnabled.isEmpty()) {
            rec = new LogRecord(Level.CONFIG, "UI_ENABLED_MODULES");
            Object[] enabledNames = EnabledModulesCollector.getModuleNames(newEnabled);
            rec.setParameters(enabledNames);
            rec.setLoggerName(uiLogger.getName());
            rec.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            rec.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            uiLogger.log(rec);
        }
        if (!newDisabled.isEmpty()) {
            rec = new LogRecord(Level.CONFIG, "UI_DISABLED_MODULES");
            Object[] disabledNames = EnabledModulesCollector.getModuleNames(newDisabled);
            rec.setParameters(disabledNames);
            rec.setLoggerName(uiLogger.getName());
            rec.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            rec.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            uiLogger.log(rec);
        }
        this.previouslyEnabled = enabled;
        this.previouslyDisabled = disabled;
    }

    static String[] getModuleNames(List<ModuleInfo> modules) {
        String[] names = new String[modules.size()];
        int i = 0;
        for (ModuleInfo m : modules) {
            SpecificationVersion specVersion = m.getSpecificationVersion();
            if (specVersion != null) {
                names[i++] = m.getCodeName() + " [" + specVersion.toString() + "]";
                continue;
            }
            names[i++] = m.getCodeName();
        }
        return names;
    }

    private static List<String> getClusterNames() {
        String dirs = System.getProperty("netbeans.dirs");
        if (dirs != null) {
            String[] dirsArray = dirs.split(File.pathSeparator);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < dirsArray.length; ++i) {
                File f = new File(dirsArray[i]);
                if (!f.exists()) continue;
                list.add(f.getName());
            }
            return list;
        }
        return Collections.emptyList();
    }

    static LogRecord getClusterList(Logger logger) {
        LogRecord rec = new LogRecord(Level.INFO, "USG_INSTALLED_CLUSTERS");
        rec.setParameters(EnabledModulesCollector.getClusterNames().toArray());
        rec.setLoggerName(logger.getName());
        return rec;
    }

    static LogRecord getUserInstalledModules(Logger logger) {
        LogRecord rec = new LogRecord(Level.INFO, "USG_USER_INSTALLED_MODULES");
        HashSet<String> clusterNames = new HashSet<String>(EnabledModulesCollector.getClusterNames());
        clusterNames.add("platform");
        ArrayList<ModuleInfo> userInstalledModules = new ArrayList<ModuleInfo>();
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            String cn;
            File moduleParent;
            File moduleJarFile;
            Object showAttr = mi.getAttribute("AutoUpdate-Show-In-Client");
            if (!(showAttr instanceof String) || !Boolean.parseBoolean((String)showAttr) || (moduleJarFile = EnabledModulesCollector.getModuleJarFile(mi)) == null || !(moduleParent = moduleJarFile.getParentFile()).getName().equals("modules") || clusterNames.contains(cn = moduleParent.getParentFile().getName())) continue;
            userInstalledModules.add(mi);
        }
        rec.setParameters(EnabledModulesCollector.getModuleNames(userInstalledModules));
        rec.setLoggerName(logger.getName());
        return rec;
    }

    private static File getModuleJarFile(ModuleInfo mi) {
        try {
            Method getJarFileMethod = mi.getClass().getMethod("getJarFile", new Class[0]);
            getJarFileMethod.setAccessible(true);
            return (File)getJarFileMethod.invoke((Object)mi, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

