/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.filehandling;

import com.charleskorn.kaml.Yaml;
import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.Database;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/islandoftex/arara/filehandling/DatabaseUtils;", "", "()V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "exists", "", "load", "Lorg/islandoftex/arara/filehandling/Database;", "save", "", "database", "application"})
public final class DatabaseUtils {
    private static final LanguageController messages;
    public static final DatabaseUtils INSTANCE;

    private final File getFile() throws AraraException {
        File reference = (File)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference());
        String name = (String)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getDatabaseName()) + ".yaml";
        File path = FileHandlingUtils.INSTANCE.getParentCanonicalFile(reference);
        return FilesKt.resolve(path, name);
    }

    @NotNull
    public final Database load() throws AraraException {
        Database database;
        if (!this.exists()) {
            database = new Database(null, 1, null);
        } else {
            Object object;
            Object object2 = this.getFile();
            boolean bl = false;
            try {
                object = Result.Companion;
                Object $this$runCatching = object2;
                boolean bl2 = false;
                String text2 = FilesKt.readText$default((File)$this$runCatching, null, 1, null);
                if (!StringsKt.startsWith$default(text2, "!database", false, 2, null)) {
                    throw (Throwable)new Exception("Database should start with !database");
                }
                $this$runCatching = (Database)Yaml.Companion.getDefault().parse(Database.Companion.serializer(), text2);
                bl2 = false;
                object = Result.constructor-impl($this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
            }
            object2 = object;
            bl = false;
            boolean bl4 = false;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl5 = false;
                it.printStackTrace();
                Enum enum_ = Messages.ERROR_LOAD_COULD_NOT_LOAD_XML;
                Object[] objectArray = new Object[1];
                String string = INSTANCE.getFile().getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
                objectArray[0] = string;
                throw (Throwable)new AraraException(messages.getMessage(enum_, objectArray), it);
            }
            database = (Database)object2;
        }
        return database;
    }

    public final void save(@NotNull Database database) throws AraraException {
        Object object;
        Intrinsics.checkParameterIsNotNull(database, "database");
        Object object2 = this.getFile();
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = object2;
            boolean bl2 = false;
            String content = "!database\n" + Yaml.Companion.getDefault().stringify((SerializationStrategy)Database.Companion.serializer(), database);
            FilesKt.writeText$default((File)$this$runCatching, content, null, 2, null);
            $this$runCatching = Unit.INSTANCE;
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            Enum enum_ = Messages.ERROR_SAVE_COULD_NOT_SAVE_XML;
            Object[] objectArray = new Object[1];
            String string = INSTANCE.getFile().getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
            objectArray[0] = string;
            throw (Throwable)new AraraException(messages.getMessage(enum_, objectArray), it);
        }
    }

    private final boolean exists() throws AraraException {
        return this.getFile().exists();
    }

    private DatabaseUtils() {
    }

    static {
        DatabaseUtils databaseUtils;
        INSTANCE = databaseUtils = new DatabaseUtils();
        messages = LanguageController.INSTANCE;
    }
}

