/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.RangeStatsWithGradients;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.estimate.EstimationParameters;
import tim.prune.function.estimate.ParametersPanel;
import tim.prune.function.estimate.jama.Matrix;
import tim.prune.gui.ProgressDialog;

public class LearnParameters
extends GenericFunction
implements Runnable {
    ProgressDialog _progress = null;
    JDialog _dialog = null;
    private ParametersPanel _calculatedParamPanel = null;
    private EstimationParameters _calculatedParams = null;
    private JScrollBar _weightSlider = null;
    private JLabel _sliderDescLabel = null;
    private ParametersPanel _combinedParamPanel = null;
    private JButton _combineButton = null;

    public LearnParameters(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.learnestimationparams";
    }

    @Override
    public void begin() {
        if (this._progress == null) {
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey());
        }
        this._progress.show();
        new Thread(this).start();
    }

    @Override
    public void run() {
        this._progress.setMaximum(100);
        ArrayList<RangeStatsWithGradients> arrayList = new ArrayList<RangeStatsWithGradients>(20);
        Track track = this._app.getTrackInfo().getTrack();
        int n = track.getNumPoints();
        int n2 = n / 30;
        int n3 = -1;
        int n4 = 0;
        while (n4 < 30) {
            int n5 = n4 * n2;
            RangeStatsWithGradients rangeStatsWithGradients = this.getRangeStats(track, n5, n5 + n2, n3);
            if (rangeStatsWithGradients != null && rangeStatsWithGradients.getMovingDistanceKilometres() > 1.0 && !rangeStatsWithGradients.getTimestampsIncomplete() && !rangeStatsWithGradients.getTimestampsOutOfSequence() && rangeStatsWithGradients.getTotalDurationInSeconds() > 100L && n5 > n3) {
                arrayList.add(rangeStatsWithGradients);
                n3 = n5;
            }
            this._progress.setValue(n4);
            ++n4;
        }
        if (arrayList.size() < 10) {
            this._progress.dispose();
            this._app.showErrorMessage(this.getNameKey(), "error.learnestimationparams.failed");
            return;
        }
        MatrixResults matrixResults = this.reduceSamples(arrayList);
        if (matrixResults == null) {
            this._progress.dispose();
            this._app.showErrorMessage(this.getNameKey(), "error.learnestimationparams.failed");
            return;
        }
        this._progress.dispose();
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.populateCalculatedValues(matrixResults);
        this.updateCombinedLabels(this.calculateCombinedParameters());
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.learnestimationparams.intro")) + ":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        this._calculatedParamPanel = new ParametersPanel("dialog.estimatetime.results", true);
        this._calculatedParamPanel.setAlignmentX(0.0f);
        jPanel2.add(this._calculatedParamPanel);
        jPanel2.add(Box.createVerticalStrut(14));
        jPanel2.add(new JLabel(String.valueOf(I18nManager.getText("dialog.learnestimationparams.combine")) + ":"));
        jPanel2.add(Box.createVerticalStrut(4));
        this._weightSlider = new JScrollBar(0, 5, 1, 0, 11);
        this._weightSlider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!adjustmentEvent.getValueIsAdjusting()) {
                    LearnParameters.this.updateCombinedLabels(LearnParameters.this.calculateCombinedParameters());
                }
            }
        });
        jPanel2.add(this._weightSlider);
        this._sliderDescLabel = new JLabel(" ");
        this._sliderDescLabel.setAlignmentX(0.0f);
        jPanel2.add(this._sliderDescLabel);
        jPanel2.add(Box.createVerticalStrut(12));
        this._combinedParamPanel = new ParametersPanel("dialog.learnestimationparams.combinedresults");
        this._combinedParamPanel.setAlignmentX(0.0f);
        jPanel2.add(this._combinedParamPanel);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._combineButton = new JButton(I18nManager.getText("button.combine"));
        this._combineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LearnParameters.this.combineAndFinish();
            }
        });
        jPanel3.add(this._combineButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LearnParameters.this._dialog.dispose();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    LearnParameters.this._dialog.dispose();
                }
            }
        };
        this._combineButton.addKeyListener(keyAdapter);
        jButton.addKeyListener(keyAdapter);
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private RangeStatsWithGradients getRangeStats(Track track, int n, int n2, int n3) {
        if (track == null || n < 0 || n2 <= n || n > track.getNumPoints()) {
            return null;
        }
        int n4 = track.getNumPoints();
        int n5 = n;
        DataPoint dataPoint = track.getPoint(n5);
        while (!(n5 >= n4 || dataPoint != null && !dataPoint.isWaypoint() && dataPoint.hasTimestamp() && dataPoint.hasAltitude())) {
            dataPoint = track.getPoint(++n5);
        }
        if (n3 >= 0 && n5 <= n3 + 10 || n5 >= n4 - 10) {
            return null;
        }
        double d = 0.0;
        double d2 = Distance.convertDistanceToRadians(1.0, UnitSetLibrary.UNITS_KILOMETRES);
        DataPoint dataPoint2 = track.getPoint(n5);
        int n6 = n5;
        boolean bl = false;
        do {
            if ((dataPoint = track.getPoint(++n6)) != null && !dataPoint.isWaypoint()) {
                if (!dataPoint.hasAltitude() || !dataPoint.hasTimestamp()) {
                    return null;
                }
                if (dataPoint2 != null && !dataPoint.getSegmentStart()) {
                    d += DataPoint.calculateRadiansBetween(dataPoint2, dataPoint);
                }
            }
            dataPoint2 = dataPoint;
            if (n6 >= n4) {
                bl = true;
                continue;
            }
            if (!(d >= d2) || n6 < n2) continue;
            bl = true;
        } while (!bl);
        if (d >= d2) {
            return new RangeStatsWithGradients(track, n5, n6);
        }
        return null;
    }

    private static Matrix buildAMatrix(ArrayList<RangeStatsWithGradients> arrayList) {
        Unit unit = UnitSetLibrary.UNITS_METRES;
        Matrix matrix = new Matrix(arrayList.size(), 5);
        int n = 0;
        for (RangeStatsWithGradients rangeStatsWithGradients : arrayList) {
            matrix.setValue(n, 0, rangeStatsWithGradients.getMovingDistanceKilometres());
            matrix.setValue(n, 1, rangeStatsWithGradients.getGentleAltitudeRange().getClimb(unit));
            matrix.setValue(n, 2, rangeStatsWithGradients.getSteepAltitudeRange().getClimb(unit));
            matrix.setValue(n, 3, rangeStatsWithGradients.getGentleAltitudeRange().getDescent(unit));
            matrix.setValue(n, 4, rangeStatsWithGradients.getSteepAltitudeRange().getDescent(unit));
            ++n;
        }
        return matrix;
    }

    private static Matrix buildBMatrix(ArrayList<RangeStatsWithGradients> arrayList) {
        Matrix matrix = new Matrix(arrayList.size(), 1);
        int n = 0;
        for (RangeStatsWithGradients rangeStatsWithGradients : arrayList) {
            matrix.setValue(n, 0, (double)rangeStatsWithGradients.getMovingDurationInSeconds() / 60.0);
            ++n;
        }
        return matrix;
    }

    private static int getIndexOfMaxValue(Matrix matrix) {
        if (matrix == null || matrix.getNumColumns() > 1) {
            return -1;
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < matrix.getNumRows()) {
            d = Math.abs(matrix.get(n2, 0));
            if (d > d2) {
                d2 = d;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private static boolean isRangeSetSufficient(ArrayList<RangeStatsWithGradients> arrayList, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Unit unit = UnitSetLibrary.UNITS_METRES;
        int n6 = 0;
        for (RangeStatsWithGradients rangeStatsWithGradients : arrayList) {
            if (n6 != n) {
                if (rangeStatsWithGradients.getGentleAltitudeRange().getClimb(unit) > 0) {
                    ++n2;
                }
                if (rangeStatsWithGradients.getSteepAltitudeRange().getClimb(unit) > 0) {
                    ++n3;
                }
                if (rangeStatsWithGradients.getGentleAltitudeRange().getDescent(unit) > 0) {
                    ++n4;
                }
                if (rangeStatsWithGradients.getSteepAltitudeRange().getDescent(unit) > 0) {
                    ++n5;
                }
            }
            ++n6;
        }
        return n2 > 3 && n3 > 3 && n4 > 3 && n5 > 3;
    }

    private MatrixResults reduceSamples(ArrayList<RangeStatsWithGradients> arrayList) {
        Object object;
        int n = -1;
        Matrix matrix = null;
        boolean bl = false;
        double d = 0.0;
        while (!bl) {
            if (n >= 0) {
                arrayList.remove(n);
            }
            object = LearnParameters.buildAMatrix(arrayList);
            Matrix matrix2 = LearnParameters.buildBMatrix(arrayList);
            try {
                matrix = ((Matrix)object).solve(matrix2);
                Matrix matrix3 = ((Matrix)object).times(matrix);
                Matrix matrix4 = matrix3.minus(matrix2).divideEach(matrix2);
                d = matrix4.getAverageAbsValue();
                n = LearnParameters.getIndexOfMaxValue(matrix4);
                if (n < 0) {
                    System.err.println("Something wrong - index is " + n);
                    throw new Exception();
                }
                bl = arrayList.size() <= 25 || !LearnParameters.isRangeSetSufficient(arrayList, n);
            }
            catch (Exception exception) {
                System.out.println("Failed to reduce: " + exception.getClass().getName() + " - " + exception.getMessage());
                return null;
            }
            this._progress.setValue(20 + 80 * (30 - arrayList.size()) / 5);
        }
        object = new MatrixResults();
        ((MatrixResults)object)._parameters = new EstimationParameters();
        ((MatrixResults)object)._parameters.populateWithMetrics(matrix.get(0, 0) * 5.0, matrix.get(1, 0) * 100.0, matrix.get(2, 0) * 100.0, matrix.get(3, 0) * 100.0, matrix.get(4, 0) * 100.0);
        ((MatrixResults)object)._averageErrorPc = d;
        return object;
    }

    private void populateCalculatedValues(MatrixResults matrixResults) {
        if (matrixResults == null || matrixResults._parameters == null) {
            this._calculatedParams = null;
            this._calculatedParamPanel.updateParameters(null, 0.0);
        } else {
            this._calculatedParams = matrixResults._parameters;
            this._calculatedParamPanel.updateParameters(this._calculatedParams, matrixResults._averageErrorPc);
        }
    }

    private EstimationParameters calculateCombinedParameters() {
        double d = 1.0 - 0.1 * (double)this._weightSlider.getValue();
        EstimationParameters estimationParameters = new EstimationParameters(Config.getConfigString("prune.estimationparams"));
        return estimationParameters.combine(this._calculatedParams, d);
    }

    private void updateCombinedLabels(EstimationParameters estimationParameters) {
        String string = null;
        int n = this._weightSlider.getValue();
        switch (n) {
            case 0: {
                string = I18nManager.getText("dialog.learnestimationparams.weight.100pccurrent");
                break;
            }
            case 5: {
                string = I18nManager.getText("dialog.learnestimationparams.weight.50pc");
                break;
            }
            case 10: {
                string = I18nManager.getText("dialog.learnestimationparams.weight.100pccalculated");
                break;
            }
            default: {
                int n2 = 10 - n;
                int n3 = n;
                string = n2 + "0% " + I18nManager.getText("dialog.learnestimationparams.weight.current") + " + " + n3 + "0% " + I18nManager.getText("dialog.learnestimationparams.weight.calculated");
            }
        }
        this._sliderDescLabel.setText(string);
        this._combinedParamPanel.updateParameters(estimationParameters);
        this._combineButton.setEnabled(n > 0);
    }

    private void combineAndFinish() {
        EstimationParameters estimationParameters = this.calculateCombinedParameters();
        Config.setConfigString("prune.estimationparams", estimationParameters.toConfigString());
        this._dialog.dispose();
    }

    static class MatrixResults {
        public EstimationParameters _parameters = null;
        public double _averageErrorPc = 0.0;

        MatrixResults() {
        }
    }
}

