/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class VisualTransferHandler
extends TransferHandler {
    private final DragGestureRecognizerWithVisualRepresentation dragGestureRecognizerWithVisualRepresentation = new DragGestureRecognizerWithVisualRepresentation();

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        int n3 = n2 & n;
        if (DragSource.isDragImageSupported() && n3 != 0 && inputEvent instanceof MouseEvent) {
            this.dragGestureRecognizerWithVisualRepresentation.gestured(jComponent, (MouseEvent)inputEvent, n2, n3);
        } else {
            super.exportAsDrag(jComponent, inputEvent, n);
        }
    }

    private class DragGestureRecognizerWithVisualRepresentation
    extends DragGestureRecognizer {
        public DragGestureRecognizerWithVisualRepresentation() {
            super(DragSource.getDefaultDragSource(), null, 0, new DragListenerWithVisualRepresentation());
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    private class DragListenerWithVisualRepresentation
    implements DragGestureListener,
    DragSourceListener {
        private boolean autoscrolls;
        private final Image EMPTY_IMAGE = new BufferedImage(1, 1, 2);
        private final Point OFFSET = OperatingSystem.isMacOSX() ? (OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_40") ? new Point(12, -120) : new Point(12, 24)) : new Point(-12, -24);

        private DragListenerWithVisualRepresentation() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            Transferable transferable = VisualTransferHandler.this.createTransferable(jComponent);
            if (transferable != null) {
                this.autoscrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    Icon icon = VisualTransferHandler.this.getVisualRepresentation(transferable);
                    if (icon != null) {
                        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.66f));
                        icon.paintIcon(jComponent, graphics2D, 0, 0);
                        graphics2D.dispose();
                        dragGestureEvent.startDrag(null, bufferedImage, this.OFFSET, transferable, this);
                    } else {
                        dragGestureEvent.startDrag(null, this.EMPTY_IMAGE, new Point(48, 48), transferable, this);
                    }
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    jComponent.setAutoscrolls(this.autoscrolls);
                }
            }
            VisualTransferHandler.this.exportDone(jComponent, transferable, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            if (dragSourceDropEvent.getDropSuccess()) {
                VisualTransferHandler.this.exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                VisualTransferHandler.this.exportDone(jComponent, dragSourceContext.getTransferable(), 0);
            }
            jComponent.setAutoscrolls(this.autoscrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

