var Command, Protocol, ReverseCommand,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Command = require('../../command');

Protocol = require('../../protocol');

ReverseCommand = (function(superClass) {
  extend(ReverseCommand, superClass);

  function ReverseCommand() {
    return ReverseCommand.__super__.constructor.apply(this, arguments);
  }

  ReverseCommand.prototype.execute = function(remote, local) {
    this._send("reverse:forward:" + remote + ";" + local);
    return this.parser.readAscii(4).then((function(_this) {
      return function(reply) {
        switch (reply) {
          case Protocol.OKAY:
            return _this.parser.readAscii(4).then(function(reply) {
              switch (reply) {
                case Protocol.OKAY:
                  return true;
                case Protocol.FAIL:
                  return _this.parser.readError();
                default:
                  return _this.parser.unexpected(reply, 'OKAY or FAIL');
              }
            });
          case Protocol.FAIL:
            return _this.parser.readError();
          default:
            return _this.parser.unexpected(reply, 'OKAY or FAIL');
        }
      };
    })(this));
  };

  return ReverseCommand;

})(Command);

module.exports = ReverseCommand;
