/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class ChunkedInputFilter
implements InputFilter {
    private static final StringManager sm = StringManager.getManager((String)ChunkedInputFilter.class.getPackage().getName());
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected int pos = 0;
    protected int lastValid = 0;
    protected byte[] buf = null;
    protected ByteChunk readChunk = new ByteChunk();
    protected boolean endChunk = false;
    protected ByteChunk trailingHeaders = new ByteChunk();
    protected boolean needCRLFParse = false;
    private Request request;
    private final long maxExtensionSize;
    private final int maxTrailerSize;
    private long extensionSize;
    private final int maxSwallowSize;
    private boolean error;
    private final Set<String> allowedTrailerHeaders;

    public ChunkedInputFilter(int n, Set<String> set, int n2, int n3) {
        this.trailingHeaders.setLimit(n);
        this.allowedTrailerHeaders = set;
        this.maxExtensionSize = n2;
        this.maxTrailerSize = n;
        this.maxSwallowSize = n3;
    }

    @Override
    public int doRead(ByteChunk byteChunk, Request request) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        this.checkError();
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF(false);
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidHeader"));
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int n = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            this.throwIOException(sm.getString("chunkedInputFilter.eos"));
        }
        if (this.remaining > this.lastValid - this.pos) {
            n = this.lastValid - this.pos;
            this.remaining -= n;
            byteChunk.setBytes(this.buf, this.pos, n);
            this.pos = this.lastValid;
        } else {
            n = this.remaining;
            byteChunk.setBytes(this.buf, this.pos, this.remaining);
            this.pos += this.remaining;
            this.remaining = 0;
            if (this.pos + 1 >= this.lastValid) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF(false);
            }
        }
        return n;
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public long end() throws IOException {
        long l = 0L;
        int n = 0;
        while ((n = this.doRead(this.readChunk, null)) >= 0) {
            if (this.maxSwallowSize <= -1 || (l += (long)n) <= (long)this.maxSwallowSize) continue;
            this.throwIOException(sm.getString("inputFilter.maxSwallow"));
        }
        return this.lastValid - this.pos;
    }

    @Override
    public int available() {
        int n = this.lastValid - this.pos;
        if (n == 0) {
            return this.buffer.available();
        }
        return n;
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        this.pos = 0;
        this.lastValid = 0;
        this.endChunk = false;
        this.needCRLFParse = false;
        this.trailingHeaders.recycle();
        this.trailingHeaders.setLimit(this.maxTrailerSize);
        this.extensionSize = 0L;
        this.error = false;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    protected int readBytes() throws IOException {
        int n = this.buffer.doRead(this.readChunk, null);
        this.pos = this.readChunk.getStart();
        this.lastValid = this.pos + n;
        this.buf = this.readChunk.getBytes();
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseChunkHeader() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                return false;
            }
            if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                this.parseCRLF(false);
                bl = true;
            } else if (this.buf[this.pos] == 59 && !bl2) {
                bl2 = true;
                ++this.extensionSize;
            } else if (!bl2) {
                int n3 = HexUtils.getDec(this.buf[this.pos]);
                if (n3 == -1 || n2 >= 8) return false;
                ++n2;
                n = n << 4 | n3;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    this.throwIOException(sm.getString("chunkedInputFilter.maxExtension"));
                }
            }
            if (bl) continue;
            ++this.pos;
        }
        if (n2 == 0 || n < 0) {
            return false;
        }
        if (n == 0) {
            this.endChunk = true;
        }
        this.remaining = n;
        return true;
    }

    @Deprecated
    protected boolean parseCRLF() throws IOException {
        this.parseCRLF(false);
        return true;
    }

    protected void parseCRLF(boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfNoData"));
            }
            if (this.buf[this.pos] == 13) {
                if (bl3) {
                    this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfCRCR"));
                }
                bl3 = true;
            } else if (this.buf[this.pos] == 10) {
                if (!bl && !bl3) {
                    this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfNoCR"));
                }
                bl2 = true;
            } else {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlf"));
            }
            ++this.pos;
        }
    }

    protected void parseEndChunk() throws IOException {
        while (this.parseHeader()) {
        }
    }

    private boolean parseHeader() throws IOException {
        MimeHeaders mimeHeaders = this.request.getMimeHeaders();
        byte by = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
        }
        if ((by = this.buf[this.pos]) == 13 || by == 10) {
            this.parseCRLF(false);
            return false;
        }
        int n = this.trailingHeaders.getEnd();
        boolean bl = false;
        while (!bl) {
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((by = this.buf[this.pos]) >= 65 && by <= 90) {
                by = (byte)(by - -32);
            }
            if (by == 58) {
                bl = true;
            } else {
                this.trailingHeaders.append(by);
            }
            ++this.pos;
        }
        int n2 = this.trailingHeaders.getEnd();
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 0;
        while (bl3) {
            boolean bl4 = true;
            while (bl4) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((by = this.buf[this.pos]) == 32 || by == 9) {
                    ++this.pos;
                    int n4 = this.trailingHeaders.getLimit() - 1;
                    if (this.trailingHeaders.getEnd() > n4) {
                        this.throwIOException(sm.getString("chunkedInputFilter.maxTrailer"));
                    }
                    this.trailingHeaders.setLimit(n4);
                    continue;
                }
                bl4 = false;
            }
            while (!bl2) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((by = this.buf[this.pos]) == 13 || by == 10) {
                    this.parseCRLF(true);
                    bl2 = true;
                } else if (by == 32) {
                    this.trailingHeaders.append(by);
                } else {
                    this.trailingHeaders.append(by);
                    n3 = this.trailingHeaders.getEnd();
                }
                if (bl2) continue;
                ++this.pos;
            }
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((by = this.buf[this.pos]) != 32 && by != 9) {
                bl3 = false;
                continue;
            }
            bl2 = false;
            this.trailingHeaders.append(by);
        }
        String string = new String(this.trailingHeaders.getBytes(), n, n2 - n, "ISO_8859_1");
        if (this.allowedTrailerHeaders.contains(string.toLowerCase(Locale.ENGLISH))) {
            MessageBytes messageBytes = mimeHeaders.addValue(string);
            messageBytes.setBytes(this.trailingHeaders.getBytes(), n2, n3 - n2);
        }
        return true;
    }

    private void throwIOException(String string) throws IOException {
        this.error = true;
        throw new IOException(string);
    }

    private void throwEOFException(String string) throws IOException {
        this.error = true;
        throw new EOFException(string);
    }

    private void checkError() throws IOException {
        if (this.error) {
            throw new IOException(sm.getString("chunkedInputFilter.error"));
        }
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(Charset.defaultCharset()), 0, ENCODING_NAME.length());
    }
}

