/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import processing.app.BaseNoGui;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;

public class BoardPort {
    private String address;
    private String protocol;
    private String protocolLabel;
    private String boardName;
    private String label;
    private final PreferencesMap identificationPrefs;
    private final PreferencesMap prefs;
    private boolean online;

    public BoardPort() {
        this.prefs = new PreferencesMap();
        this.identificationPrefs = new PreferencesMap();
    }

    public BoardPort(BoardPort bp) {
        this.prefs = new PreferencesMap(bp.prefs);
        this.identificationPrefs = new PreferencesMap(bp.identificationPrefs);
        this.address = bp.address;
        this.protocol = bp.protocol;
        this.boardName = bp.boardName;
        this.label = bp.label;
        this.online = bp.online;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocolLabel() {
        return this.protocolLabel;
    }

    public void setProtocolLabel(String protocolLabel) {
        this.protocolLabel = protocolLabel;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public void setBoardName(String boardName) {
        this.boardName = boardName;
    }

    public PreferencesMap getPrefs() {
        return this.prefs;
    }

    public PreferencesMap getIdentificationPrefs() {
        return this.identificationPrefs;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setOnlineStatus(boolean online) {
        this.online = online;
    }

    public boolean isOnline() {
        return this.online;
    }

    public String toString() {
        return this.address;
    }

    public String toCompleteString() {
        return this.address + "_" + (String)this.getPrefs().get("vid") + "_" + (String)this.getPrefs().get("pid");
    }

    public TargetBoard searchMatchingBoard() {
        if (this.identificationPrefs == null || this.identificationPrefs.isEmpty()) {
            return null;
        }
        for (TargetPackage targetPackage : BaseNoGui.packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (!this.matchesBoard(board)) continue;
                    this.setBoardName(board.getName());
                    return board;
                }
            }
        }
        return null;
    }

    public boolean matchesBoard(TargetBoard board) {
        PreferencesMap identificationProps = this.getIdentificationPrefs();
        PreferencesMap boardProps = board.getPreferences();
        String wildMatcher = (String)identificationProps.get(".");
        if (wildMatcher != null) {
            if (wildMatcher.equals(board.getId())) {
                return true;
            }
            if (wildMatcher.equals(board.getFQBN())) {
                return true;
            }
        }
        int suffix = 0;
        while (true) {
            boolean found = true;
            for (String prop : identificationProps.keySet()) {
                String value = (String)identificationProps.get(prop);
                if (!boardProps.containsKey(prop = prop + "." + suffix)) {
                    return false;
                }
                if (value.equalsIgnoreCase((String)boardProps.get(prop))) continue;
                found = false;
                break;
            }
            if (found) {
                return true;
            }
            ++suffix;
        }
    }
}

