/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class ConstCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONST_REASSIGNED_VALUE_ERROR = DiagnosticType.warning("JSC_CONSTANT_REASSIGNED_VALUE_ERROR", "constant {0} assigned a value more than once.\nOriginal definition at {1}");
    private final AbstractCompiler compiler;
    private final Set<Var> initializedConstants;
    private final ModuleMetadataMap moduleMetadataMap;
    private Set<String> providedNames;

    public ConstCheck(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        Preconditions.checkNotNull(moduleMetadataMap);
        this.compiler = compiler;
        this.initializedConstants = new HashSet<Var>();
        this.moduleMetadataMap = moduleMetadataMap;
    }

    @Override
    public void process(Node externs, Node root) {
        ImmutableSet.Builder providedNames = ImmutableSet.builder();
        for (ModuleMetadataMap.ModuleMetadata metadata : this.moduleMetadataMap.getAllModuleMetadata()) {
            if (!metadata.isGoogProvide() && !metadata.isLegacyGoogModule()) continue;
            for (String namespace : metadata.googNamespaces()) {
                int dot = namespace.indexOf(46);
                String rootName = dot != -1 ? namespace.substring(0, dot) : namespace;
                providedNames.add(rootName);
            }
        }
        this.providedNames = providedNames.build();
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                if (!NodeUtil.isNameDeclaration(parent)) break;
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (!this.isConstant(var, n)) break;
                if (n.isFromExterns()) {
                    this.initializedConstants.add(var);
                    break;
                }
                if (!n.hasChildren() || this.initializedConstants.add(var)) break;
                this.reportError(n, var, name);
                break;
            }
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (this.isConstant(var, lhs) && !this.initializedConstants.add(var)) {
                    this.reportError(n, var, name);
                    break;
                }
                if (var == null || !var.isGoogModuleExports() || this.initializedConstants.add(var)) break;
                this.compiler.report(JSError.make(n, CONST_REASSIGNED_VALUE_ERROR, "exports", n.getSourceFileName()));
                break;
            }
            case INC: 
            case DEC: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (!this.isConstant(var, lhs)) break;
                this.reportError(n, var, name);
                break;
            }
        }
    }

    private boolean isConstant(Var var, Node nameNode) {
        if (var == null) {
            Preconditions.checkState(this.providedNames.contains(nameNode.getString()), "Found unexpected undeclared name %s", (Object)nameNode);
            return false;
        }
        return var.isConst() || var.isDeclaredOrInferredConst();
    }

    private void reportError(Node n, Var var, String name) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        if (info == null || !info.getSuppressions().contains("const")) {
            Node declNode = var.getNode();
            String declaredPosition = declNode.getSourceFileName() + ":" + declNode.getLineno();
            this.compiler.report(JSError.make(n, CONST_REASSIGNED_VALUE_ERROR, name, declaredPosition));
        }
    }
}

