/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.javascript.rhino.PMap;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public final class HamtPMap<K, V>
implements PMap<K, V>,
Serializable {
    private static final int BITS = 4;
    private static final int BITS_SHIFT = 28;
    private final K key;
    private final int hash;
    private final V value;
    private final int mask;
    private final HamtPMap<K, V>[] children;
    private static final HamtPMap<?, ?>[] EMPTY_CHILDREN = new HamtPMap[0];
    private static final HamtPMap<?, ?> EMPTY = new HamtPMap<Object, Object>(null, 0, null, 0, HamtPMap.emptyChildren());

    private HamtPMap(K key, int hash, V value, int mask, HamtPMap<K, V>[] children) {
        this.key = key;
        this.hash = hash;
        this.value = value;
        this.mask = mask;
        this.children = children;
        this.checkInvariants();
    }

    private void checkInvariants() {
        Preconditions.checkState(Integer.bitCount(this.mask) == this.children.length);
        for (HamtPMap<K, V> child : this.children) {
            Preconditions.checkNotNull(child);
        }
    }

    public static <K, V> HamtPMap<K, V> empty() {
        return EMPTY;
    }

    private static <K, V> HamtPMap<K, V>[] emptyChildren() {
        return EMPTY_CHILDREN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("{");
        if (!this.isEmpty()) {
            this.appendTo(sb);
        }
        return sb.append("}").toString();
    }

    private void appendTo(StringBuilder sb) {
        if (sb.length() > 1) {
            sb.append(", ");
        }
        sb.append(this.key).append(": ").append(this.value);
        for (HamtPMap<K, V> child : this.children) {
            super.appendTo(sb);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.key == null;
    }

    @Override
    public Iterable<V> values() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return () -> new Iter(this, map -> map.value);
    }

    @Override
    public Iterable<K> keys() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return () -> new Iter(this, map -> map.key);
    }

    @Override
    public V get(K key) {
        return !this.isEmpty() ? (V)this.get(key, HamtPMap.hash(key)) : null;
    }

    private V get(K key, int hash) {
        if (hash == this.hash && key.equals(this.key)) {
            return this.value;
        }
        int bucket = HamtPMap.bucket(hash);
        int bucketMask = 1 << bucket;
        return (this.mask & bucketMask) != 0 ? (V)super.get(key, HamtPMap.shift(hash)) : null;
    }

    @Override
    public HamtPMap<K, V> plus(K key, V value) {
        Preconditions.checkNotNull(value);
        return !this.isEmpty() ? this.plus(key, HamtPMap.hash(key), value) : new HamtPMap<K, V>(key, HamtPMap.hash(key), value, 0, HamtPMap.emptyChildren());
    }

    private HamtPMap<K, V> plus(K key, int hash, V value) {
        if (hash == this.hash && key.equals(this.key)) {
            return value.equals(this.value) ? this : new HamtPMap<K, V>(key, hash, value, this.mask, this.children);
        }
        if (HamtPMap.compareUnsigned(hash, this.hash) < 0) {
            return this.replaceRoot(key, hash, value);
        }
        int bucket = HamtPMap.bucket(hash);
        hash = HamtPMap.shift(hash);
        int bucketMask = 1 << bucket;
        int index = this.index(bucketMask);
        if ((this.mask & bucketMask) != 0) {
            HamtPMap<K, V> child = this.children[index];
            HamtPMap<K, V> newChild = super.plus(key, hash, value);
            return child == newChild ? this : this.withChildren(this.mask, HamtPMap.replaceChild(this.children, index, newChild));
        }
        HamtPMap<K, V> newChild = new HamtPMap<K, V>(key, hash, value, 0, HamtPMap.emptyChildren());
        return this.withChildren(this.mask | bucketMask, HamtPMap.insertChild(this.children, index, newChild));
    }

    private HamtPMap<K, V> replaceRoot(K key, int hash, V value) {
        HamtPMap<K, V>[] newChildren;
        int bucket = HamtPMap.bucket(this.hash);
        int leafHash = HamtPMap.shift(this.hash);
        int bucketMask = 1 << bucket;
        int index = this.index(bucketMask);
        if ((this.mask & bucketMask) != 0) {
            newChildren = HamtPMap.replaceChild(this.children, index, super.plus(this.key, leafHash, this.value));
        } else {
            HamtPMap<K, V> newChild = new HamtPMap<K, V>(this.key, leafHash, this.value, 0, HamtPMap.emptyChildren());
            newChildren = HamtPMap.insertChild(this.children, index, newChild);
        }
        return new HamtPMap<K, V>(key, hash, value, this.mask | bucketMask, newChildren);
    }

    @Override
    public HamtPMap<K, V> minus(K key) {
        return !this.isEmpty() ? this.minus(key, HamtPMap.hash(key), null) : this;
    }

    private HamtPMap<K, V> minus(K key, int hash, V[] value) {
        if (hash == this.hash && key.equals(this.key)) {
            HamtPMap<K, V> result = HamtPMap.deleteRoot(this.mask, this.children);
            if (value != null) {
                value[0] = this.value;
            }
            return result != null ? result : HamtPMap.empty();
        }
        int bucket = HamtPMap.bucket(hash);
        int bucketMask = 1 << bucket;
        if ((this.mask & bucketMask) == 0) {
            return this;
        }
        hash = HamtPMap.shift(hash);
        int index = this.index(bucketMask);
        HamtPMap<K, V> child = this.children[index];
        HamtPMap<K, V> newChild = super.minus(key, hash, value);
        if (newChild == child) {
            return this;
        }
        if (newChild == EMPTY) {
            return this.withChildren(this.mask & ~bucketMask, HamtPMap.deleteChild(this.children, index));
        }
        return this.withChildren(this.mask, HamtPMap.replaceChild(this.children, index, newChild));
    }

    @Override
    public HamtPMap<K, V> reconcile(PMap<K, V> that, PMap.Reconciler<K, V> joiner) {
        HamtPMap<Object, Object> result = HamtPMap.reconcile(!this.isEmpty() ? this : null, !that.isEmpty() ? (HamtPMap)that : null, (k, v1, v2) -> Preconditions.checkNotNull(joiner.merge(k, v1, v2)));
        return result != null ? result : HamtPMap.empty();
    }

    private static <K, V> HamtPMap<K, V> reconcile(@Nullable HamtPMap<K, V> t1, @Nullable HamtPMap<K, V> t2, PMap.Reconciler<K, V> joiner) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 == null) {
            V newValue = joiner.merge(t2.key, null, t2.value);
            HamtPMap<K, V>[] newChildren = Arrays.copyOf(t2.children, t2.children.length);
            for (int i = 0; i < newChildren.length; ++i) {
                newChildren[i] = HamtPMap.reconcile(null, newChildren[i], joiner);
            }
            return newValue != null ? new HamtPMap<K, V>(t2.key, t2.hash, newValue, t2.mask, newChildren) : HamtPMap.deleteRoot(t2.mask, newChildren);
        }
        if (t2 == null) {
            V newValue = joiner.merge(t1.key, t1.value, null);
            HamtPMap<K, V>[] newChildren = Arrays.copyOf(t1.children, t1.children.length);
            for (int i = 0; i < newChildren.length; ++i) {
                newChildren[i] = HamtPMap.reconcile(newChildren[i], null, joiner);
            }
            return newValue != null ? new HamtPMap<K, V>(t1.key, t1.hash, newValue, t1.mask, newChildren) : HamtPMap.deleteRoot(t1.mask, newChildren);
        }
        boolean sameChildrenAs1 = true;
        boolean sameChildrenAs2 = true;
        int hashCmp = HamtPMap.compareUnsigned(t1.hash, t2.hash);
        K key = t1.key;
        int hash = t1.hash;
        if (hashCmp < 0) {
            t2 = super.vacateRoot();
            sameChildrenAs2 = false;
        } else if (hashCmp > 0) {
            t1 = super.vacateRoot();
            sameChildrenAs1 = false;
            key = t2.key;
            hash = t2.hash;
        } else if (!t1.key.equals(t2.key)) {
            t2 = super.pivot(t1.key, t1.hash);
            sameChildrenAs2 = false;
        }
        V newValue = Objects.equals(t1.value, t2.value) ? t1.value : joiner.merge(t1.key != null ? t1.key : t2.key, t1.value, t2.value);
        int newMask = t1.mask | t2.mask;
        sameChildrenAs1 &= newMask == t1.mask;
        sameChildrenAs2 &= newMask == t2.mask;
        HamtPMap<K, V>[] newChildren = newMask != 0 ? new HamtPMap[Integer.bitCount(newMask)] : HamtPMap.emptyChildren();
        int mask = newMask;
        int index = 0;
        while (mask != 0) {
            int childBit = Integer.lowestOneBit(mask);
            mask &= ~childBit;
            HamtPMap<K, V> child1 = super.getChild(childBit);
            HamtPMap<K, V> child2 = super.getChild(childBit);
            newChildren[index] = HamtPMap.reconcile(child1, child2, joiner);
            sameChildrenAs1 &= newChildren[index] == child1;
            sameChildrenAs2 &= newChildren[index] == child2;
            if (newChildren[index] != null) {
                ++index;
                continue;
            }
            newMask &= ~childBit;
        }
        if (sameChildrenAs1 && t1.value.equals(newValue)) {
            return t1;
        }
        if (sameChildrenAs2 && t2.value.equals(newValue)) {
            return t2;
        }
        if (newValue == null) {
            return HamtPMap.deleteRoot(newMask, newChildren);
        }
        return new HamtPMap<K, V>(key, hash, newValue, newMask, newChildren);
    }

    @Override
    public boolean equivalent(PMap<K, V> that, BiPredicate<V, V> equivalence) {
        return HamtPMap.equivalent(!this.isEmpty() ? this : null, !that.isEmpty() ? (HamtPMap)that : null, equivalence);
    }

    private static <K, V> boolean equivalent(@Nullable HamtPMap<K, V> t1, @Nullable HamtPMap<K, V> t2, BiPredicate<V, V> equivalence) {
        int childBit;
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.hash != t2.hash) {
            return false;
        }
        if (!t1.key.equals(t2.key)) {
            t2 = super.pivot(t1.key, t1.hash);
            if (t2.key == null) {
                return false;
            }
        }
        if (!equivalence.test(t1.value, t2.value)) {
            return false;
        }
        for (int mask = t1.mask | t2.mask; mask != 0; mask &= ~childBit) {
            childBit = Integer.lowestOneBit(mask);
            if (HamtPMap.equivalent(super.getChild(childBit), super.getChild(childBit), equivalence)) continue;
            return false;
        }
        return true;
    }

    private int index(int bit) {
        return Integer.bitCount(this.mask & bit - 1);
    }

    private HamtPMap<K, V> getChild(int bit) {
        return (this.mask & bit) != 0 ? this.children[this.index(bit)] : null;
    }

    private static int hash(Object key) {
        return Integer.reverse(key.hashCode());
    }

    private static int bucket(int hash) {
        return hash >>> 28;
    }

    private static int shift(int hash) {
        return hash << 4;
    }

    private static int unshift(int hash, int bucket) {
        return hash >>> 4 | bucket << 28;
    }

    private static int compareUnsigned(int left, int right) {
        int diff = (left >>> 2) - (right >>> 2);
        return diff != 0 ? diff : (left & 3) - (right & 3);
    }

    private HamtPMap<K, V> pivot(K key, int hash) {
        return this.pivot(key, hash, null, new Object[1]);
    }

    private HamtPMap<K, V> pivot(K key, int hash, HamtPMap<K, V> parent, V[] result) {
        int newMask = this.mask;
        HamtPMap<K, V>[] newChildren = this.children;
        if (hash == this.hash && key.equals(this.key)) {
            result[0] = this.value;
        } else {
            int replacementBucket;
            int searchBucket = HamtPMap.bucket(hash);
            if (searchBucket == (replacementBucket = HamtPMap.bucket(this.hash))) {
                int bucketMask = 1 << searchBucket;
                if ((this.mask & bucketMask) != 0) {
                    int index = this.index(bucketMask);
                    HamtPMap<K, V> child = newChildren[index];
                    HamtPMap<K, V> newChild = super.pivot(key, HamtPMap.shift(hash), this, result);
                    newChildren = HamtPMap.replaceChild(newChildren, index, newChild);
                }
            } else {
                int searchMask = 1 << searchBucket;
                if ((this.mask & searchMask) != 0) {
                    int index = this.index(searchMask);
                    HamtPMap<K, V> child = newChildren[index];
                    HamtPMap<K, V> newChild = super.minus(key, HamtPMap.shift(hash), result);
                    if (!newChild.isEmpty()) {
                        newChildren = HamtPMap.replaceChild(newChildren, index, newChild);
                    } else {
                        newChildren = HamtPMap.deleteChild(newChildren, index);
                        newMask &= ~searchMask;
                    }
                }
                int replacementMask = 1 << replacementBucket;
                int index = Integer.bitCount(newMask & replacementMask - 1);
                if ((this.mask & replacementMask) != 0) {
                    HamtPMap<K, V> child = newChildren[index];
                    HamtPMap<K, V> newChild = super.plus(this.key, HamtPMap.shift(this.hash), this.value);
                    newChildren = HamtPMap.replaceChild(newChildren, index, newChild);
                } else {
                    newChildren = HamtPMap.insertChild(newChildren, index, new HamtPMap<K, V>(this.key, HamtPMap.shift(this.hash), this.value, 0, HamtPMap.emptyChildren()));
                    newMask |= replacementMask;
                }
            }
        }
        return parent != null ? new HamtPMap<K, V>(parent.key, HamtPMap.shift(parent.hash), parent.value, newMask, newChildren) : new HamtPMap<K, V>(key, hash, result[0], newMask, newChildren);
    }

    private HamtPMap<K, V> vacateRoot() {
        int bucket = HamtPMap.bucket(this.hash);
        int bucketMask = 1 << bucket;
        int index = this.index(bucketMask);
        if ((this.mask & bucketMask) != 0) {
            HamtPMap<K, V> newChild = super.plus(this.key, HamtPMap.shift(this.hash), this.value);
            return new HamtPMap<Object, Object>(null, 0, null, this.mask, HamtPMap.replaceChild(this.children, index, newChild));
        }
        HamtPMap<K, V> newChild = new HamtPMap<K, V>(this.key, HamtPMap.shift(this.hash), this.value, 0, HamtPMap.emptyChildren());
        return new HamtPMap<Object, Object>(null, 0, null, this.mask | bucketMask, HamtPMap.insertChild(this.children, index, newChild));
    }

    private HamtPMap<K, V> withChildren(int mask, HamtPMap<K, V>[] children) {
        return mask == this.mask && children == this.children ? this : new HamtPMap<K, V>(this.key, this.hash, this.value, mask, children);
    }

    private static <K, V> HamtPMap<K, V> deleteRoot(int mask, HamtPMap<K, V>[] children) {
        if (mask == 0) {
            return null;
        }
        HamtPMap<K, V> child = children[0];
        int hashBits = Integer.numberOfTrailingZeros(mask);
        int newHash = HamtPMap.unshift(child.hash, hashBits);
        HamtPMap<K, V> newChild = HamtPMap.deleteRoot(child.mask, child.children);
        if (newChild == null) {
            int newMask = mask & ~Integer.lowestOneBit(mask);
            return new HamtPMap<K, V>(child.key, newHash, child.value, newMask, HamtPMap.deleteChild(children, 0));
        }
        return new HamtPMap<K, V>(child.key, newHash, child.value, mask, HamtPMap.replaceChild(children, 0, newChild));
    }

    private static <K, V> HamtPMap<K, V>[] insertChild(HamtPMap<K, V>[] children, int index, HamtPMap<K, V> child) {
        HamtPMap[] newChildren = new HamtPMap[children.length + 1];
        newChildren[index] = child;
        System.arraycopy(children, 0, newChildren, 0, index);
        System.arraycopy(children, index, newChildren, index + 1, children.length - index);
        return newChildren;
    }

    private static <K, V> HamtPMap<K, V>[] replaceChild(HamtPMap<K, V>[] children, int index, HamtPMap<K, V> child) {
        HamtPMap<K, V>[] newChildren = Arrays.copyOf(children, children.length);
        newChildren[index] = child;
        return newChildren;
    }

    private static <K, V> HamtPMap<K, V>[] deleteChild(HamtPMap<K, V>[] children, int index) {
        if (children.length == 1) {
            return HamtPMap.emptyChildren();
        }
        HamtPMap[] newChildren = new HamtPMap[children.length - 1];
        System.arraycopy(children, 0, newChildren, 0, index);
        System.arraycopy(children, index + 1, newChildren, index, children.length - index - 1);
        return newChildren;
    }

    @VisibleForTesting
    HamtPMap<K, V> assertCorrectStructure() {
        if (this.isEmpty()) {
            return this;
        }
        int hash = HamtPMap.hash(this.key);
        for (int i = 0; i < this.children.length; ++i) {
            int childHash = HamtPMap.hash(this.children[i].key);
            if (HamtPMap.compareUnsigned(childHash, hash) < 0) {
                throw new AssertionError((Object)("Invalid map has decreasing hash " + this.children[i].key + "(" + Integer.toHexString(childHash) + ") beneath " + this.key + "(" + Integer.toHexString(hash) + ": " + this));
            }
            this.children[i].assertCorrectStructure();
        }
        return this;
    }

    private static class Iter<K, V, O>
    implements Iterator<O> {
        final Deque<HamtPMap<K, V>> queue = new ArrayDeque<HamtPMap<K, V>>();
        final Function<HamtPMap<K, V>, O> transformer;

        Iter(HamtPMap<K, V> map, Function<HamtPMap<K, V>, O> transformer) {
            this.transformer = transformer;
            if (!map.isEmpty()) {
                this.queue.add(map);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public O next() {
            HamtPMap<K, V> top = this.queue.removeFirst();
            for (int i = ((HamtPMap)top).children.length - 1; i >= 0; --i) {
                this.queue.add(((HamtPMap)top).children[i]);
            }
            return this.transformer.apply(top);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

