/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.common.BooleanProperty;
import freemind.common.DontShowNotificationProperty;
import freemind.common.SeparatorProperty;
import freemind.common.TextTranslator;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.generated.instance.PlaceNodeXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import freemind.modes.mindmapmode.actions.xml.ActionFactory;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.preferences.FreemindPropertyContributor;
import freemind.preferences.layout.OptionPanel;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import plugins.map.FreeMindMapController;
import plugins.map.MapDialog;
import plugins.map.MapNodePositionHolder;
import plugins.map.TileImage;

public class Registration
implements HookRegistration,
ActorXml,
TileLoaderListener,
MenuItemEnabledListener {
    private static final String PLUGINS_MAP_NODE_POSITION = MapNodePositionHolder.class.getName();
    private HashSet mMapNodePositionHolders = new HashSet();
    private HashSet mMapNodePositionListeners = new HashSet();
    private final MindMapController controller;
    private final MindMap mMap;
    private final Logger logger;
    private TileSource mTileSource;
    private TileController mTileController;
    private MemoryTileCache mTileCache;
    private MapDialog mMapDialog = null;
    private MapDialogPropertyContributor mOptionContributor;
    private static Timer sTimer;
    private static Boolean sTimerSemaphore;
    private Tools.IntHolder mCachePurgerSemaphore = new Tools.IntHolder(0);
    private HashSet mNodeVisibilityListeners = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration(ModeController controller, MindMap map) {
        this.controller = (MindMapController)controller;
        this.mMap = map;
        this.logger = controller.getFrame().getLogger(this.getClass().getName());
        this.mTileSource = new OsmTileSource.Mapnik();
        this.mTileCache = new MemoryTileCache();
        this.mTileController = new TileController(this.mTileSource, (TileCache)this.mTileCache, (TileLoaderListener)this);
        this.mTileController.setTileLoader((TileLoader)this.createTileLoader(this));
        this.mOptionContributor = new MapDialogPropertyContributor(this.controller);
        Boolean bl = sTimerSemaphore;
        synchronized (bl) {
            if (sTimer == null) {
                sTimer = new Timer();
                long purgeTime = Resources.getInstance().getLongProperty("tile_cache_purge_time", 600000L);
                sTimer.schedule((TimerTask)new CachePurger(this.getCacheDirectory(), this.getCacheMaxAge()), purgeTime, purgeTime);
            }
        }
    }

    public TileImage getImageForTooltip(Coordinate pPosition, int pZoom, String pTileSource) {
        TileSource tileSource = FreeMindMapController.changeTileSource(pTileSource, null);
        if (tileSource != null) {
            this.mTileSource = tileSource;
            this.mTileController.setTileSource(tileSource);
        }
        int tileSize = this.mTileSource.getTileSize();
        int exactx = OsmMercator.LonToX((double)pPosition.getLon(), (int)pZoom);
        int exacty = OsmMercator.LatToY((double)pPosition.getLat(), (int)pZoom);
        int x = exactx / tileSize;
        int y = exacty / tileSize;
        int dx = exactx % tileSize;
        int dy = exacty % tileSize;
        if (dx < tileSize / 2) {
            --x;
            dx += tileSize;
        }
        if (dy < tileSize / 2) {
            --y;
            dy += tileSize;
        }
        TileImage tileImage = new TileImage();
        tileImage.setTiles(2, x, y, pZoom, this.mTileController, this.logger, dx, dy);
        int timeout = 60;
        while (timeout-- > 0) {
            try {
                if (tileImage.isLoaded() || tileImage.hasErrors()) break;
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
        return tileImage;
    }

    public void deRegister() {
        OptionPanel.removeContributor((FreemindPropertyContributor)this.mOptionContributor);
        this.controller.getActionFactory().deregisterActor(this.getDoActionClass());
    }

    public void register() {
        OptionPanel.addContributor((FreemindPropertyContributor)this.mOptionContributor);
        this.controller.getActionFactory().registerActor((ActorXml)this, this.getDoActionClass());
    }

    public void registerMapNode(MapNodePositionHolder pMapNodePositionHolder) {
        this.mMapNodePositionHolders.add(pMapNodePositionHolder);
        for (MapNodePositionHolder.MapNodePositionListener listener : this.mMapNodePositionListeners) {
            try {
                listener.registerMapNode(pMapNodePositionHolder);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
    }

    public Set getMapNodePositionHolders() {
        return Collections.unmodifiableSet(this.mMapNodePositionHolders);
    }

    public void deregisterMapNode(MapNodePositionHolder pMapNodePositionHolder) {
        this.mMapNodePositionHolders.remove((Object)pMapNodePositionHolder);
        for (MapNodePositionHolder.MapNodePositionListener listener : this.mMapNodePositionListeners) {
            try {
                listener.deregisterMapNode(pMapNodePositionHolder);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
    }

    public void registerMapNodePositionListener(MapNodePositionHolder.MapNodePositionListener pMapNodePositionListener) {
        this.mMapNodePositionListeners.add(pMapNodePositionListener);
    }

    public void deregisterMapNodePositionListener(MapNodePositionHolder.MapNodePositionListener pMapNodePositionListener) {
        this.mMapNodePositionListeners.remove(pMapNodePositionListener);
    }

    public OsmTileLoader createTileLoader(TileLoaderListener mMap) {
        OsmTileLoader loader = null;
        String tileCacheClass = Resources.getInstance().getProperty("tile_cache_class");
        if (Tools.safeEquals((String)tileCacheClass, (String)"file")) {
            File cacheDir = this.getCacheDirectory();
            try {
                OsmFileCacheTileLoader osmFileCacheTileLoader = new OsmFileCacheTileLoader(mMap, cacheDir);
                loader = osmFileCacheTileLoader;
                long maxFileAge = this.getCacheMaxAge();
                this.logger.info("Setting cache max age to " + maxFileAge / 86400000L + " days.");
                osmFileCacheTileLoader.setCacheMaxFileAge(maxFileAge);
            }
            catch (Exception e1) {
                Resources.getInstance().logException((Throwable)e1);
            }
        }
        if (loader == null) {
            this.logger.info("Using osm tile loader");
            loader = new OsmTileLoader(mMap);
        }
        FreeMindMain.VersionInformation freemindVersion = this.controller.getFrame().getFreemindVersion();
        loader.headers.put("User-agent", "FreeMind " + freemindVersion);
        return loader;
    }

    protected long getCacheMaxAge() {
        long maxFileAge = Resources.getInstance().getLongProperty("tile_cache_max_age", 604800000L);
        return maxFileAge;
    }

    protected File getCacheDirectory() {
        String directory = Resources.getInstance().getProperty("file_tile_cache_directory");
        if (directory.startsWith("%/")) {
            directory = Resources.getInstance().getFreemindDirectory() + File.separator + directory.substring(2);
        }
        File cacheDir = new File(directory);
        this.logger.info("Trying to use file cache tile loader with dir " + directory);
        return cacheDir;
    }

    public void changePosition(MapNodePositionHolder pHolder, Coordinate pPosition, Coordinate pMapCenter, int pZoom, String pTileSource) {
        MindMapNode node = pHolder.getNode();
        PlaceNodeXmlAction doAction = this.createPlaceNodeXmlActionAction(node, pPosition, pMapCenter, pZoom, pTileSource);
        PlaceNodeXmlAction undoAction = this.createPlaceNodeXmlActionAction(node, pHolder.getPosition(), pHolder.getMapCenter(), pHolder.getZoom(), pHolder.getTileSource());
        ActionFactory actionFactory = this.controller.getActionFactory();
        actionFactory.doTransaction(PLUGINS_MAP_NODE_POSITION, new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
    }

    private PlaceNodeXmlAction createPlaceNodeXmlActionAction(MindMapNode pNode, Coordinate pPosition, Coordinate pMapCenter, int pZoom, String pTileSource) {
        this.logger.info("Setting position of node " + pNode);
        PlaceNodeXmlAction action = new PlaceNodeXmlAction();
        action.setNode(this.controller.getNodeID(pNode));
        action.setCursorLatitude(pPosition.getLat());
        action.setCursorLongitude(pPosition.getLon());
        action.setMapCenterLatitude(pMapCenter.getLat());
        action.setMapCenterLongitude(pMapCenter.getLon());
        action.setZoom(pZoom);
        action.setTileSource(pTileSource);
        return action;
    }

    public void act(XmlAction pAction) {
        if (pAction instanceof PlaceNodeXmlAction) {
            PlaceNodeXmlAction placeAction = (PlaceNodeXmlAction)pAction;
            NodeAdapter node = this.controller.getNodeFromID(placeAction.getNode());
            MapNodePositionHolder hook = MapNodePositionHolder.getHook((MindMapNode)node);
            if (hook != null) {
                hook.setMapCenter(new Coordinate(placeAction.getMapCenterLatitude(), placeAction.getMapCenterLongitude()));
                hook.setPosition(new Coordinate(placeAction.getCursorLatitude(), placeAction.getCursorLongitude()));
                hook.setZoom(placeAction.getZoom());
                hook.setTileSource(placeAction.getTileSource());
                hook.recreateTooltip();
                this.controller.nodeChanged((MindMapNode)node);
            } else {
                throw new IllegalArgumentException("MapNodePositionHolder to node id " + placeAction.getNode() + " not found.");
            }
        }
    }

    public Class getDoActionClass() {
        return PlaceNodeXmlAction.class;
    }

    public TileCache getTileCache() {
        return this.mTileCache;
    }

    public void tileLoadingFinished(Tile pTile, boolean pSuccess) {
    }

    public boolean isEnabled(JMenuItem pItem, Action pAction) {
        String hookName = ((NodeHookAction)pAction).getHookName();
        this.logger.fine("Enabled for " + hookName);
        if ("plugins/map/MapDialog_SearchInMapForNodeTextAction.properties".equals(hookName)) {
            return true;
        }
        if ("plugins/map/MapDialog_ShowMapToNode.properties".equals(hookName) || "plugins/map/MapDialog_AddLinkToMapAction.properties".equals(hookName) || "plugins/map/MapDialog_RemoveMapToNode.properties".equals(hookName) || "plugins/map/MapDialog_AddMapImageToNodeAction.properties".equals(hookName)) {
            for (MindMapNode node : this.controller.getSelecteds()) {
                MapNodePositionHolder hook = MapNodePositionHolder.getHook(node);
                if (hook == null) continue;
                return true;
            }
        }
        return false;
    }

    public MapDialog getMapDialog() {
        return this.mMapDialog;
    }

    public void setMapDialog(MapDialog pMapDialog) {
        this.mMapDialog = pMapDialog;
    }

    public void registerNodeVisibilityListener(NodeVisibilityListener pNodeVisibilityListener) {
        this.mNodeVisibilityListeners.add(pNodeVisibilityListener);
    }

    public void deregisterNodeVisibilityListener(NodeVisibilityListener pNodeVisibilityListener) {
        this.mNodeVisibilityListeners.remove(pNodeVisibilityListener);
    }

    public void fireNodeVisibilityChanged(boolean pVisible, MapNodePositionHolder pMapNodePositionHolder) {
        for (NodeVisibilityListener listener : this.mNodeVisibilityListeners) {
            try {
                listener.nodeVisibilityChanged(pMapNodePositionHolder, pVisible);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
            }
        }
    }

    static {
        sTimerSemaphore = new Boolean(false);
    }

    public static interface NodeVisibilityListener {
        public void nodeVisibilityChanged(MapNodePositionHolder var1, boolean var2);
    }

    private static final class MapDialogPropertyContributor
    implements FreemindPropertyContributor {
        private final MindMapController modeController;

        public MapDialogPropertyContributor(MindMapController modeController) {
            this.modeController = modeController;
        }

        public List getControls(TextTranslator pTextTranslator) {
            Vector<Object> controls = new Vector<Object>();
            controls.add(new OptionPanel.NewTabProperty("plugins/map/MapDialog.properties_MapDialogTabName"));
            controls.add(new SeparatorProperty("plugins/map/MapDialog.properties_PatternSeparatorName"));
            controls.add(new BooleanProperty("node_map_show_tooltip.tooltip", "node_map_show_tooltip"));
            controls.add(new DontShowNotificationProperty("resources_search_for_node_text_without_question.tooltip", "resources_search_for_node_text_without_question"));
            return controls;
        }
    }

    public class CachePurger
    extends TimerTask {
        private final File mCacheDirectory;
        private final long mCacheMaxAge;

        public CachePurger(File pCacheDirectory, long pCacheMaxAge) {
            this.mCacheDirectory = pCacheDirectory;
            this.mCacheMaxAge = pCacheMaxAge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tools.IntHolder intHolder = Registration.this.mCachePurgerSemaphore;
            synchronized (intHolder) {
                if (Registration.this.mCachePurgerSemaphore.getValue() > 0) {
                    return;
                }
                Registration.this.mCachePurgerSemaphore.setValue(1);
            }
            try {
                Registration.this.logger.info("Start purging for " + this.mCacheDirectory);
                if (this.mCacheDirectory.exists()) {
                    File[] cacheDirectories = this.mCacheDirectory.listFiles();
                    for (int i = 0; i < cacheDirectories.length; ++i) {
                        File cacheDirectory = cacheDirectories[i];
                        this.purgeDirectory(cacheDirectory);
                    }
                }
                Registration.this.logger.info("Finished purging");
            }
            finally {
                Registration.this.mCachePurgerSemaphore.setValue(0);
            }
        }

        private void purgeDirectory(File pCacheDirectory) {
            Registration.this.logger.fine("Start purging for subdir " + pCacheDirectory);
            File[] listTagFiles = pCacheDirectory.listFiles(new AgeFilter(System.currentTimeMillis() - this.mCacheMaxAge));
            if (listTagFiles == null) {
                return;
            }
            for (int i = 0; i < listTagFiles.length; ++i) {
                File tagFile = listTagFiles[i];
                File imageFile = new File(tagFile.getPath().replace(".tags", ".png"));
                try {
                    Registration.this.logger.finest("Deleting " + tagFile);
                    Registration.this.logger.finest("Deleting " + imageFile);
                    tagFile.delete();
                    imageFile.delete();
                    continue;
                }
                catch (Exception e) {
                    Resources.getInstance().logException((Throwable)e);
                }
            }
        }

        private final class AgeFilter
        implements FileFilter {
            private final long mYoungestFileToAccept;

            public AgeFilter(long pYoungestFileToAccept) {
                this.mYoungestFileToAccept = pYoungestFileToAccept;
            }

            @Override
            public boolean accept(File pPathname) {
                return pPathname.getName().endsWith(".tags") && pPathname.lastModified() <= this.mYoungestFileToAccept;
            }
        }
    }
}

