/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;

public class Font {
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_NORMAL = 400;
    public static final String STYLE_NORMAL = "normal";
    public static final String STYLE_ITALIC = "italic";
    public static final FontTriplet DEFAULT_FONT = new FontTriplet("any", "normal", 400);
    private static Log log = LogFactory.getLog(class$org$apache$fop$fonts$Font == null ? (class$org$apache$fop$fonts$Font = Font.class$("org.apache.fop.fonts.Font")) : class$org$apache$fop$fonts$Font);
    private String fontName;
    private FontTriplet triplet;
    private int fontSize;
    private FontMetrics metric;
    static /* synthetic */ Class class$org$apache$fop$fonts$Font;

    public Font(String key, FontTriplet triplet, FontMetrics met, int fontSize) {
        this.fontName = key;
        this.triplet = triplet;
        this.metric = met;
        this.fontSize = fontSize;
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontTriplet getFontTriplet() {
        return this.triplet;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public boolean hasKerning() {
        return this.metric.hasKerningInfo();
    }

    public Map getKerning() {
        if (this.metric.hasKerningInfo()) {
            return this.metric.getKerningInfo();
        }
        return Collections.EMPTY_MAP;
    }

    public int getKernValue(char ch1, char ch2) {
        Integer width;
        Map kernPair = (Map)this.getKerning().get(new Integer(ch1));
        if (kernPair != null && (width = (Integer)kernPair.get(new Integer(ch2))) != null) {
            return width;
        }
        return 0;
    }

    public int getWidth(int charnum) {
        return this.metric.getWidth(charnum, this.fontSize) / 1000;
    }

    public char mapChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).mapChar(c);
        }
        char d = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        if (d != '\u0000') {
            c = d;
        } else {
            log.warn("Glyph " + c + " not available in font " + this.fontName);
            c = (char)35;
        }
        return c;
    }

    public boolean hasChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).hasChar(c);
        }
        return CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c) > '\u0000';
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        sbuf.append(this.fontName);
        sbuf.append(',');
        sbuf.append(this.fontSize);
        sbuf.append(')');
        return sbuf.toString();
    }

    public int getCharWidth(char c) {
        int width;
        if (c == '\n' || c == '\r' || c == '\t' || c == '\u00a0') {
            width = this.getCharWidth(' ');
        } else {
            width = this.hasChar(c) ? this.getWidth(this.mapChar(c)) : -1;
            if (width <= 0) {
                int em = this.getFontSize();
                int en = em / 2;
                width = c == ' ' ? em : (c == '\u2000' ? en : (c == '\u2001' ? em : (c == '\u2002' ? em / 2 : (c == '\u2003' ? this.getFontSize() : (c == '\u2004' ? em / 3 : (c == '\u2005' ? em / 4 : (c == '\u2006' ? em / 6 : (c == '\u2007' ? this.getCharWidth('0') : (c == '\u2008' ? this.getCharWidth('.') : (c == '\u2009' ? em / 5 : (c == '\u200a' ? em / 10 : (c == '\u200b' ? 0 : (c == '\u202f' ? this.getCharWidth(' ') / 2 : (c == '\u2060' ? 0 : (c == '\u3000' ? this.getCharWidth(' ') * 2 : (c == '\ufeff' ? 0 : this.getWidth(this.mapChar(c))))))))))))))))));
            }
        }
        return width;
    }

    public int getWordWidth(String word) {
        if (word == null) {
            return 0;
        }
        int wordLength = word.length();
        int width = 0;
        char[] characters = new char[wordLength];
        word.getChars(0, wordLength, characters, 0);
        int i = 0;
        while (i < wordLength) {
            width += this.getCharWidth(characters[i]);
            ++i;
        }
        return width;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

