/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.buffer.DoubleBufferConsumer;
import cern.colt.function.DoubleComparator;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import cern.jet.random.Uniform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDoubleList
extends AbstractList
implements DoubleBufferConsumer {
    protected int size;

    protected AbstractDoubleList() {
    }

    public void add(double d) {
        this.beforeInsert(this.size, d);
    }

    public void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public void addAllOfFromTo(AbstractDoubleList abstractDoubleList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractDoubleList, n, n2);
    }

    public void beforeInsert(int n, double d) {
        this.beforeInsertDummies(n, 1);
        this.set(n, d);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractDoubleList abstractDoubleList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractDoubleList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(double d) {
        return this.binarySearchFromTo(d, 0, this.size - 1);
    }

    public int binarySearchFromTo(double d, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            double d2 = this.get(n5);
            if (d2 < d) {
                n3 = n5 + 1;
                continue;
            }
            if (d2 > d) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(double d) {
        return this.indexOfFromTo(d, 0, this.size - 1) >= 0;
    }

    public void delete(double d) {
        int n = this.indexOfFromTo(d, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public double[] elements() {
        double[] dArray = new double[this.size];
        int n = this.size;
        while (--n >= 0) {
            dArray[n] = this.getQuick(n);
        }
        return dArray;
    }

    public AbstractDoubleList elements(double[] dArray) {
        this.clear();
        this.addAllOfFromTo(new DoubleArrayList(dArray), 0, dArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractDoubleList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractDoubleList abstractDoubleList = (AbstractDoubleList)object;
        if (this.size() != abstractDoubleList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractDoubleList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, double d) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, d);
        }
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        int n = 0;
        while (n < this.size) {
            if (doubleProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public double get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract double getQuick(int var1);

    public int indexOf(double d) {
        return this.indexOfFromTo(d, 0, this.size - 1);
    }

    public int indexOfFromTo(double d, int n, int n2) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        for (int i = n; i <= n2; ++i) {
            if (d != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        return this.lastIndexOfFromTo(d, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(double d, int n, int n2) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size());
        for (int i = n2; i >= n; --i) {
            if (d != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractDoubleList.checkRangeFromTo(n, n2, n3);
        double[] dArray = this.elements();
        Sorting.mergeSort(dArray, n, n2 + 1);
        this.elements(dArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, DoubleComparator doubleComparator) {
        int n3 = this.size();
        AbstractDoubleList.checkRangeFromTo(n, n2, n3);
        double[] dArray = this.elements();
        Sorting.mergeSort(dArray, n, n2 + 1, doubleComparator);
        this.elements(dArray);
        this.setSizeRaw(n3);
    }

    public AbstractDoubleList partFromTo(int n, int n2) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        DoubleArrayList doubleArrayList = new DoubleArrayList(n3);
        doubleArrayList.addAllOfFromTo(this, n, n2);
        return doubleArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractDoubleList.checkRangeFromTo(n, n2, n3);
        double[] dArray = this.elements();
        java.util.Arrays.sort(dArray, n, n2 + 1);
        this.elements(dArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, DoubleComparator doubleComparator) {
        int n3 = this.size();
        AbstractDoubleList.checkRangeFromTo(n, n2, n3);
        double[] dArray = this.elements();
        Sorting.quickSort(dArray, n, n2 + 1, doubleComparator);
        this.elements(dArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractDoubleList abstractDoubleList) {
        int n;
        if (abstractDoubleList.size() == 0) {
            return false;
        }
        int n2 = abstractDoubleList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractDoubleList.indexOfFromTo(this.getQuick(n), 0, n2) >= 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractDoubleList abstractDoubleList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractDoubleList.checkRangeFromTo(n, n2, this.size());
            AbstractDoubleList.checkRangeFromTo(n3, n3 + n4 - 1, abstractDoubleList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractDoubleList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractDoubleList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractDoubleList abstractDoubleList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractDoubleList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractDoubleList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractDoubleList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.set(n2++, ((Number)iterator.next()).doubleValue());
        }
    }

    public boolean retainAll(AbstractDoubleList abstractDoubleList) {
        int n;
        if (abstractDoubleList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = abstractDoubleList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractDoubleList.indexOfFromTo(this.getQuick(n), 0, n2) < 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            double d = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, d);
        }
    }

    public void set(int n, double d) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, d);
    }

    protected abstract void setQuick(int var1, double var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(Uniform.makeDefaultGenerator());
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            double d = this.getQuick(n3);
            this.setQuick(n3, this.getQuick(i));
            this.setQuick(i, d);
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractDoubleList times(int n) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            doubleArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return doubleArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

