/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.Arrays;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.sort.PhotoComparer;
import tim.prune.data.sort.SortMode;
import tim.prune.function.RearrangeFunction;
import tim.prune.undo.UndoRearrangePhotos;

public class RearrangePhotosFunction
extends RearrangeFunction {
    public RearrangePhotosFunction(App app) {
        super(app, false);
    }

    @Override
    public String getNameKey() {
        return "function.rearrangephotos";
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.rearrangephotos.desc";
    }

    @Override
    protected String getSortNameKey() {
        return "sortbyfilename";
    }

    @Override
    protected void finish() {
        Object object;
        Track track = this._app.getTrackInfo().getTrack();
        UndoRearrangePhotos undoRearrangePhotos = new UndoRearrangePhotos(track);
        int n = track.getNumPoints();
        DataPoint[] dataPointArray = new DataPoint[n];
        DataPoint[] dataPointArray2 = new DataPoint[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            object = track.getPoint(n4);
            if (object.getPhoto() != null) {
                dataPointArray2[n3] = object;
                ++n3;
            } else {
                dataPointArray[n2] = object;
                ++n2;
            }
            ++n4;
        }
        n4 = 0;
        if (n3 > 0) {
            object = this.getRearrangeOption();
            SortMode sortMode = this.getSortMode();
            if (sortMode != SortMode.DONT_SORT && n3 > 1) {
                RearrangePhotosFunction.sortPhotos(dataPointArray2, sortMode);
            }
            DataPoint[] dataPointArray3 = new DataPoint[n];
            if (object == RearrangeFunction.Rearrange.TO_START) {
                System.arraycopy(dataPointArray2, 0, dataPointArray3, 0, n3);
                System.arraycopy(dataPointArray, 0, dataPointArray3, n3, n2);
            } else {
                System.arraycopy(dataPointArray, 0, dataPointArray3, 0, n2);
                System.arraycopy(dataPointArray2, 0, dataPointArray3, n2, n3);
            }
            n4 = track.replaceContents(dataPointArray3) ? 1 : 0;
        }
        if (n4 != 0) {
            this._app.getTrackInfo().getSelection().clearAll();
            this._app.completeFunction(undoRearrangePhotos, I18nManager.getText("confirm.rearrangephotos"));
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.rearrange.noop"), I18nManager.getText("error.function.noop.title"), 2);
        }
    }

    private static void sortPhotos(DataPoint[] dataPointArray, SortMode sortMode) {
        PhotoComparer photoComparer = new PhotoComparer(sortMode);
        Arrays.sort(dataPointArray, photoComparer);
    }
}

