/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.IOException;

public class FileAssert {
    private FileAssert() {
    }

    public static void assertDirectory(File file, String string) {
        boolean bl = false;
        try {
            bl = file.isDirectory();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, FileAssert.fileType(file), "Directory", string);
        }
        if (!bl) {
            FileAssert.failFile(file, FileAssert.fileType(file), "Directory", string);
        }
    }

    public static void assertDirectory(File file) {
        FileAssert.assertDirectory(file, null);
    }

    public static void assertFile(File file, String string) {
        boolean bl = false;
        try {
            bl = file.isFile();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, FileAssert.fileType(file), "File", string);
        }
        if (!bl) {
            FileAssert.failFile(file, FileAssert.fileType(file), "File", string);
        }
    }

    public static void assertFile(File file) {
        FileAssert.assertFile(file, null);
    }

    public static void assertLength(File file, long l, String string) {
        long l2 = -1L;
        try {
            l2 = file.isDirectory() ? (long)file.list().length : file.length();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, String.valueOf(l2), String.valueOf(l), string);
        }
        if (l2 != l) {
            FileAssert.failFile(file, String.valueOf(l2), String.valueOf(l), string);
        }
    }

    public static void assertLength(File file, long l) {
        FileAssert.assertLength(file, l, null);
    }

    public static void assertMinLength(File file, long l, String string) {
        long l2 = -1L;
        try {
            l2 = file.isDirectory() ? (long)file.list().length : file.length();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, String.valueOf(l2), "at least " + String.valueOf(l), string);
        }
        if (l2 < l) {
            FileAssert.failFile(file, String.valueOf(l2), "at least " + String.valueOf(l), string);
        }
    }

    public static void assertMinLength(File file, long l) {
        FileAssert.assertMinLength(file, l, null);
    }

    public static void assertMaxLength(File file, long l, String string) {
        long l2 = -1L;
        try {
            l2 = file.isDirectory() ? (long)file.list().length : file.length();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, String.valueOf(l2), "at most " + String.valueOf(l), string);
        }
        if (l2 > l) {
            FileAssert.failFile(file, String.valueOf(l2), "at most " + String.valueOf(l), string);
        }
    }

    public static void assertMaxLength(File file, long l) {
        FileAssert.assertMaxLength(file, l, null);
    }

    public static void assertReadable(File file, String string) {
        boolean bl = false;
        try {
            bl = file.canRead();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, FileAssert.fileAccess(file), "Read Access", string);
        }
        if (!bl) {
            FileAssert.failFile(file, FileAssert.fileAccess(file), "Read Access", string);
        }
    }

    public static void assertReadable(File file) {
        FileAssert.assertReadable(file, null);
    }

    public static void assertWriteable(File file, String string) {
        boolean bl = false;
        try {
            bl = file.canWrite();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, FileAssert.fileAccess(file), "Write Access", string);
        }
        if (!bl) {
            FileAssert.failFile(file, FileAssert.fileAccess(file), "Write Access", string);
        }
    }

    public static void assertWriteable(File file) {
        FileAssert.assertReadable(file, null);
    }

    public static void assertReadWrite(File file, String string) {
        boolean bl = false;
        try {
            bl = file.canRead() && file.canWrite();
        }
        catch (SecurityException securityException) {
            FileAssert.failSecurity(securityException, file, FileAssert.fileAccess(file), "Read/Write Access", string);
        }
        if (!bl) {
            FileAssert.failFile(file, FileAssert.fileAccess(file), "Read/Write Access", string);
        }
    }

    public static void assertReadWrite(File file) {
        FileAssert.assertReadWrite(file, null);
    }

    public static void fail(String string, Throwable throwable) {
        AssertionError assertionError = new AssertionError((Object)string);
        ((Throwable)((Object)assertionError)).initCause(throwable);
        throw assertionError;
    }

    public static void fail(String string) {
        throw new AssertionError((Object)string);
    }

    public static void fail() {
        FileAssert.fail(null);
    }

    private static void failFile(File file, String string, String string2, String string3) {
        String string4 = "";
        if (string3 != null) {
            string4 = string3 + " ";
        }
        FileAssert.fail(string4 + "expected <" + string2 + "> but was <" + FileAssert.toString(file) + ">" + (string2 != null ? "<" + string2 + ">" : ""));
    }

    private static void failSecurity(Exception exception, File file, String string, String string2, String string3) {
        String string4 = "";
        if (string3 != null) {
            string4 = string3 + " ";
        }
        FileAssert.fail(string4 + "expected <" + string2 + "> but was <" + FileAssert.toString(file) + "><" + (exception != null && exception.getMessage() != null && exception.getMessage().length() > 0 ? exception.getMessage() : "not authorized by JVM") + ">");
    }

    private static String fileType(File file) {
        try {
            if (!file.exists()) {
                return "Non existant";
            }
            if (file.isDirectory()) {
                return "Directory";
            }
            if (file.isFile()) {
                return "File";
            }
            return "Special File";
        }
        catch (SecurityException securityException) {
            return "Unauthorized";
        }
    }

    private static String fileAccess(File file) {
        try {
            if (!file.exists()) {
                return "Non existant";
            }
            if (file.canWrite() && file.canRead()) {
                return "Read/Write Access";
            }
            if (file.canRead()) {
                return "Read only Access";
            }
            if (file.canWrite()) {
                return "Write only Access";
            }
            return "No Access";
        }
        catch (SecurityException securityException) {
            return "Unauthorized";
        }
    }

    private static String toString(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }
}

