/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.testng.collections.Lists;

public class ReflectionHelper {
    public static Method[] getLocalMethods(Class<?> clazz) {
        Method[] methodArray;
        Method[] methodArray2 = ReflectionHelper.excludingMain(clazz);
        List<Method> list = ReflectionHelper.getDefaultMethods(clazz);
        if (list != null) {
            methodArray = new Method[methodArray2.length + list.size()];
            System.arraycopy(methodArray2, 0, methodArray, 0, methodArray2.length);
            int n = methodArray2.length;
            Iterator<Method> iterator = list.iterator();
            while (iterator.hasNext()) {
                Method method;
                methodArray[n] = method = iterator.next();
                ++n;
            }
        } else {
            List list2 = Lists.newArrayList();
            for (Method method : methodArray2) {
                if (method.isBridge()) continue;
                list2.add(method);
            }
            methodArray = list2.toArray(new Method[list2.size()]);
        }
        return methodArray;
    }

    public static Method[] excludingMain(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray) {
            if ("main".equals(method.getName()) && ReflectionHelper.isStaticVoid(method) && ReflectionHelper.acceptsStringArray(method)) continue;
            linkedList.add(method);
        }
        return linkedList.toArray(new Method[linkedList.size()]);
    }

    private static boolean isStaticVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE) && Modifier.isStatic(method.getModifiers());
    }

    private static boolean acceptsStringArray(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return false;
        }
        Class<?> clazz = classArray[0];
        return clazz.isArray() && clazz.isInstance(new String[0]);
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        LinkedList<Method> linkedList = null;
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method method : clazz2.getMethods()) {
                if (Modifier.isAbstract(method.getModifiers())) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<Method>();
                }
                linkedList.add(method);
            }
        }
        return linkedList;
    }
}

