/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;

public class UrlVFS
extends VFS {
    public UrlVFS() {
        super("url", 257);
    }

    @Override
    public String constructPath(String string, String string2) {
        if (string.endsWith("/")) {
            return string + string2;
        }
        return string + "/" + string2;
    }

    @Override
    public InputStream _createInputStream(Object object, String string, boolean bl, Component component) throws IOException {
        try {
            return new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
            Object[] objectArray = new String[]{malformedURLException.getMessage()};
            VFSManager.error(component, string, "ioerror.badurl", objectArray);
            return null;
        }
    }

    @Override
    public OutputStream _createOutputStream(Object object, String string, Component component) throws IOException {
        try {
            return new URL(string).openConnection().getOutputStream();
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
            Object[] objectArray = new String[]{malformedURLException.getMessage()};
            VFSManager.error(component, string, "ioerror.badurl", objectArray);
            return null;
        }
    }

    @Override
    public String getFilePath(String string) {
        try {
            return new URL(string).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
            return super.getFilePath(string);
        }
    }
}

