/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AbstractAlgorithmConstraints
implements BCAlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    AbstractAlgorithmConstraints(AlgorithmDecomposer algorithmDecomposer) {
        this.decomposer = algorithmDecomposer;
    }

    protected void checkAlgorithmName(String string) {
        if (!this.isAlgorithmSpecified(string)) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
    }

    protected void checkKey(Key key) {
        if (null == key) {
            throw new NullPointerException("'key' cannot be null");
        }
    }

    protected void checkPrimitives(Set<BCCryptoPrimitive> set) {
        if (!this.isPrimitivesSpecified(set)) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
    }

    protected boolean containsAnyPartIgnoreCase(Set<String> set, String string) {
        if (set.isEmpty()) {
            return false;
        }
        if (this.containsIgnoreCase(set, string)) {
            return true;
        }
        if (null != this.decomposer) {
            for (String string2 : this.decomposer.decompose(string)) {
                if (!this.containsIgnoreCase(set, string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsIgnoreCase(Set<String> set, String string) {
        for (String string2 : set) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAlgorithmSpecified(String string) {
        return null != string && string.length() > 0;
    }

    protected boolean isPrimitivesSpecified(Set<BCCryptoPrimitive> set) {
        return null != set && !set.isEmpty();
    }

    protected static Set<String> asUnmodifiableSet(String[] stringArray) {
        Set<String> set;
        if (null != stringArray && stringArray.length > 0 && !(set = AbstractAlgorithmConstraints.asSet(stringArray)).isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return Collections.emptySet();
    }

    protected static Set<String> asSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (null != stringArray) {
            for (String string : stringArray) {
                if (null == string) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }
}

