/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.python.core.BufferProtocol;
import org.python.core.ByteBufferTestSupport;
import org.python.core.PyBuffer;

public class PyBufferTestSupport {
    protected int verbosity;
    private final int[] sliceLengths;
    private final int[] sliceSteps;
    private List<TestSpec> testSpecList = new LinkedList<TestSpec>();

    PyBufferTestSupport(int[] sliceLengths, int[] sliceSteps) {
        this(0, sliceLengths, sliceSteps);
    }

    PyBufferTestSupport(int verbosity, int[] sliceLengths, int[] sliceSteps) {
        this.verbosity = verbosity;
        this.sliceLengths = sliceLengths;
        this.sliceSteps = sliceSteps;
    }

    void add(ExporterFactory factory, ByteBufferTestSupport.ByteMaterial material) {
        TestSpec original = new TestSpec(factory, material);
        this.queue(original);
        int N = original.ref.length;
        int M = (N + 4) / 4;
        for (int start = 0; start <= N; start += M) {
            for (int length : this.sliceLengths) {
                if (length == 0) {
                    this.queue(original, start, 0, 1);
                    this.queue(original, start, 0, 2);
                    continue;
                }
                if (length == 1 && start < N) {
                    this.queue(original, start, 1, 1);
                    this.queue(original, start, 1, 2);
                    continue;
                }
                if (start >= N) continue;
                for (int step : this.sliceSteps) {
                    if (start + (length - 1) * step >= N) continue;
                    this.queue(original, start, length, step);
                }
                for (int step : this.sliceSteps) {
                    if (start - (length - 1) * step < 0) continue;
                    this.queue(original, start, length, -step);
                }
            }
        }
    }

    private void queue(TestSpec spec) {
        if (this.verbosity > 2) {
            System.out.printf("queue non-slice: length=%d, readonly=%s\n", spec.ref.length, spec.readonly);
        }
        this.testSpecList.add(spec);
    }

    private void queue(TestSpec original, int start, int length, int step) {
        block3: {
            try {
                if (this.verbosity > 2) {
                    System.out.printf("  queue slice: start=%4d, length=%4d, step=%4d\n", start, length, step);
                }
                SlicedTestSpec spec = new SlicedTestSpec(original, 1, start, length, step);
                this.testSpecList.add(spec);
            }
            catch (Exception e) {
                if (this.verbosity <= 2) break block3;
                System.out.printf("*** SKIP %s\n", e);
            }
        }
    }

    List<TestSpec[]> getTestData() {
        ArrayList<TestSpec[]> r = new ArrayList<TestSpec[]>(this.testSpecList.size());
        for (TestSpec spec : this.testSpecList) {
            r.add(new TestSpec[]{spec});
        }
        return r;
    }

    static byte[] bytesFromByteAt(PyBuffer v) {
        int N = v.getLen();
        byte[] a = new byte[N];
        for (int i = 0; i < N; ++i) {
            a[i] = v.byteAt(i);
        }
        return a;
    }

    static class SlicedTestSpec
    extends TestSpec {
        final int itemsize;
        final int first;
        final int count;
        final int step;
        final int start;
        static final int[] strided1DFlags = new int[]{24, 280, 284};
        static final int[] strided1DTassles = new int[]{0, 4};

        SlicedTestSpec(TestSpec parent, int itemsize, int first, int count2, int step) {
            super(parent, parent.ref.slice(itemsize, first, count2, step), new int[]{count2}, new int[1], strided1DFlags, strided1DTassles);
            if (parent.getItemsize() != 1) {
                throw new IllegalArgumentException("Only byte-array parent supported");
            }
            this.itemsize = itemsize;
            this.first = first;
            this.count = count2;
            this.step = step;
            this.start = parent.getStart() + first * parent.getStride();
            this.strides[0] = step * parent.getStride();
        }

        @Override
        int getItemsize() {
            return this.itemsize;
        }

        @Override
        int getStart() {
            return this.start;
        }

        @Override
        public TestSpec.ObjectAndView makePair() {
            TestSpec.ObjectAndView pair = this.parent.makePair();
            PyBuffer view = pair.view.getBufferSlice(this.flags, this.first, this.count, this.step);
            pair.view.release();
            return new TestSpec.ObjectAndView(pair.obj, view);
        }
    }

    static class TestSpec {
        final ExporterFactory factory;
        final ByteBufferTestSupport.ByteMaterial ref;
        final boolean readonly;
        final boolean hasArray;
        final TestSpec parent;
        final int[] shape;
        final int[] strides;
        final int flags;
        final int[] validFlags;
        final int[] validTassles;
        static final int[] simpleFlags = new int[]{0, 8, 24, 280, 284};
        static final int[] simpleTassles = new int[]{0, 4, 56, 88, 152};

        TestSpec(ExporterFactory factory, ByteBufferTestSupport.ByteMaterial ref) {
            this(null, factory, ref, new int[]{ref.length}, new int[]{1}, simpleFlags, simpleTassles);
        }

        protected TestSpec(TestSpec parent, ByteBufferTestSupport.ByteMaterial ref, int[] shape, int[] strides, int[] validFlags, int[] validTassles) {
            this(parent, parent.getOriginal().factory, ref, shape, strides, validFlags, validTassles);
        }

        protected TestSpec(TestSpec parent, ExporterFactory factory, ByteBufferTestSupport.ByteMaterial ref, int[] shape, int[] strides, int[] validFlags, int[] validTassles) {
            this.parent = parent;
            this.factory = factory;
            this.readonly = factory.isReadonly();
            this.hasArray = factory.hasArray();
            this.flags = (this.readonly ? 284 : 285) | (this.hasArray ? 0x10000000 : 0);
            this.ref = ref;
            this.shape = shape;
            this.strides = strides;
            this.validFlags = validFlags;
            this.validTassles = validTassles;
        }

        final TestSpec getParent() {
            return this.parent;
        }

        final boolean isOriginal() {
            return this.parent == null;
        }

        final TestSpec getOriginal() {
            TestSpec p = this;
            while (!p.isOriginal()) {
                p = p.getParent();
            }
            return p;
        }

        int getItemsize() {
            return 1;
        }

        int getStride() {
            return this.strides[0];
        }

        int getStart() {
            return 0;
        }

        public ObjectAndView makePair() {
            BufferProtocol obj = this.factory.make(this.ref);
            PyBuffer view = obj.getBuffer(this.flags);
            return new ObjectAndView(obj, view);
        }

        public String toString() {
            String plus;
            ObjectAndView pair = this.makePair();
            BufferProtocol obj = pair.obj;
            PyBuffer view = pair.view;
            StringBuilder sb = new StringBuilder(100);
            sb.append(obj.getClass().getSimpleName()).append('[');
            int stride = this.getStride();
            int offset = view.hasArray() ? view.getBuf().offset : view.getNIOByteBuffer().position();
            if (offset > 0) {
                sb.append(offset);
            }
            String string = plus = offset == 0 ? "" : "+";
            if (stride == 1) {
                sb.append(plus).append("k]");
            } else if (stride == -1) {
                sb.append("-k]");
            } else if (stride < 0) {
                sb.append("-").append(-stride).append("*k]");
            } else {
                sb.append(plus).append(stride).append("*k]");
            }
            while (sb.length() < 30) {
                sb.append(' ');
            }
            sb.append(view.isReadonly() ? "R " : "W ");
            sb.append("ref = ").append(this.ref.toString());
            return sb.toString();
        }

        static class ObjectAndView {
            final BufferProtocol obj;
            final PyBuffer view;

            ObjectAndView(BufferProtocol obj, PyBuffer view) {
                this.obj = obj;
                this.view = view;
            }
        }
    }

    static abstract class WritableExporterFactory
    implements ExporterFactory {
        WritableExporterFactory() {
        }

        @Override
        public boolean isReadonly() {
            return false;
        }

        @Override
        public boolean hasArray() {
            return true;
        }
    }

    static abstract class ReadonlyExporterFactory
    implements ExporterFactory {
        ReadonlyExporterFactory() {
        }

        @Override
        public boolean isReadonly() {
            return true;
        }

        @Override
        public boolean hasArray() {
            return true;
        }
    }

    static interface ExporterFactory {
        public BufferProtocol make(ByteBufferTestSupport.ByteMaterial var1);

        public boolean isReadonly();

        public boolean hasArray();
    }
}

