/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonObjectJvmStaticLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm"})
final class SingletonObjectJvmStaticLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public SingletonObjectJvmStaticLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        if (!IrUtilsKt.isNonCompanionObject(irClass2)) {
            return;
        }
        for (IrSimpleFunction function2 : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions(irClass2)) {
            IrValueParameter irValueParameter;
            if (!JvmStaticAnnotationLoweringKt.access$isJvmStaticDeclaration(function2) || (irValueParameter = function2.getDispatchReceiverParameter()) == null) continue;
            IrValueParameter irValueParameter2 = irValueParameter;
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter oldDispatchReceiverParameter = irValueParameter2;
            boolean bl3 = false;
            function2.setDispatchReceiverParameter(null);
            org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.replaceThisByStaticReference(function2, this.getContext().getCachedDeclarations$backend_jvm(), irClass2, oldDispatchReceiverParameter);
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

