/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.DeadCodeElimination;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "getHasChanges", "()Z", "setHasChanges", "(Z)V", "apply", "EliminationVisitor", "js.translator"})
public final class DeadCodeElimination {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;

    public DeadCodeElimination(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        this.root = root2;
    }

    public final boolean getHasChanges() {
        return this.hasChanges;
    }

    public final void setHasChanges(boolean bl) {
        this.hasChanges = bl;
    }

    public final boolean apply() {
        new EliminationVisitor().accept((JsNode)this.root);
        return this.hasChanges;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020(H\u0016J \u0010)\u001a\u00020\u00142\b\u0010*\u001a\u0004\u0018\u00010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0-H\u0002J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020/H\u0016J\u0016\u00100\u001a\u00020\u00142\f\u00101\u001a\b\u0012\u0004\u0012\u00020+02H\u0002J\u0010\u00103\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020:H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination$EliminationVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "(Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination;)V", "breakLabels", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getBreakLabels", "()Ljava/util/Set;", "setBreakLabels", "(Ljava/util/Set;)V", "canContinue", "", "getCanContinue", "()Z", "setCanContinue", "(Z)V", "localBreakExists", "getLocalBreakExists", "setLocalBreakExists", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitBreak", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "visitDoWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitFor", "Lorg/jetbrains/kotlin/js/backend/ast/JsFor;", "visitForIn", "Lorg/jetbrains/kotlin/js/backend/ast/JsForIn;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "visitLoop", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "additionalExitCondition", "Lkotlin/Function0;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitStatements", "statements", "", "visitThrow", "Lorg/jetbrains/kotlin/js/backend/ast/JsThrow;", "visitTry", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visitWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsWhile;", "js.translator"})
    public final class EliminationVisitor
    extends RecursiveJsVisitor {
        @NotNull
        private Set<JsName> breakLabels;
        private boolean localBreakExists;
        private boolean canContinue;

        public EliminationVisitor() {
            Intrinsics.checkNotNullParameter(DeadCodeElimination.this, "this$0");
            boolean bl = false;
            this.breakLabels = new LinkedHashSet();
        }

        @NotNull
        public final Set<JsName> getBreakLabels() {
            return this.breakLabels;
        }

        public final void setBreakLabels(@NotNull Set<JsName> set) {
            Intrinsics.checkNotNullParameter(set, "<set-?>");
            this.breakLabels = set;
        }

        public final boolean getLocalBreakExists() {
            return this.localBreakExists;
        }

        public final void setLocalBreakExists(boolean bl) {
            this.localBreakExists = bl;
        }

        public final boolean getCanContinue() {
            return this.canContinue;
        }

        public final void setCanContinue(boolean bl) {
            this.canContinue = bl;
        }

        @Override
        public void visitBreak(@NotNull JsBreak x) {
            JsName name;
            Intrinsics.checkNotNullParameter(x, "x");
            JsNameRef jsNameRef = x.getLabel();
            JsName jsName = name = jsNameRef == null ? null : jsNameRef.getName();
            if (name != null) {
                this.breakLabels.add(name);
            } else {
                this.localBreakExists = true;
            }
            this.canContinue = false;
        }

        @Override
        public void visitContinue(@NotNull JsContinue x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.canContinue = false;
        }

        @Override
        public void visitLabel(@NotNull JsLabel x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.accept((JsNode)x.getStatement());
            if (!this.canContinue && this.breakLabels.contains(x.getName())) {
                this.canContinue = true;
            }
            this.breakLabels.remove(x.getName());
        }

        @Override
        public void visitBlock(@NotNull JsBlock x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.canContinue = true;
            List<JsStatement> list2 = x.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "x.statements");
            this.visitStatements(list2);
        }

        private final void visitStatements(List<JsStatement> statements2) {
            Iterator<JsStatement> iterator2 = statements2.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                JsStatement statement2 = iterator2.next();
                this.accept((JsNode)statement2);
                if (this.canContinue) continue;
                List<JsStatement> removedStatements = statements2.subList(index2 + 1, statements2.size());
                Collection collection = removedStatements;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                DeadCodeElimination.this.setHasChanges(true);
                removedStatements.clear();
                break;
            }
        }

        @Override
        public void visitWhile(@NotNull JsWhile x) {
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getCondition());
            this.visitLoop(x.getBody(), new Function0<Boolean>(x){
                final /* synthetic */ JsWhile $x;
                {
                    this.$x = $x;
                    super(0);
                }

                public final boolean invoke() {
                    JsExpression condition = this.$x.getCondition();
                    return !(condition instanceof JsBooleanLiteral) || !((JsBooleanLiteral)condition).getValue();
                }
            });
        }

        @Override
        public void visitDoWhile(@NotNull JsDoWhile x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.visitWhile(x);
        }

        @Override
        public void visitFor(@NotNull JsFor x) {
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getCondition());
            new EliminationVisitor().accept((JsNode)x.getInitExpression());
            new EliminationVisitor().accept((JsNode)x.getInitVars());
            new EliminationVisitor().accept((JsNode)x.getIncrementExpression());
            this.visitLoop(x.getBody(), visitFor.1.INSTANCE);
        }

        @Override
        public void visitForIn(@NotNull JsForIn x) {
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getIterExpression());
            this.visitLoop(x.getBody(), visitForIn.1.INSTANCE);
        }

        private final void visitLoop(JsStatement body2, Function0<Boolean> additionalExitCondition) {
            boolean localBreakExistsBackup = this.localBreakExists;
            this.localBreakExists = false;
            if (body2 != null) {
                this.accept((JsNode)body2);
            }
            if (!this.canContinue) {
                this.canContinue = additionalExitCondition.invoke() != false || this.localBreakExists;
            }
            this.localBreakExists = localBreakExistsBackup;
        }

        @Override
        public void visitIf(@NotNull JsIf x) {
            JsStatement elseStatement;
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getIfExpression());
            boolean result2 = false;
            this.accept((JsNode)x.getThenStatement());
            if (this.canContinue) {
                result2 = true;
            }
            if ((elseStatement = x.getElseStatement()) != null) {
                this.accept((JsNode)x.getElseStatement());
                if (this.canContinue) {
                    result2 = true;
                }
            } else {
                result2 = true;
            }
            this.canContinue = result2;
        }

        @Override
        public void visitTry(@NotNull JsTry x) {
            Intrinsics.checkNotNullParameter(x, "x");
            boolean result2 = false;
            this.accept((JsNode)x.getTryBlock());
            if (this.canContinue) {
                result2 = true;
            }
            for (JsCatch catchBlock : x.getCatches()) {
                this.accept((JsNode)catchBlock.getBody());
                if (!this.canContinue) continue;
                result2 = true;
            }
            JsBlock finallyBlock = x.getFinallyBlock();
            if (finallyBlock != null) {
                this.accept((JsNode)finallyBlock);
                if (!this.canContinue) {
                    result2 = false;
                }
            }
            this.canContinue = result2;
        }

        @Override
        public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getExpression());
            this.canContinue = true;
        }

        @Override
        public void visit(@NotNull JsSwitch x) {
            Intrinsics.checkNotNullParameter(x, "x");
            new EliminationVisitor().accept((JsNode)x.getExpression());
            boolean localBreakExistsBackup = this.localBreakExists;
            boolean defaultCanContinue = true;
            boolean allCasesCantContinue = true;
            for (JsSwitchMember caseBlock : x.getCases()) {
                this.canContinue = true;
                List<JsStatement> list2 = caseBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "caseBlock.statements");
                this.visitStatements(list2);
                if (!this.canContinue && this.localBreakExists) {
                    this.canContinue = true;
                }
                if (caseBlock instanceof JsDefault) {
                    defaultCanContinue = this.canContinue;
                    continue;
                }
                if (!allCasesCantContinue || !this.canContinue) continue;
                allCasesCantContinue = false;
            }
            this.canContinue = !allCasesCantContinue || defaultCanContinue;
            this.localBreakExists = localBreakExistsBackup;
        }

        @Override
        public void visitThrow(@NotNull JsThrow x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.canContinue = false;
        }

        @Override
        public void visitReturn(@NotNull JsReturn x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.canContinue = false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVars(@NotNull JsVars x) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(x, "x");
            Iterable<JsVars.JsVar> iterable = x.getVars();
            Intrinsics.checkNotNullExpressionValue(iterable, "x.vars");
            iterable = iterable;
            DeadCodeElimination deadCodeElimination = DeadCodeElimination.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsVars.JsVar it = (JsVars.JsVar)element$iv;
                boolean bl = false;
                deadCodeElimination.new EliminationVisitor().accept((JsNode)it);
            }
            this.canContinue = true;
        }
    }
}

