/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantLabelRemoval;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "labelUsages", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "analyze", "", "apply", "perform", "statements", "", "name", "statement", "unuseLabel", "useLabel", "js.translator"})
public final class RedundantLabelRemoval {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Map<JsName, Integer> labelUsages;
    private boolean hasChanges;

    public RedundantLabelRemoval(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        this.root = root2;
        boolean bl = false;
        this.labelUsages = new LinkedHashMap();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                super.endVisit(x, ctx);
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    RedundantLabelRemoval redundantLabelRemoval = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNameRef it = jsNameRef2;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull(jsName);
                    JsName jsName2 = jsName;
                    RedundantLabelRemoval.access$useLabel(redundantLabelRemoval, jsName2);
                }
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                super.endVisit(x, ctx);
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    RedundantLabelRemoval redundantLabelRemoval = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNameRef it = jsNameRef2;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull(jsName);
                    JsName jsName2 = jsName;
                    RedundantLabelRemoval.access$useLabel(redundantLabelRemoval, jsName2);
                }
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    Object object = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue(object, "x.statement");
                    JsStatement jsStatement = object;
                    object = x.getName();
                    Intrinsics.checkNotNullExpressionValue(object, "x.name");
                    x.setStatement(RedundantLabelRemoval.access$perform(this.this$0, jsStatement, (JsName)object));
                    object = (Integer)RedundantLabelRemoval.access$getLabelUsages$p(this.this$0).get(x.getName());
                    if ((object == null ? 0 : (Integer)object) == 0) {
                        RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)x.getStatement());
                    }
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                return false;
            }
        }.accept((JsNode)this.root);
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement perform(JsStatement statement2, JsName name) {
        JsStatement jsStatement;
        JsStatement jsStatement2 = statement2;
        if (jsStatement2 instanceof JsBreak) {
            JsNode jsNode;
            JsNameRef jsNameRef = ((JsBreak)statement2).getLabel();
            if (Intrinsics.areEqual(name, jsNameRef == null ? null : jsNameRef.getName())) {
                this.unuseLabel(name);
                this.hasChanges = true;
                jsNode = JsEmpty.INSTANCE;
            } else {
                jsNode = statement2;
            }
            jsStatement = (JsStatement)jsNode;
        } else if (jsStatement2 instanceof JsLabel) {
            JsStatement jsStatement3 = ((JsLabel)statement2).getStatement();
            Intrinsics.checkNotNullExpressionValue(jsStatement3, "statement.statement");
            this.perform(jsStatement3, name);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
            this.perform(list2, name);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsIf) {
            JsStatement jsStatement4;
            JsIf jsIf = (JsIf)statement2;
            JsStatement jsStatement5 = ((JsIf)statement2).getThenStatement();
            Intrinsics.checkNotNullExpressionValue(jsStatement5, "statement.thenStatement");
            jsIf.setThenStatement(this.perform(jsStatement5, name));
            JsIf jsIf2 = (JsIf)statement2;
            jsStatement5 = ((JsIf)statement2).getElseStatement();
            if (jsStatement5 == null) {
                jsStatement4 = null;
            } else {
                void it;
                JsStatement jsStatement6 = jsStatement5;
                boolean bl = false;
                boolean bl2 = false;
                JsStatement jsStatement7 = jsStatement6;
                JsIf jsIf3 = jsIf2;
                boolean bl3 = false;
                JsStatement jsStatement8 = this.perform((JsStatement)it, name);
                jsIf2 = jsIf3;
                jsStatement4 = jsStatement8;
            }
            jsIf2.setElseStatement(jsStatement4);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsTry) {
            JsBlock jsBlock = ((JsTry)statement2).getTryBlock();
            Intrinsics.checkNotNullExpressionValue(jsBlock, "statement.tryBlock");
            this.perform(jsBlock, name);
            jsStatement = statement2;
        } else {
            jsStatement = statement2;
        }
        return jsStatement;
    }

    private final void perform(List<JsStatement> statements2, JsName name) {
        JsStatement jsStatement = CollectionsKt.lastOrNull(statements2);
        if (jsStatement != null) {
            JsStatement jsStatement2 = jsStatement;
            boolean bl = false;
            boolean bl2 = false;
            JsStatement it = jsStatement2;
            boolean bl3 = false;
            statements2.set(CollectionsKt.getLastIndex(statements2), this.perform(it, name));
        }
    }

    private final void useLabel(JsName name) {
        Map<JsName, Integer> map = this.labelUsages;
        Integer n = this.labelUsages.get(name);
        n = (n == null ? 0 : n) + 1;
        boolean bl = false;
        map.put(name, n);
    }

    private final void unuseLabel(JsName name) {
        Map<JsName, Integer> map = this.labelUsages;
        Integer n = this.labelUsages.get(name);
        Intrinsics.checkNotNull(n);
        n = n - 1;
        boolean bl = false;
        map.put(name, n);
    }

    public static final /* synthetic */ void access$useLabel(RedundantLabelRemoval $this, JsName name) {
        $this.useLabel(name);
    }

    public static final /* synthetic */ JsStatement access$perform(RedundantLabelRemoval $this, JsStatement statement2, JsName name) {
        return $this.perform(statement2, name);
    }

    public static final /* synthetic */ Map access$getLabelUsages$p(RedundantLabelRemoval $this) {
        return $this.labelUsages;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantLabelRemoval $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

