/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class ControlFlowAnalyzer {
    private final BindingTrace trace;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;

    public ControlFlowAnalyzer(@NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
        if (trace == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        if (languageVersionSettings == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (diagnosticSuppressor == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this.trace = trace;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        for (KtFile ktFile : c.getFiles()) {
            this.checkDeclarationContainer(c, ktFile);
        }
        for (KtClassOrObject ktClassOrObject : c.getDeclaredClasses().keySet()) {
            this.checkDeclarationContainer(c, ktClassOrObject);
        }
        for (KtScript ktScript : c.getScripts().keySet()) {
            this.checkDeclarationContainer(c, ktScript);
        }
        for (KtSecondaryConstructor ktSecondaryConstructor : c.getSecondaryConstructors().keySet()) {
            this.checkSecondaryConstructor(ktSecondaryConstructor);
        }
        for (Map.Entry entry : c.getFunctions().entrySet()) {
            KtNamedFunction function2 = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            KotlinType expectedReturnType = !function2.hasBlockBody() && !function2.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(c, function2, expectedReturnType);
        }
        for (Map.Entry entry : c.getProperties().entrySet()) {
            KtProperty property2 = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(c, property2, propertyDescriptor);
        }
    }

    private void checkSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2) {
        if (constructor2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(constructor2, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(this.builtIns.getUnitType());
    }

    private void checkDeclarationContainer(@NotNull BodiesResolveContext c, KtDeclarationContainer declarationContainer) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider((KtElement)((Object)declarationContainer), this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
    }

    private void checkProperty(@NotNull BodiesResolveContext c, KtProperty property2, PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        for (KtPropertyAccessor accessor : property2.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            KotlinType returnType2 = accessorDescriptor.getReturnType();
            this.checkFunction(c, accessor, returnType2);
        }
    }

    private void checkFunction(@NotNull BodiesResolveContext c, @NotNull KtDeclarationWithBody function2, @Nullable KotlinType expectedReturnType) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        if (function2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(function2, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(expectedReturnType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticSuppressor";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSecondaryConstructor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeclarationContainer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

