/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J%\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isInCycle", "", "T", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;Ljava/lang/Object;)Z", "Graph", "GraphBuilder", "frontend"})
public final class FiniteBoundRestrictionChecker {
    @NotNull
    public static final FiniteBoundRestrictionChecker INSTANCE = new FiniteBoundRestrictionChecker();

    private FiniteBoundRestrictionChecker() {
    }

    @JvmStatic
    public static final void check(@NotNull KtClass declaration2, @NotNull ClassDescriptor classDescriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List problemNodes;
        DeclarationDescriptor it;
        Collection destination$iv$iv;
        block10: {
            PsiElement $this$filterTo$iv$iv;
            Iterator<TypeParameterDescriptor> $this$filter$iv;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(classDescriptor2, "classDescriptor");
            Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
            TypeConstructor typeConstructor2 = classDescriptor2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "classDescriptor.typeConstructor");
            TypeConstructor typeConstructor3 = typeConstructor2;
            if (typeConstructor3.getParameters().isEmpty()) {
                return;
            }
            Graph<TypeParameterDescriptor> graph2 = new GraphBuilder(typeConstructor3).build();
            Iterable iterable = graph2.getNodes();
            FiniteBoundRestrictionChecker finiteBoundRestrictionChecker = INSTANCE;
            boolean $i$f$filter = false;
            void var9_12 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (TypeParameterDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (!finiteBoundRestrictionChecker.isInCycle(graph2, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            problemNodes = (List)destination$iv$iv;
            if (problemNodes.isEmpty()) {
                return;
            }
            for (TypeParameterDescriptor typeParameter : typeConstructor3.getParameters()) {
                if (!problemNodes.contains(typeParameter)) continue;
                Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                $this$filterTo$iv$iv = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter);
                PsiElement element = $this$filterTo$iv$iv == null ? (PsiElement)declaration2 : $this$filterTo$iv$iv;
                diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION.on(element));
                return;
            }
            Iterable $this$any$iv = problemNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    TypeParameterDescriptor it2 = (TypeParameterDescriptor)element$iv2;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it2.getSource(), SourceElement.NO_SOURCE))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$map$iv = problemNodes;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            object = it.getContainingDeclaration();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            object = DescriptorUtilsKt.getFqNameUnsafe(it).asString();
            collection.add(object);
        }
        SortedSet typeFqNames = CollectionsKt.toSortedSet((List)destination$iv$iv);
        diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION_IN_JAVA.on(declaration2, CollectionsKt.joinToString$default(typeFqNames, ", ", null, null, 0, null, null, 62, null)));
    }

    private final <T> boolean isInCycle(Graph<T> $this$isInCycle, T from) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        DFS.VisitedWithSet visited2 = new DFS.VisitedWithSet<T>(from, result2){
            final /* synthetic */ T $from;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$from = $from;
                this.$result = $result;
            }

            public boolean checkAndMarkVisited(T current2) {
                boolean added = super.checkAndMarkVisited(current2);
                if (!added && Intrinsics.areEqual(current2, this.$from)) {
                    this.$result.element = true;
                }
                return added;
            }
        };
        DFS.AbstractNodeHandler handler2 = new DFS.AbstractNodeHandler<T, Unit>(){

            public void result() {
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($this$isInCycle){
            final /* synthetic */ Graph<T> $this_isInCycle;
            {
                this.$this_isInCycle = $receiver;
            }

            @NotNull
            public List<T> getNeighbors(T current2) {
                return this.$this_isInCycle.getNeighbors(current2);
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, visited2, handler2);
        return result2.element;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\rj\b\u0012\u0004\u0012\u00020\u0003`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "Lkotlin/collections/HashMap;", "nodes", "", "processedTypeConstructors", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "build", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "buildGraph", "", "frontend"})
    private static final class GraphBuilder {
        @NotNull
        private final TypeConstructor typeConstructor;
        @NotNull
        private final Set<TypeParameterDescriptor> nodes;
        @NotNull
        private final HashMap<TypeParameterDescriptor, List<TypeParameterDescriptor>> edgeLists;
        @NotNull
        private final HashSet<TypeConstructor> processedTypeConstructors;

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
            this.typeConstructor = typeConstructor2;
            boolean bl = false;
            this.nodes = new HashSet();
            bl = false;
            this.edgeLists = new HashMap();
            bl = false;
            this.processedTypeConstructors = new HashSet();
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.buildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final Set<TypeParameterDescriptor> nodes;
                final /* synthetic */ GraphBuilder this$0;
                {
                    this.this$0 = $receiver;
                    this.nodes = GraphBuilder.access$getNodes$p(this.this$0);
                }

                @NotNull
                public Set<TypeParameterDescriptor> getNodes() {
                    return this.nodes;
                }

                @NotNull
                public List<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkNotNullParameter(node, "node");
                    List list2 = (List)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    return list2 == null ? CollectionsKt.emptyList() : list2;
                }
            };
        }

        private final boolean addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to) {
            Object object;
            Map $this$getOrPut$iv = this.edgeLists;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(from);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((List)object).add(to);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildGraph(TypeConstructor typeConstructor2) {
            List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "typeConstructor.parameters");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)element$iv;
                boolean bl = false;
                List<KotlinType> list3 = typeParameter.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list3, "typeParameter.upperBounds");
                Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)list3);
                Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                for (KotlinType constituentType : constituentTypes) {
                    TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                    if (!this.processedTypeConstructors.contains(constituentTypeConstructor)) {
                        this.processedTypeConstructors.add(constituentTypeConstructor);
                        this.buildGraph(constituentTypeConstructor);
                    }
                    if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                    Iterable $this$forEachIndexed$iv = constituentType.getArguments();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void typeProjection;
                        int n = index$iv++;
                        boolean bl2 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        TypeProjection typeProjection2 = (TypeProjection)item$iv;
                        int i = n;
                        boolean bl3 = false;
                        if (typeProjection.getProjectionKind() == Variance.INVARIANT) continue;
                        Intrinsics.checkNotNullExpressionValue(typeParameter, "typeParameter");
                        this.nodes.add(typeParameter);
                        TypeParameterDescriptor typeParameterDescriptor = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "constituentTypeConstructor.parameters[i]");
                        this.nodes.add(typeParameterDescriptor);
                        typeParameterDescriptor = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "constituentTypeConstructor.parameters[i]");
                        this.addEdge(typeParameter, typeParameterDescriptor);
                    }
                }
            }
        }

        public static final /* synthetic */ Set access$getNodes$p(GraphBuilder $this) {
            return $this.nodes;
        }

        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "T", "", "nodes", "", "getNodes", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/List;", "frontend"})
    private static interface Graph<T> {
        @NotNull
        public Set<T> getNodes();

        @NotNull
        public List<T> getNeighbors(T var1);
    }
}

