/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DateParser {
    private static final PlatformLogger logger = PlatformLogger.getLogger(DateParser.class.getName());
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("[\\x09\\x20-\\x2F\\x3B-\\x40\\x5B-\\x60\\x7B-\\x7E]+");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})(?:[^\\d].*)*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})(?:[^\\d].*)*");
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})(?:[^\\d].*)*");
    private static final Map<String, Integer> MONTH_MAP = Map.ofEntries(Map.entry("jan", 0), Map.entry("feb", 1), Map.entry("mar", 2), Map.entry("apr", 3), Map.entry("may", 4), Map.entry("jun", 5), Map.entry("jul", 6), Map.entry("aug", 7), Map.entry("sep", 8), Map.entry("oct", 9), Map.entry("nov", 10), Map.entry("dec", 11));

    private DateParser() {
        throw new AssertionError();
    }

    static long parse(String string) throws ParseException {
        logger.finest("date: [{0}]", string);
        Time time = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        String[] stringArray = DELIMITER_PATTERN.split(string, 0);
        for (String string2 : stringArray) {
            Integer n4;
            Integer n5;
            Integer n6;
            Time time2;
            if (string2.length() == 0) continue;
            if (time == null && (time2 = DateParser.parseTime(string2)) != null) {
                time = time2;
                continue;
            }
            if (n == null && (n6 = DateParser.parseDayOfMonth(string2)) != null) {
                n = n6;
                continue;
            }
            if (n2 == null && (n5 = DateParser.parseMonth(string2)) != null) {
                n2 = n5;
                continue;
            }
            if (n3 != null || (n4 = DateParser.parseYear(string2)) == null) continue;
            n3 = n4;
        }
        if (n3 != null) {
            if (n3 >= 70 && n3 <= 99) {
                n3 = n3 + 1900;
            } else if (n3 >= 0 && n3 <= 69) {
                n3 = n3 + 2000;
            }
        }
        if (time == null || n == null || n2 == null || n3 == null || n < 1 || n > 31 || n3 < 1601 || time.hour > 23 || time.minute > 59 || time.second > 59) {
            throw new ParseException("Error parsing date", 0);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        calendar.setLenient(false);
        calendar.clear();
        calendar.set(n3, n2, n, time.hour, time.minute, time.second);
        try {
            long l = calendar.getTimeInMillis();
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("result: [{0}]", new Date(l).toString());
            }
            return l;
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException("Error parsing date", 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    private static Time parseTime(String string) {
        Matcher matcher = TIME_PATTERN.matcher(string);
        if (matcher.matches()) {
            return new Time(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }
        return null;
    }

    private static Integer parseDayOfMonth(String string) {
        Matcher matcher = DAY_OF_MONTH_PATTERN.matcher(string);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }

    private static Integer parseMonth(String string) {
        if (string.length() >= 3) {
            return MONTH_MAP.get(string.substring(0, 3).toLowerCase());
        }
        return null;
    }

    private static Integer parseYear(String string) {
        Matcher matcher = YEAR_PATTERN.matcher(string);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }

    private static final class Time {
        private final int hour;
        private final int minute;
        private final int second;

        private Time(int n, int n2, int n3) {
            this.hour = n;
            this.minute = n2;
            this.second = n3;
        }
    }
}

