/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import mediathek.tool.Log;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Messages {
    ERROR_CANT_CREATE_FOLDER(Types.ERROR, "Der Ordner \"%s\" konnte nicht angelegt werden.%n Bitte pr\u00fcfen Sie die Dateirechte.");

    private static final Logger logger;
    private final Types messageType;
    private final String textPattern;
    private final Integer errorCode;

    private Messages(Types aMessageType, String aTextPattern) {
        this(aMessageType, aTextPattern, null);
    }

    private Messages(Types aMessageType, String aTextPattern, Integer aErrorCode) {
        this.messageType = aMessageType;
        this.textPattern = aTextPattern;
        this.errorCode = aErrorCode;
    }

    public static void logMessage(Messages aMessage, Exception aException, Object ... aFormattingArguments) {
        String message = aFormattingArguments == null ? aMessage.getText() : aMessage.getTextFormatted(aFormattingArguments);
        switch (aMessage.getMessageType()) {
            case ERROR: {
                if (aException == null) {
                    logger.error("Error code: {}, Message: {}", (Object)(aMessage.getErrorCode() == null ? 0 : aMessage.getErrorCode()), (Object)message);
                    break;
                }
                logger.error("Error code: {}, Message: {}", (Object)(aMessage.getErrorCode() == null ? 0 : aMessage.getErrorCode()), (Object)message);
                logger.error(aException);
                break;
            }
            case WARNING: {
                Log.sysLog(aMessage.getMessageType().toString() + ": " + message);
                break;
            }
            case INFO: {
                Log.sysLog(message);
            }
        }
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public Types getMessageType() {
        return this.messageType;
    }

    public String getTextFormatted(Object ... aFormattingArguments) {
        return String.format(this.textPattern, aFormattingArguments);
    }

    public String getText() {
        return this.textPattern;
    }

    static {
        logger = LogManager.getLogger();
    }

    public static enum Types {
        ERROR,
        WARNING,
        INFO;

    }
}

