/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.net.NetworkProcessor;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executors {
    public static final Logger logger = Misc.getLogger(Executors.class.getName(), Options.check("executors"));
    public static final int DEFAULT_NETWORK_THREAD_PRIORITY = 7;
    public static final int CORE_THREADS_NETWORK_EXECUTOR = 5;
    public static final int MAX_THREADS_NETWORK_EXECUTOR = Integer.MAX_VALUE;
    public static final int TTL_THREADS_NETWORK_EXECUTOR = 10000;
    public static final int QUEUE_SIZE_NETWORK_EXECUTOR = 50;
    public static final int DEFAULT_CACHED_THREAD_PRIORITY = 5;
    public static final int CORE_THREADS_CACHED_EXECUTOR = 5;
    public static final int MAX_THREADS_CACHED_EXECUTOR = Integer.MAX_VALUE;
    public static final int TTL_THREADS_CACHED_EXECUTOR = 10000;
    public static final int QUEUE_SIZE_CACHED_EXECUTOR = 5;
    public static final int DEFAULT_SCHEDULED_THREAD_PRIORITY = 5;
    public static final int CORE_THREADS_SCHEDULED_EXECUTOR = 5;
    public static final int MAX_THREADS_SCHEDULED_EXECUTOR = Integer.MAX_VALUE;
    public static final int TTL_THREADS_SCHEDULED_EXECUTOR = 10000;
    public static final TimeUnit THREAD_TTL_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static Executors executors;
    private final ScheduledThreadPoolExecutor scheduledExecutor = (ScheduledThreadPoolExecutor)java.util.concurrent.Executors.newScheduledThreadPool(5, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "mDNS Scheduled Thread");
            t.setDaemon(true);
            int threadPriority = 5;
            try {
                String value = Options.value("mdns_scheduled_thread_priority");
                if (value == null || value.length() == 0) {
                    value = Options.value("mdns_thread_priority");
                }
                if (value != null && value.length() == 0) {
                    threadPriority = Integer.parseInt(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            t.setPriority(threadPriority);
            t.setContextClassLoader(this.getClass().getClassLoader());
            return t;
        }
    });
    private final ThreadPoolExecutor executor;
    private final ThreadPoolExecutor networkExecutor;

    private Executors() {
        String value = Options.value("mdns_scheduled_core_threads");
        if (value != null && value.length() >= 0) {
            try {
                this.scheduledExecutor.setCorePoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_scheduled_max_threads")) != null && value.length() > 0) {
            try {
                this.scheduledExecutor.setMaximumPoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_scheduled_thread_ttl")) != null && value.length() > 0) {
            try {
                this.scheduledExecutor.setKeepAliveTime(Integer.valueOf(value).intValue(), THREAD_TTL_TIME_UNIT);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.scheduledExecutor.setKeepAliveTime(10000L, THREAD_TTL_TIME_UNIT);
        }
        this.scheduledExecutor.allowCoreThreadTimeOut(true);
        int cacheExecutorQueueSize = 5;
        try {
            value = Options.value("mdns_cached_thread_queue_size");
            if (value == null || value.length() == 0) {
                value = Options.value("mdns_thread_queue_size");
            }
            if (value != null && value.length() > 0) {
                cacheExecutorQueueSize = Integer.parseInt(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executor = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 10000L, THREAD_TTL_TIME_UNIT, new ArrayBlockingQueue<Runnable>(cacheExecutorQueueSize), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "mDNS Cached Thread");
                t.setDaemon(true);
                int threadPriority = 5;
                try {
                    String value = Options.value("mdns_cached_thread_priority");
                    if (value == null || value.length() == 0) {
                        value = Options.value("mdns_thread_priority");
                    }
                    if (value != null && value.length() == 0) {
                        threadPriority = Integer.parseInt(value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                t.setPriority(threadPriority);
                t.setContextClassLoader(NetworkProcessor.class.getClassLoader());
                return t;
            }
        }, new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.logp(Level.WARNING, this.getClass().getName(), "net.posick.mDNS.utils.RejectedExecutionHandler", "rejectedExecution", "Network Processing Queue Rejected Packet it is FULL. [size: " + executor.getQueue().size() + "]");
            }
        });
        value = Options.value("mdns_executor_core_threads");
        if (value != null && value.length() >= 0) {
            try {
                this.executor.setCorePoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_executor_max_threads")) != null && value.length() > 0) {
            try {
                this.executor.setMaximumPoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_executor_thread_ttl")) != null && value.length() > 0) {
            try {
                this.executor.setKeepAliveTime(Integer.valueOf(value).intValue(), THREAD_TTL_TIME_UNIT);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.executor.setKeepAliveTime(10000L, THREAD_TTL_TIME_UNIT);
        }
        this.executor.allowCoreThreadTimeOut(true);
        int networkExecutorQueueSize = 50;
        try {
            value = Options.value("mdns_cached_thread_queue_size");
            if (value == null || value.length() == 0) {
                value = Options.value("mdns_thread_queue_size");
            }
            if (value != null && value.length() > 0) {
                try {
                    networkExecutorQueueSize = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.networkExecutor = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 10000L, THREAD_TTL_TIME_UNIT, new ArrayBlockingQueue<Runnable>(networkExecutorQueueSize), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Network Queue Processing Thread");
                t.setDaemon(true);
                int threadPriority = 7;
                try {
                    String value = Options.value("mdns_network_thread_priority");
                    if (value == null || value.length() == 0) {
                        value = Options.value("mdns_thread_priority");
                    }
                    if (value != null && value.length() == 0) {
                        threadPriority = Integer.parseInt(value);
                    }
                    threadPriority = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                t.setPriority(threadPriority);
                t.setContextClassLoader(NetworkProcessor.class.getClassLoader());
                return t;
            }
        });
        this.networkExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                Thread t = executor.getThreadFactory().newThread(r);
                t.start();
            }
        });
        value = Options.value("mdns_network_core_threads");
        if (value != null && value.length() >= 0) {
            try {
                this.networkExecutor.setCorePoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_network_max_threads")) != null && value.length() > 0) {
            try {
                this.networkExecutor.setMaximumPoolSize(Integer.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = Options.value("mdns_network_thread_ttl")) != null && value.length() > 0) {
            try {
                this.networkExecutor.setKeepAliveTime(Integer.valueOf(value).intValue(), THREAD_TTL_TIME_UNIT);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.executor.setKeepAliveTime(10000L, THREAD_TTL_TIME_UNIT);
        }
        this.networkExecutor.allowCoreThreadTimeOut(true);
    }

    public boolean isExecutorOperational() {
        return !this.executor.isShutdown() && !this.executor.isTerminated() && !this.executor.isTerminating();
    }

    public boolean isNetworkExecutorOperational() {
        return !this.networkExecutor.isShutdown() && !this.networkExecutor.isTerminated() && !this.networkExecutor.isTerminating();
    }

    public boolean isScheduledExecutorOperational() {
        return !this.scheduledExecutor.isShutdown() && !this.scheduledExecutor.isTerminated() && !this.scheduledExecutor.isTerminating();
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public void executeNetworkTask(Runnable command) {
        this.networkExecutor.execute(command);
    }

    public static Executors newInstance() {
        if (executors == null) {
            executors = new Executors();
        }
        return executors;
    }
}

