/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.router.TurnType;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RouteResultPreparation {
    public static boolean PRINT_TO_CONSOLE_ROUTE_INFORMATION_TO_TEST = false;
    private static final float TURN_DEGREE_MIN = 45.0f;
    private Log log = PlatformUtil.getLog(RouteResultPreparation.class);
    private static final int MAX_SPEAK_PRIORITY = 5;

    List<RouteSegmentResult> prepareResult(RoutingContext ctx, BinaryRoutePlanner.FinalRouteSegment finalSegment) throws IOException {
        List<RouteSegmentResult> result = this.convertFinalSegmentToResults(ctx, finalSegment);
        this.prepareResult(ctx, result);
        return result;
    }

    List<RouteSegmentResult> prepareResult(RoutingContext ctx, List<RouteSegmentResult> result) throws IOException {
        this.validateAllPointsConnected(result);
        this.splitRoadsAndAttachRoadSegments(ctx, result);
        this.calculateTimeSpeed(ctx, result);
        for (int i = 0; i < result.size(); ++i) {
            TurnType turnType = this.getTurnInfo(result, i, ctx.leftSideNavigation);
            result.get(i).setTurnType(turnType);
        }
        this.determineTurnsToMerge(ctx.leftSideNavigation, result);
        this.justifyUTurns(ctx.leftSideNavigation, result);
        this.addTurnInfoDescriptions(result);
        return result;
    }

    private void justifyUTurns(boolean leftSide, List<RouteSegmentResult> result) {
        int i = 0;
        while (i < result.size() - 1) {
            TurnType jt;
            int next = i + 1;
            TurnType t = result.get(i).getTurnType();
            if (t != null && (jt = this.justifyUTurn(leftSide, result, i, t)) != null) {
                result.get(i).setTurnType(jt);
                next = i + 2;
            }
            i = next;
        }
    }

    private void calculateTimeSpeed(RoutingContext ctx, List<RouteSegmentResult> result) throws IOException {
        for (int i = 0; i < result.size(); ++i) {
            RouteSegmentResult rr = result.get(i);
            RouteDataObject road = rr.getObject();
            double distOnRoadToPass = 0.0;
            double speed = ctx.getRouter().defineVehicleSpeed(road);
            if (speed == 0.0) {
                speed = ctx.getRouter().getMinDefaultSpeed();
            } else if (speed > 15.0) {
                speed -= (speed - 15.0) / 15.0 * 2.0;
            }
            boolean plus = rr.getStartPointIndex() < rr.getEndPointIndex();
            double distance = 0.0;
            int j = rr.getStartPointIndex();
            while (j != rr.getEndPointIndex()) {
                int next = plus ? j + 1 : j - 1;
                double d = RouteResultPreparation.measuredDist(road.getPoint31XTile(j), road.getPoint31YTile(j), road.getPoint31XTile(next), road.getPoint31YTile(next));
                distance += d;
                double obstacle = ctx.getRouter().defineObstacle(road, j);
                if (obstacle < 0.0) {
                    obstacle = 0.0;
                }
                distOnRoadToPass += d / speed + obstacle;
                j = next;
            }
            rr.setSegmentTime((float)distOnRoadToPass);
            rr.setSegmentSpeed((float)speed);
            rr.setDistance((float)distance);
        }
    }

    private void splitRoadsAndAttachRoadSegments(RoutingContext ctx, List<RouteSegmentResult> result) throws IOException {
        for (int i = 0; i < result.size(); ++i) {
            if (ctx.checkIfMemoryLimitCritical(ctx.config.memoryLimitation)) {
                ctx.unloadUnusedTiles(ctx.config.memoryLimitation);
            }
            RouteSegmentResult rr = result.get(i);
            RouteDataObject road = rr.getObject();
            this.checkAndInitRouteRegion(ctx, road);
            boolean plus = rr.getStartPointIndex() < rr.getEndPointIndex();
            int j = rr.getStartPointIndex();
            while (j != rr.getEndPointIndex()) {
                boolean tryToSplit;
                int next;
                int n = next = plus ? j + 1 : j - 1;
                if (j == rr.getStartPointIndex()) {
                    this.attachRoadSegments(ctx, result, i, j, plus);
                }
                if (next != rr.getEndPointIndex()) {
                    this.attachRoadSegments(ctx, result, i, next, plus);
                }
                List<RouteSegmentResult> attachedRoutes = rr.getAttachedRoutes(next);
                boolean bl = tryToSplit = next != rr.getEndPointIndex() && !rr.getObject().roundabout() && attachedRoutes != null;
                if (rr.getDistance(next, plus) == 0.0f) {
                    tryToSplit = false;
                }
                if (tryToSplit) {
                    float before = rr.getBearing(next, !plus);
                    float after = rr.getBearing(next, plus);
                    if (rr.getDistance(next, plus) < 5.0f) {
                        after = before + 180.0f;
                    } else {
                        boolean bl2 = !plus;
                        if (rr.getDistance(next, bl2) < 5.0f) {
                            before = after - 180.0f;
                        }
                    }
                    boolean straight = Math.abs(MapUtils.degreesDiff(before + 180.0f, after)) < 45.0;
                    boolean isSplit = false;
                    for (RouteSegmentResult rs : attachedRoutes) {
                        double diff = MapUtils.degreesDiff(before + 180.0f, rs.getBearingBegin());
                        if (Math.abs(diff) <= 45.0) {
                            isSplit = true;
                            continue;
                        }
                        if (straight || !(Math.abs(diff) < 100.0)) continue;
                        isSplit = true;
                    }
                    if (isSplit) {
                        int endPointIndex = rr.getEndPointIndex();
                        RouteSegmentResult split = new RouteSegmentResult(rr.getObject(), next, endPointIndex);
                        split.copyPreattachedRoutes(rr, Math.abs(next - rr.getStartPointIndex()));
                        rr.setEndPointIndex(next);
                        result.add(i + 1, split);
                        ++i;
                        rr = split;
                    }
                }
                j = next;
            }
        }
    }

    private void checkAndInitRouteRegion(RoutingContext ctx, RouteDataObject road) throws IOException {
        BinaryMapIndexReader reader = ctx.reverseMap.get(road.region);
        if (reader != null) {
            reader.initRouteRegion(road.region);
        }
    }

    private void validateAllPointsConnected(List<RouteSegmentResult> result) {
        for (int i = 1; i < result.size(); ++i) {
            RouteSegmentResult rr = result.get(i);
            RouteSegmentResult pr = result.get(i - 1);
            double d = MapUtils.getDistance(pr.getPoint(pr.getEndPointIndex()), rr.getPoint(rr.getStartPointIndex()));
            if (!(d > 0.0)) continue;
            System.err.println("Points are not connected : " + pr.getObject() + "(" + pr.getEndPointIndex() + ") -> " + rr.getObject() + "(" + rr.getStartPointIndex() + ") " + d + " meters");
        }
    }

    private List<RouteSegmentResult> convertFinalSegmentToResults(RoutingContext ctx, BinaryRoutePlanner.FinalRouteSegment finalSegment) {
        ArrayList<RouteSegmentResult> result = new ArrayList<RouteSegmentResult>();
        if (finalSegment != null) {
            BinaryRoutePlanner.RouteSegment segment;
            ctx.routingTime = finalSegment.distanceFromStart;
            RouteResultPreparation.println("Routing calculated time distance " + finalSegment.distanceFromStart);
            int parentSegmentStart = finalSegment.reverseWaySearch ? finalSegment.opposite.getSegmentStart() : finalSegment.opposite.getParentSegmentEnd();
            float parentRoutingTime = -1.0f;
            for (segment = finalSegment.reverseWaySearch ? finalSegment : finalSegment.opposite.getParentRoute(); segment != null; segment = segment.getParentRoute()) {
                RouteSegmentResult res = new RouteSegmentResult(segment.road, parentSegmentStart, segment.getSegmentStart());
                parentRoutingTime = this.calcRoutingTime(parentRoutingTime, finalSegment, segment, res);
                parentSegmentStart = segment.getParentSegmentEnd();
                this.addRouteSegmentToResult(ctx, result, res, false);
            }
            Collections.reverse(result);
            int parentSegmentEnd = finalSegment.reverseWaySearch ? finalSegment.opposite.getParentSegmentEnd() : (int)finalSegment.opposite.getSegmentStart();
            parentRoutingTime = -1.0f;
            for (segment = finalSegment.reverseWaySearch ? finalSegment.opposite.getParentRoute() : finalSegment; segment != null; segment = segment.getParentRoute()) {
                RouteSegmentResult res = new RouteSegmentResult(segment.road, segment.getSegmentStart(), parentSegmentEnd);
                parentRoutingTime = this.calcRoutingTime(parentRoutingTime, finalSegment, segment, res);
                parentSegmentEnd = segment.getParentSegmentEnd();
                this.addRouteSegmentToResult(ctx, result, res, true);
            }
            Collections.reverse(result);
        }
        return result;
    }

    protected void checkTotalRoutingTime(List<RouteSegmentResult> result) {
        float totalRoutingTime = 0.0f;
        for (RouteSegmentResult r : result) {
            totalRoutingTime += r.getRoutingTime();
        }
        RouteResultPreparation.println("Total routing time ! " + totalRoutingTime);
    }

    private float calcRoutingTime(float parentRoutingTime, BinaryRoutePlanner.RouteSegment finalSegment, BinaryRoutePlanner.RouteSegment segment, RouteSegmentResult res) {
        if (segment != finalSegment) {
            if (parentRoutingTime != -1.0f) {
                res.setRoutingTime(parentRoutingTime - segment.distanceFromStart);
            }
            parentRoutingTime = segment.distanceFromStart;
        }
        return parentRoutingTime;
    }

    private void addRouteSegmentToResult(RoutingContext ctx, List<RouteSegmentResult> result, RouteSegmentResult res, boolean reverse) {
        if (res.getStartPointIndex() != res.getEndPointIndex()) {
            if (result.size() > 0) {
                RouteSegmentResult last = result.get(result.size() - 1);
                if (last.getObject().id == res.getObject().id && ctx.calculationMode != RoutePlannerFrontEnd.RouteCalculationMode.BASE && this.combineTwoSegmentResult(res, last, reverse)) {
                    return;
                }
            }
            result.add(res);
        }
    }

    private boolean combineTwoSegmentResult(RouteSegmentResult toAdd, RouteSegmentResult previous, boolean reverse) {
        boolean rd;
        boolean ld = previous.getEndPointIndex() > previous.getStartPointIndex();
        boolean bl = rd = toAdd.getEndPointIndex() > toAdd.getStartPointIndex();
        if (rd == ld) {
            if (toAdd.getStartPointIndex() == previous.getEndPointIndex() && !reverse) {
                previous.setEndPointIndex(toAdd.getEndPointIndex());
                previous.setRoutingTime(previous.getRoutingTime() + toAdd.getRoutingTime());
                return true;
            }
            if (toAdd.getEndPointIndex() == previous.getStartPointIndex() && reverse) {
                previous.setStartPointIndex(toAdd.getStartPointIndex());
                previous.setRoutingTime(previous.getRoutingTime() + toAdd.getRoutingTime());
                return true;
            }
        }
        return false;
    }

    void printResults(RoutingContext ctx, LatLon start, LatLon end, List<RouteSegmentResult> result) {
        float completeTime = 0.0f;
        float completeDistance = 0.0f;
        for (RouteSegmentResult r : result) {
            completeTime += r.getSegmentTime();
            completeDistance += r.getDistance();
        }
        RouteResultPreparation.println("ROUTE : ");
        double startLat = start.getLatitude();
        double startLon = start.getLongitude();
        double endLat = end.getLatitude();
        double endLon = end.getLongitude();
        String msg = MessageFormat.format("<test regions=\"\" description=\"\" best_percent=\"\" vehicle=\"{4}\" \n    start_lat=\"{0}\" start_lon=\"{1}\" target_lat=\"{2}\" target_lon=\"{3}\" {5} >", startLat + "", startLon + "", endLat + "", endLon + "", ctx.config.routerName, "loadedTiles = \"" + ctx.loadedTiles + "\" visitedSegments = \"" + ctx.visitedSegments + "\" complete_distance = \"" + completeDistance + "\" complete_time = \"" + completeTime + "\" routing_time = \"" + ctx.routingTime + "\" ");
        this.log.info((Object)msg);
        RouteResultPreparation.println(msg);
        if (PRINT_TO_CONSOLE_ROUTE_INFORMATION_TO_TEST) {
            for (RouteSegmentResult res : result) {
                String name = res.getObject().getName();
                String ref = res.getObject().getRef();
                if (name == null) {
                    name = "";
                }
                if (ref != null) {
                    name = name + " (" + ref + ") ";
                }
                StringBuilder additional = new StringBuilder();
                additional.append("time = \"").append(res.getSegmentTime()).append("\" ");
                additional.append("rtime = \"").append(res.getRoutingTime()).append("\" ");
                additional.append("name = \"").append(name).append("\" ");
                float ms = res.getObject().getMaximumSpeed(res.isForwardDirection());
                if (ms > 0.0f) {
                    additional.append("maxspeed = \"").append(ms * 3.6f).append("\" ").append(res.getObject().getHighway()).append(" ");
                }
                additional.append("distance = \"").append(res.getDistance()).append("\" ");
                if (res.getTurnType() != null) {
                    additional.append("turn = \"").append(res.getTurnType()).append("\" ");
                    additional.append("turn_angle = \"").append(res.getTurnType().getTurnAngle()).append("\" ");
                    if (res.getTurnType().getLanes() != null) {
                        additional.append("lanes = \"").append(Arrays.toString(res.getTurnType().getLanes())).append("\" ");
                    }
                }
                additional.append("start_bearing = \"").append(res.getBearingBegin()).append("\" ");
                additional.append("end_bearing = \"").append(res.getBearingEnd()).append("\" ");
                additional.append("description = \"").append(res.getDescription()).append("\" ");
                RouteResultPreparation.println(MessageFormat.format("\t<segment id=\"{0}\" start=\"{1}\" end=\"{2}\" {3}/>", res.getObject().getId() + "", res.getStartPointIndex() + "", res.getEndPointIndex() + "", additional.toString()));
                this.printAdditionalPointInfo(res);
            }
        }
        RouteResultPreparation.println("</test>");
    }

    private void printAdditionalPointInfo(RouteSegmentResult res) {
        boolean plus = res.getStartPointIndex() < res.getEndPointIndex();
        int k = res.getStartPointIndex();
        while (k != res.getEndPointIndex()) {
            int[] tp = res.getObject().getPointTypes(k);
            String[] pointNames = res.getObject().getPointNames(k);
            int[] pointNameTypes = res.getObject().getPointNameTypes(k);
            if (tp != null || pointNameTypes != null) {
                BinaryMapRouteReaderAdapter.RouteTypeRule rr;
                int t;
                StringBuilder bld = new StringBuilder();
                bld.append("<point ");
                if (tp != null) {
                    for (t = 0; t < tp.length; ++t) {
                        rr = res.getObject().region.quickGetEncodingRule(tp[t]);
                        bld.append(" " + rr.getTag() + "=\"" + rr.getValue() + "\"");
                    }
                }
                if (pointNameTypes != null) {
                    for (t = 0; t < pointNameTypes.length; ++t) {
                        rr = res.getObject().region.quickGetEncodingRule(pointNameTypes[t]);
                        bld.append(" " + rr.getTag() + "=\"" + pointNames[t] + "\"");
                    }
                }
                bld.append("/>");
                RouteResultPreparation.println("\t" + bld.toString());
            }
            if (plus) {
                ++k;
                continue;
            }
            --k;
        }
    }

    protected void addTurnInfoDescriptions(List<RouteSegmentResult> result) {
        int prevSegment = -1;
        float dist = 0.0f;
        for (int i = 0; i <= result.size(); ++i) {
            if (i == result.size() || result.get(i).getTurnType() != null) {
                if (prevSegment >= 0) {
                    String turn = result.get(prevSegment).getTurnType().toString();
                    int[] lns = result.get(prevSegment).getTurnType().getLanes();
                    if (lns != null) {
                        String s = "[ ";
                        for (int h = 0; h < lns.length; ++h) {
                            int pt;
                            if (h > 0) {
                                s = s + ", ";
                            }
                            if (lns[h] % 2 == 1) {
                                s = s + "+";
                            }
                            if ((pt = TurnType.getPrimaryTurn(lns[h])) == 0) {
                                pt = 1;
                            }
                            s = s + TurnType.valueOf(pt, false).toXmlString();
                            int st = TurnType.getSecondaryTurn(lns[h]);
                            if (st == 0) continue;
                            s = s + ";" + TurnType.valueOf(st, false).toXmlString();
                        }
                        s = s + "]";
                        turn = turn + s;
                    }
                    result.get(prevSegment).setDescription(turn + MessageFormat.format(" and go {0,number,#.##} meters", Float.valueOf(dist)));
                    if (result.get(prevSegment).getTurnType().isSkipToSpeak()) {
                        result.get(prevSegment).setDescription("-*" + result.get(prevSegment).getDescription());
                    }
                }
                prevSegment = i;
                dist = 0.0f;
            }
            if (i >= result.size()) continue;
            dist += result.get(i).getDistance();
        }
    }

    protected TurnType justifyUTurn(boolean leftside, List<RouteSegmentResult> result, int i, TurnType t) {
        TurnType tnext;
        boolean tr;
        boolean tl = 2 == t.getValue();
        boolean bl = tr = 5 == t.getValue();
        if ((tl || tr) && (tnext = result.get(i + 1).getTurnType()) != null && result.get(i).getDistance() < 35.0f) {
            String highway;
            double uTurn;
            boolean ut = true;
            if (i > 0 && Math.abs(uTurn = MapUtils.degreesDiff(result.get(i - 1).getBearingEnd(), result.get(i + 1).getBearingBegin())) < 120.0) {
                ut = false;
            }
            if ((highway = result.get(i).getObject().getHighway()) == null || highway.endsWith("track") || highway.endsWith("services") || highway.endsWith("service") || highway.endsWith("path")) {
                ut = false;
            }
            if (ut) {
                tnext.setSkipToSpeak(true);
                if (tl && 2 == tnext.getValue()) {
                    return TurnType.valueOf(10, false);
                }
                if (tr && 5 == tnext.getValue()) {
                    return TurnType.valueOf(10, true);
                }
            }
        }
        return null;
    }

    private void determineTurnsToMerge(boolean leftside, List<RouteSegmentResult> result) {
        RouteSegmentResult nextSegment = null;
        double dist = 0.0;
        for (int i = result.size() - 1; i >= 0; --i) {
            RouteSegmentResult currentSegment = result.get(i);
            TurnType currentTurn = currentSegment.getTurnType();
            dist += (double)currentSegment.getDistance();
            if (currentTurn == null || currentTurn.getLanes() == null) continue;
            if (nextSegment != null) {
                String hw = currentSegment.getObject().getHighway();
                double mergeDistance = 200.0;
                if (hw != null && (hw.startsWith("trunk") || hw.startsWith("motorway"))) {
                    mergeDistance = 400.0;
                }
                if (dist < mergeDistance) {
                    this.mergeTurnLanes(leftside, currentSegment, nextSegment);
                }
            }
            nextSegment = currentSegment;
            dist = 0.0;
        }
    }

    private void mergeTurnLanes(boolean leftSide, RouteSegmentResult currentSegment, RouteSegmentResult nextSegment) {
        MergeTurnLaneTurn active = new MergeTurnLaneTurn(currentSegment);
        MergeTurnLaneTurn target = new MergeTurnLaneTurn(nextSegment);
        if (active.activeLen < 2) {
            return;
        }
        if (target.activeStartIndex == -1) {
            return;
        }
        boolean changed = false;
        if (target.isActiveTurnMostLeft()) {
            if (target.activeLen <= active.activeLen) {
                active.activeEndIndex -= active.activeLen - target.activeLen;
                changed = true;
            }
        } else if (target.isActiveTurnMostRight()) {
            if (target.activeLen < active.activeLen) {
                active.activeStartIndex += active.activeLen - target.activeLen;
                changed = true;
            }
        } else if (target.activeLen < active.activeLen) {
            float ratio = (float)(active.activeLen - target.activeLen) / 2.0f;
            active.activeEndIndex = (int)Math.ceil((float)active.activeEndIndex - ratio);
            active.activeStartIndex = (int)Math.floor((float)active.activeStartIndex + ratio);
            changed = true;
        }
        if (!changed) {
            return;
        }
        for (int i = 0; i < active.disabledLanes.length; ++i) {
            if (i < active.activeStartIndex || i > active.activeEndIndex) continue;
            int n = i;
            active.disabledLanes[n] = active.disabledLanes[n] | 1;
        }
        TurnType currentTurn = currentSegment.getTurnType();
        currentTurn.setLanes(active.disabledLanes);
        int turn = this.inferTurnFromLanes(active.disabledLanes);
        if (turn != 0 && turn != currentTurn.getValue()) {
            TurnType newTurnType = TurnType.valueOf(turn, leftSide);
            newTurnType.setLanes(active.disabledLanes);
            newTurnType.setSkipToSpeak(currentTurn.isSkipToSpeak());
            currentSegment.setTurnType(newTurnType);
        }
    }

    private int highwaySpeakPriority(String highway) {
        if (highway == null || highway.endsWith("track") || highway.endsWith("services") || highway.endsWith("service") || highway.endsWith("path")) {
            return 5;
        }
        if (highway.endsWith("_link") || highway.endsWith("unclassified") || highway.endsWith("road") || highway.endsWith("living_street") || highway.endsWith("residential")) {
            return 1;
        }
        return 0;
    }

    private TurnType getTurnInfo(List<RouteSegmentResult> result, int i, boolean leftSide) {
        if (i == 0) {
            return TurnType.valueOf(1, false);
        }
        RouteSegmentResult prev = result.get(i - 1);
        if (prev.getObject().roundabout()) {
            return null;
        }
        RouteSegmentResult rr = result.get(i);
        if (rr.getObject().roundabout()) {
            return this.processRoundaboutTurn(result, i, leftSide, prev, rr);
        }
        TurnType t = null;
        if (prev != null) {
            boolean noAttachedRoads = rr.getAttachedRoutes(rr.getStartPointIndex()).size() == 0;
            double mpi = MapUtils.degreesDiff(prev.getBearingEnd(), rr.getBearingBegin());
            if (noAttachedRoads) {
                // empty if block
            }
            if (mpi >= 45.0) {
                t = mpi < 45.0 ? TurnType.valueOf(3, leftSide) : (mpi < 120.0 ? TurnType.valueOf(2, leftSide) : (mpi < 150.0 || leftSide ? TurnType.valueOf(4, leftSide) : TurnType.valueOf(10, leftSide)));
                int[] lanes = this.getTurnLanesInfo(prev, t.getValue());
                t.setLanes(lanes);
            } else if (mpi < -45.0) {
                t = mpi > -45.0 ? TurnType.valueOf(6, leftSide) : (mpi > -120.0 ? TurnType.valueOf(5, leftSide) : (mpi > -150.0 || !leftSide ? TurnType.valueOf(7, leftSide) : TurnType.valueOf(11, leftSide)));
                int[] lanes = this.getTurnLanesInfo(prev, t.getValue());
                t.setLanes(lanes);
            } else {
                t = this.attachKeepLeftInfoAndLanes(leftSide, prev, rr);
            }
            if (t != null) {
                t.setTurnAngle((float)(-mpi));
            }
        }
        return t;
    }

    private int[] getTurnLanesInfo(RouteSegmentResult prevSegm, int mainTurnType) {
        String turnLanes = RouteResultPreparation.getTurnLanesString(prevSegm);
        if (turnLanes == null) {
            return null;
        }
        int[] lanesArray = RouteResultPreparation.calculateRawTurnLanes(turnLanes, mainTurnType);
        boolean isSet = this.setAllowedLanes(mainTurnType, lanesArray);
        if (!isSet && lanesArray.length > 0) {
            boolean leftTurn = TurnType.isLeftTurn(mainTurnType);
            int ind = leftTurn ? 0 : lanesArray.length - 1;
            int tt = TurnType.getPrimaryTurn(lanesArray[ind]);
            if (leftTurn) {
                if (!TurnType.isLeftTurn(tt)) {
                    TurnType.setPrimaryTurnAndReset(lanesArray, ind, 2);
                    TurnType.setSecondaryTurn(lanesArray, ind, tt);
                    int n = ind;
                    lanesArray[n] = lanesArray[n] | 1;
                }
            } else if (!TurnType.isRightTurn(tt)) {
                TurnType.setPrimaryTurnAndReset(lanesArray, ind, 5);
                TurnType.setSecondaryTurn(lanesArray, ind, tt);
                int n = ind;
                lanesArray[n] = lanesArray[n] | 1;
            }
            this.setAllowedLanes(tt, lanesArray);
        }
        return lanesArray;
    }

    protected boolean setAllowedLanes(int mainTurnType, int[] lanesArray) {
        boolean turnSet = false;
        for (int i = 0; i < lanesArray.length; ++i) {
            if (TurnType.getPrimaryTurn(lanesArray[i]) != mainTurnType) continue;
            int n = i;
            lanesArray[n] = lanesArray[n] | 1;
            turnSet = true;
        }
        return turnSet;
    }

    private TurnType processRoundaboutTurn(List<RouteSegmentResult> result, int i, boolean leftSide, RouteSegmentResult prev, RouteSegmentResult rr) {
        int exit = 1;
        RouteSegmentResult last = rr;
        for (int j = i; j < result.size(); ++j) {
            RouteSegmentResult rnext;
            last = rnext = result.get(j);
            if (!rnext.getObject().roundabout()) break;
            boolean plus = rnext.getStartPointIndex() < rnext.getEndPointIndex();
            int k = rnext.getStartPointIndex();
            if (j == i) {
                // empty if block
            }
            while (k != rnext.getEndPointIndex()) {
                int attachedRoads = rnext.getAttachedRoutes(k).size();
                if (attachedRoads > 0) {
                    ++exit;
                }
                k = plus ? k + 1 : k - 1;
            }
        }
        TurnType t = TurnType.getExitTurn(exit, 0.0f, leftSide);
        t.setTurnAngle((float)MapUtils.degreesDiff(last.getBearingBegin(), prev.getBearingEnd()));
        return t;
    }

    private TurnType attachKeepLeftInfoAndLanes(boolean leftSide, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm) {
        List<RouteSegmentResult> attachedRoutes = currentSegm.getAttachedRoutes(currentSegm.getStartPointIndex());
        if (attachedRoutes == null || attachedRoutes.size() == 0) {
            return null;
        }
        RoadSplitStructure rs = this.calculateRoadSplitStructure(prevSegm, currentSegm, attachedRoutes);
        if (rs.roadsOnLeft + rs.roadsOnRight == 0) {
            return null;
        }
        String turnLanes = RouteResultPreparation.getTurnLanesString(prevSegm);
        if (turnLanes != null) {
            return this.createKeepLeftRightTurnBasedOnTurnTypes(rs, prevSegm, currentSegm, turnLanes, leftSide);
        }
        if (rs.keepLeft || rs.keepRight) {
            return this.createSimpleKeepLeftRightTurn(leftSide, prevSegm, currentSegm, rs);
        }
        return null;
    }

    protected TurnType createKeepLeftRightTurnBasedOnTurnTypes(RoadSplitStructure rs, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, String turnLanes, boolean leftSide) {
        TurnType t = TurnType.valueOf(1, leftSide);
        int[] rawLanes = RouteResultPreparation.calculateRawTurnLanes(turnLanes, 1);
        if (rs.keepLeft || rs.keepRight) {
            String[] splitLaneOptions = turnLanes.split("\\|", -1);
            int activeBeginIndex = this.findActiveIndex(rawLanes, splitLaneOptions, rs.leftLanes, true, rs.roadsOnLeft, rs.addRoadsOnLeft);
            int activeEndIndex = this.findActiveIndex(rawLanes, splitLaneOptions, rs.rightLanes, false, rs.roadsOnRight, rs.addRoadsOnRight);
            if (activeBeginIndex == -1 || activeEndIndex == -1 || activeBeginIndex > activeEndIndex) {
                return this.createSimpleKeepLeftRightTurn(leftSide, prevSegm, currentSegm, rs);
            }
            for (int k = 0; k < rawLanes.length; ++k) {
                if (k < activeBeginIndex || k > activeEndIndex) continue;
                int n = k;
                rawLanes[n] = rawLanes[n] | 1;
            }
            int tp = this.inferTurnFromLanes(rawLanes);
            if (tp != t.getValue() && tp != 0) {
                t = TurnType.valueOf(tp, leftSide);
            }
        } else {
            for (int k = 0; k < rawLanes.length; ++k) {
                int turn = rawLanes[k];
                boolean active = false;
                if (TurnType.getPrimaryTurn(turn) == 1) {
                    active = true;
                } else if (TurnType.isRightTurn(turn) && rs.roadsOnRight == 0) {
                    active = true;
                } else if (TurnType.isLeftTurn(turn) && rs.roadsOnLeft == 0) {
                    active = true;
                }
                if (!active) continue;
                int n = k;
                rawLanes[n] = rawLanes[n] | 1;
            }
        }
        t.setSkipToSpeak(!rs.speak);
        t.setLanes(rawLanes);
        return t;
    }

    protected int findActiveIndex(int[] rawLanes, String[] splitLaneOptions, int lanes, boolean left, int roads, int addRoads) {
        int activeStartIndex = -1;
        boolean lookupSlightTurn = addRoads > 0;
        for (int i = 0; i < rawLanes.length; ++i) {
            int ind;
            int n = ind = left ? i : rawLanes.length - i - 1;
            if (!lookupSlightTurn || TurnType.isSlightTurn(TurnType.getPrimaryTurn(rawLanes[ind])) || TurnType.isSlightTurn(TurnType.getSecondaryTurn(rawLanes[ind]))) {
                int cnt = this.countOccurrences(splitLaneOptions[ind], ';') + 1;
                if (cnt > 1) {
                    --roads;
                }
                lanes -= cnt;
                lookupSlightTurn = false;
            }
            if (lanes >= 0 && roads >= 0) continue;
            activeStartIndex = ind;
            break;
        }
        return activeStartIndex;
    }

    protected RoadSplitStructure calculateRoadSplitStructure(RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, List<RouteSegmentResult> attachedRoutes) {
        RoadSplitStructure rs = new RoadSplitStructure();
        int speakPriority = Math.max(this.highwaySpeakPriority(prevSegm.getObject().getHighway()), this.highwaySpeakPriority(currentSegm.getObject().getHighway()));
        for (RouteSegmentResult attached : attachedRoutes) {
            boolean attachedOnTheRight;
            double ex = MapUtils.degreesDiff(attached.getBearingBegin(), currentSegm.getBearingBegin());
            double mpi = Math.abs(MapUtils.degreesDiff(prevSegm.getBearingEnd(), attached.getBearingBegin()));
            int rsSpeakPriority = this.highwaySpeakPriority(attached.getObject().getHighway());
            if (rsSpeakPriority == 5 && speakPriority != 5) continue;
            int lanes = this.countLanesMinOne(attached);
            boolean smallStraightVariation = mpi < 45.0;
            boolean smallTargetVariation = Math.abs(ex) < 45.0;
            boolean bl = attachedOnTheRight = ex >= 0.0;
            if (attachedOnTheRight) {
                ++rs.roadsOnRight;
            } else {
                ++rs.roadsOnLeft;
            }
            if (smallTargetVariation || smallStraightVariation) {
                if (attachedOnTheRight) {
                    rs.keepLeft = true;
                    rs.rightLanes += lanes;
                } else {
                    rs.keepRight = true;
                    rs.leftLanes += lanes;
                }
                rs.speak = rs.speak || rsSpeakPriority <= speakPriority;
                continue;
            }
            if (attachedOnTheRight) {
                ++rs.addRoadsOnRight;
                continue;
            }
            ++rs.addRoadsOnLeft;
        }
        return rs;
    }

    protected TurnType createSimpleKeepLeftRightTurn(boolean leftSide, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, RoadSplitStructure rs) {
        double devation;
        int current = this.countLanesMinOne(currentSegm);
        int ls = current + rs.leftLanes + rs.rightLanes;
        int[] lanes = new int[ls];
        for (int it = 0; it < ls; ++it) {
            lanes[it] = it < rs.leftLanes || it >= rs.leftLanes + current ? 0 : 1;
        }
        if (current <= rs.leftLanes + rs.rightLanes && (rs.leftLanes > 1 || rs.rightLanes > 1)) {
            rs.speak = true;
        }
        boolean makeSlightTurn = (devation = Math.abs(MapUtils.degreesDiff(prevSegm.getBearingEnd(), currentSegm.getBearingBegin()))) > 5.0 && (!this.isMotorway(prevSegm) || !this.isMotorway(currentSegm));
        TurnType t = null;
        if (rs.keepLeft && rs.keepRight) {
            t = TurnType.valueOf(1, leftSide);
        } else if (rs.keepLeft) {
            t = TurnType.valueOf(makeSlightTurn ? 3 : 8, leftSide);
        } else if (rs.keepRight) {
            t = TurnType.valueOf(makeSlightTurn ? 6 : 9, leftSide);
        } else {
            return t;
        }
        t.setSkipToSpeak(!rs.speak);
        t.setLanes(lanes);
        return t;
    }

    protected int countLanesMinOne(RouteSegmentResult attached) {
        String tls;
        boolean oneway = attached.getObject().getOneway() != 0;
        int lns = attached.getObject().getLanes();
        if (lns == 0 && (tls = RouteResultPreparation.getTurnLanesString(attached)) != null) {
            return Math.max(1, this.countOccurrences(tls, '|'));
        }
        if (oneway) {
            return Math.max(1, lns);
        }
        try {
            if (attached.isForwardDirection() && attached.getObject().getValue("lanes:forward") != null) {
                return Integer.parseInt(attached.getObject().getValue("lanes:forward"));
            }
            if (!attached.isForwardDirection() && attached.getObject().getValue("lanes:backward") != null) {
                return Integer.parseInt(attached.getObject().getValue("lanes:backward"));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return Math.max(1, (lns + 1) / 2);
    }

    protected static String getTurnLanesString(RouteSegmentResult segment) {
        if (segment.getObject().getOneway() == 0) {
            if (segment.isForwardDirection()) {
                return segment.getObject().getValue("turn:lanes:forward");
            }
            return segment.getObject().getValue("turn:lanes:backward");
        }
        return segment.getObject().getValue("turn:lanes");
    }

    private int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static int[] parseTurnLanes(RouteDataObject ro, double dirToNorthEastPi) {
        double cmp;
        String turnLanes = null;
        turnLanes = ro.getOneway() == 0 ? (Math.abs(MapUtils.alignAngleDifference(dirToNorthEastPi - (cmp = ro.directionRoute(0, true)))) < 1.5707963267948966 ? ro.getValue("turn:lanes:forward") : ro.getValue("turn:lanes:backward")) : ro.getValue("turn:lanes");
        if (turnLanes == null) {
            return null;
        }
        return RouteResultPreparation.calculateRawTurnLanes(turnLanes, 0);
    }

    public static int[] parseLanes(RouteDataObject ro, double dirToNorthEastPi) {
        int lns = 0;
        try {
            if (ro.getOneway() == 0) {
                double cmp = ro.directionRoute(0, true);
                if (Math.abs(MapUtils.alignAngleDifference(dirToNorthEastPi - cmp)) < 1.5707963267948966) {
                    if (ro.getValue("lanes:forward") != null) {
                        lns = Integer.parseInt(ro.getValue("lanes:forward"));
                    }
                } else if (ro.getValue("lanes:backward") != null) {
                    lns = Integer.parseInt(ro.getValue("lanes:backward"));
                }
                if (lns == 0 && ro.getValue("lanes") != null) {
                    lns = Integer.parseInt(ro.getValue("lanes")) / 2;
                }
            } else {
                lns = Integer.parseInt(ro.getValue("lanes"));
            }
            if (lns > 0) {
                return new int[lns];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static int[] calculateRawTurnLanes(String turnLanes, int calcTurnType) {
        String[] splitLaneOptions = turnLanes.split("\\|", -1);
        int[] lanes = new int[splitLaneOptions.length];
        block0: for (int i = 0; i < splitLaneOptions.length; ++i) {
            String[] laneOptions = splitLaneOptions[i].split(";");
            for (int j = 0; j < laneOptions.length; ++j) {
                int turn;
                if (laneOptions[j].equals("none") || laneOptions[j].equals("through")) {
                    turn = 1;
                } else if (laneOptions[j].equals("slight_right")) {
                    turn = 6;
                } else if (laneOptions[j].equals("slight_left")) {
                    turn = 3;
                } else if (laneOptions[j].equals("right")) {
                    turn = 5;
                } else if (laneOptions[j].equals("left")) {
                    turn = 2;
                } else if (laneOptions[j].equals("sharp_right")) {
                    turn = 7;
                } else if (laneOptions[j].equals("sharp_left")) {
                    turn = 4;
                } else {
                    if (!laneOptions[j].equals("reverse")) continue;
                    turn = 10;
                }
                int primary = TurnType.getPrimaryTurn(lanes[i]);
                if (primary == 0) {
                    TurnType.setPrimaryTurnAndReset(lanes, i, turn);
                    continue;
                }
                if (turn == calcTurnType || TurnType.isRightTurn(calcTurnType) && TurnType.isRightTurn(turn) || TurnType.isLeftTurn(calcTurnType) && TurnType.isLeftTurn(turn)) {
                    TurnType.setPrimaryTurnAndReset(lanes, i, turn);
                    TurnType.setSecondaryTurn(lanes, i, primary);
                    continue block0;
                }
                TurnType.setSecondaryTurn(lanes, i, turn);
                continue block0;
            }
        }
        return lanes;
    }

    private int inferTurnFromLanes(int[] oLanes) {
        int i;
        TIntHashSet possibleTurns = new TIntHashSet();
        for (i = 0; i < oLanes.length; ++i) {
            if ((oLanes[i] & 1) == 0) continue;
            if (possibleTurns.isEmpty()) {
                possibleTurns.add(TurnType.getPrimaryTurn(oLanes[i]));
                if (TurnType.getSecondaryTurn(oLanes[i]) == 0) continue;
                possibleTurns.add(TurnType.getSecondaryTurn(oLanes[i]));
                continue;
            }
            TIntArrayList laneTurns = new TIntArrayList();
            laneTurns.add(TurnType.getPrimaryTurn(oLanes[i]));
            if (TurnType.getSecondaryTurn(oLanes[i]) != 0) {
                laneTurns.add(TurnType.getSecondaryTurn(oLanes[i]));
            }
            possibleTurns.retainAll((TIntCollection)laneTurns);
            if (!possibleTurns.isEmpty()) continue;
            return 0;
        }
        for (i = 0; i < oLanes.length; ++i) {
            if ((oLanes[i] & 1) != 0 || possibleTurns.isEmpty()) continue;
            possibleTurns.remove(Integer.valueOf(TurnType.getPrimaryTurn(oLanes[i])).intValue());
            if (TurnType.getSecondaryTurn(oLanes[i]) == 0) continue;
            possibleTurns.remove(Integer.valueOf(TurnType.getSecondaryTurn(oLanes[i])).intValue());
        }
        if (possibleTurns.size() == 1) {
            int infer = possibleTurns.iterator().next();
            for (int i2 = 0; i2 < oLanes.length; ++i2) {
                if (TurnType.getSecondaryTurn(oLanes[i2]) != infer) continue;
                int pt = TurnType.getPrimaryTurn(oLanes[i2]);
                int en = oLanes[i2] & 1;
                TurnType.setPrimaryTurnAndReset(oLanes, i2, infer);
                int n = i2;
                oLanes[n] = oLanes[n] | en;
                TurnType.setSecondaryTurn(oLanes, i2, pt);
            }
            return infer;
        }
        return 0;
    }

    private boolean isMotorway(RouteSegmentResult s) {
        String h = s.getObject().getHighway();
        return "motorway".equals(h) || "motorway_link".equals(h) || "trunk".equals(h) || "trunk_link".equals(h);
    }

    private void attachRoadSegments(RoutingContext ctx, List<RouteSegmentResult> result, int routeInd, int pointInd, boolean plus) throws IOException {
        Iterator<BinaryRoutePlanner.RouteSegment> it;
        RouteSegmentResult rr = result.get(routeInd);
        RouteDataObject road = rr.getObject();
        long nextL = pointInd < road.getPointsLength() - 1 ? this.getPoint(road, pointInd + 1) : 0L;
        long prevL = pointInd > 0 ? this.getPoint(road, pointInd - 1) : 0L;
        RouteSegmentResult previousResult = null;
        long previousRoadId = road.getId();
        if (pointInd == rr.getStartPointIndex() && routeInd > 0 && (previousRoadId = (previousResult = result.get(routeInd - 1)).getObject().getId()) != road.getId()) {
            if (previousResult.getStartPointIndex() < previousResult.getEndPointIndex() && previousResult.getEndPointIndex() < previousResult.getObject().getPointsLength() - 1) {
                rr.attachRoute(pointInd, new RouteSegmentResult(previousResult.getObject(), previousResult.getEndPointIndex(), previousResult.getObject().getPointsLength() - 1));
            } else if (previousResult.getStartPointIndex() > previousResult.getEndPointIndex() && previousResult.getEndPointIndex() > 0) {
                rr.attachRoute(pointInd, new RouteSegmentResult(previousResult.getObject(), previousResult.getEndPointIndex(), 0));
            }
        }
        if (rr.getPreAttachedRoutes(pointInd) != null) {
            final RouteSegmentResult[] list = rr.getPreAttachedRoutes(pointInd);
            it = new Iterator<BinaryRoutePlanner.RouteSegment>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < list.length;
                }

                @Override
                public BinaryRoutePlanner.RouteSegment next() {
                    RouteSegmentResult r = list[this.i++];
                    return new BinaryRoutePlanner.RouteSegment(r.getObject(), r.getStartPointIndex());
                }

                @Override
                public void remove() {
                }
            };
        } else {
            BinaryRoutePlanner.RouteSegment rt = ctx.loadRouteSegment(road.getPoint31XTile(pointInd), road.getPoint31YTile(pointInd), ctx.config.memoryLimitation);
            Iterator<BinaryRoutePlanner.RouteSegment> iterator = it = rt == null ? null : rt.getIterator();
        }
        while (it != null && it.hasNext()) {
            long pointL;
            BinaryRoutePlanner.RouteSegment routeSegment = (BinaryRoutePlanner.RouteSegment)it.next();
            if (routeSegment.road.getId() == road.getId() || routeSegment.road.getId() == previousRoadId) continue;
            RouteDataObject addRoad = routeSegment.road;
            this.checkAndInitRouteRegion(ctx, addRoad);
            int oneWay = ctx.getRouter().isOneWay(addRoad);
            if (oneWay >= 0 && routeSegment.getSegmentStart() < addRoad.getPointsLength() - 1 && (pointL = this.getPoint(addRoad, routeSegment.getSegmentStart() + 1)) != nextL && pointL != prevL) {
                rr.attachRoute(pointInd, new RouteSegmentResult(addRoad, routeSegment.getSegmentStart(), addRoad.getPointsLength() - 1));
            }
            if (oneWay > 0 || routeSegment.getSegmentStart() <= 0 || (pointL = this.getPoint(addRoad, routeSegment.getSegmentStart() - 1)) == nextL || pointL == prevL) continue;
            rr.attachRoute(pointInd, new RouteSegmentResult(addRoad, routeSegment.getSegmentStart(), 0));
        }
    }

    private static void println(String logMsg) {
        System.out.println(logMsg);
    }

    private long getPoint(RouteDataObject road, int pointInd) {
        return ((long)road.getPoint31XTile(pointInd) << 31) + (long)road.getPoint31YTile(pointInd);
    }

    private static double measuredDist(int x1, int y1, int x2, int y2) {
        return MapUtils.getDistance(MapUtils.get31LatitudeY(y1), MapUtils.get31LongitudeX(x1), MapUtils.get31LatitudeY(y2), MapUtils.get31LongitudeX(x2));
    }

    private class RoadSplitStructure {
        boolean keepLeft = false;
        boolean keepRight = false;
        boolean speak = false;
        int leftLanes = 0;
        int rightLanes = 0;
        int roadsOnLeft = 0;
        int addRoadsOnLeft = 0;
        int roadsOnRight = 0;
        int addRoadsOnRight = 0;

        private RoadSplitStructure() {
        }
    }

    private class MergeTurnLaneTurn {
        TurnType turn;
        int[] originalLanes;
        int[] disabledLanes;
        int activeStartIndex = -1;
        int activeEndIndex = -1;
        int activeLen = 0;

        public MergeTurnLaneTurn(RouteSegmentResult segment) {
            this.turn = segment.getTurnType();
            if (this.turn != null) {
                this.originalLanes = this.turn.getLanes();
            }
            if (this.originalLanes != null) {
                this.disabledLanes = new int[this.originalLanes.length];
                for (int i = 0; i < this.originalLanes.length; ++i) {
                    int ln = this.originalLanes[i];
                    this.disabledLanes[i] = ln & 0xFFFFFFFE;
                    if ((ln & 1) <= 0) continue;
                    if (this.activeStartIndex == -1) {
                        this.activeStartIndex = i;
                    }
                    this.activeEndIndex = i;
                    ++this.activeLen;
                }
            }
        }

        public boolean isActiveTurnMostLeft() {
            return this.activeStartIndex == 0;
        }

        public boolean isActiveTurnMostRight() {
            return this.activeEndIndex == this.originalLanes.length - 1;
        }
    }
}

