/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GTileStack
extends AbstractTextBlock
implements GTile {
    private final List<GTile> tiles;
    private final double space;

    public GTileStack(List<GTile> tiles, double space) {
        this.tiles = tiles;
        this.space = space;
        if (tiles.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        for (GTile tile : this.tiles) {
            tile.drawU(ug);
            GTileGeometry dim = tile.calculateDimension(ug.getStringBounder());
            ug = ug.apply(UTranslate.dy(((Dimension2D)dim).getHeight() + this.space));
        }
    }

    @Override
    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        double delta = 0.0;
        ArrayList<Double> wests = new ArrayList<Double>();
        for (GTile tile : this.tiles) {
            GTileGeometry dim = tile.calculateDimension(stringBounder);
            wests.add(delta + dim.getWestPositions().get(0));
            height += dim.getHeight();
            delta += dim.getHeight() + this.space;
            width = Math.max(width, dim.getWidth());
        }
        return new GTileGeometry(width, height += (double)(this.tiles.size() - 1) * this.space, wests);
    }
}

