info = {
    "name": "zh-Hans",
    "date_order": "YMD",
    "january": [
        "一月",
        "1月"
    ],
    "february": [
        "二月",
        "2月"
    ],
    "march": [
        "三月",
        "3月"
    ],
    "april": [
        "四月",
        "4月"
    ],
    "may": [
        "五月",
        "5月"
    ],
    "june": [
        "六月",
        "6月"
    ],
    "july": [
        "七月",
        "7月"
    ],
    "august": [
        "八月",
        "8月"
    ],
    "september": [
        "九月",
        "9月"
    ],
    "october": [
        "十月",
        "10月"
    ],
    "november": [
        "十一月",
        "11月"
    ],
    "december": [
        "十二月",
        "12月"
    ],
    "monday": [
        "星期一",
        "周一"
    ],
    "tuesday": [
        "星期二",
        "周二"
    ],
    "wednesday": [
        "星期三",
        "周三"
    ],
    "thursday": [
        "星期四",
        "周四"
    ],
    "friday": [
        "星期五",
        "周五"
    ],
    "saturday": [
        "星期六",
        "周六"
    ],
    "sunday": [
        "星期日",
        "周日"
    ],
    "am": [
        "上午"
    ],
    "pm": [
        "下午"
    ],
    "year": [
        "年"
    ],
    "month": [
        "月"
    ],
    "week": [
        "周"
    ],
    "day": [
        "日"
    ],
    "hour": [
        "小时"
    ],
    "minute": [
        "分钟",
        "分"
    ],
    "second": [
        "秒"
    ],
    "relative-type": {
        "1 year ago": [
            "去年"
        ],
        "0 year ago": [
            "今年"
        ],
        "in 1 year": [
            "明年"
        ],
        "1 month ago": [
            "上个月"
        ],
        "0 month ago": [
            "本月"
        ],
        "in 1 month": [
            "下个月"
        ],
        "1 week ago": [
            "上周"
        ],
        "0 week ago": [
            "本周"
        ],
        "in 1 week": [
            "下周"
        ],
        "1 day ago": [
            "昨天"
        ],
        "0 day ago": [
            "今天"
        ],
        "in 1 day": [
            "明天"
        ],
        "0 hour ago": [
            "这一时间 / 此时"
        ],
        "0 minute ago": [
            "此刻"
        ],
        "0 second ago": [
            "现在"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+)年后"
        ],
        "\\1 year ago": [
            "(\\d+)年前"
        ],
        "in \\1 month": [
            "(\\d+)个月后"
        ],
        "\\1 month ago": [
            "(\\d+)个月前"
        ],
        "in \\1 week": [
            "(\\d+)周后"
        ],
        "\\1 week ago": [
            "(\\d+)周前"
        ],
        "in \\1 day": [
            "(\\d+)天后"
        ],
        "\\1 day ago": [
            "(\\d+)天前"
        ],
        "in \\1 hour": [
            "(\\d+)小时后"
        ],
        "\\1 hour ago": [
            "(\\d+)小时前"
        ],
        "in \\1 minute": [
            "(\\d+)分钟后"
        ],
        "\\1 minute ago": [
            "(\\d+)分钟前"
        ],
        "in \\1 second": [
            "(\\d+)秒钟后",
            "(\\d+)秒后"
        ],
        "\\1 second ago": [
            "(\\d+)秒钟前",
            "(\\d+)秒前"
        ]
    },
    "locale_specific": {
        "zh-Hans-SG": {
            "name": "zh-Hans-SG",
            "date_order": "DMY"
        },
        "zh-Hans-HK": {
            "name": "zh-Hans-HK",
            "date_order": "DMY"
        },
        "zh-Hans-MO": {
            "name": "zh-Hans-MO",
            "date_order": "DMY"
        }
    },
    "no_word_spacing": "True",
    "sentence_splitter_group": 4,
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
