/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantDirectWebRemotingQuery
extends VariantAbstractRPCQuery {
    public static final String DWR_CONTENT_TYPE = "text/plain";
    private static final Pattern patternIgnoreScriptName = Pattern.compile("c[0-9]+-scriptName", 2);
    private static final Pattern patternIgnoreMethodName = Pattern.compile("c[0-9]+-methodName", 2);
    private static final Pattern patternIgnoreArray = Pattern.compile("Array:\\[.*\\]", 2);
    private static final Pattern patternIgnoreObject = Pattern.compile("Object_Object:\\{.*\\}", 2);
    private static final Pattern patternNumberValue = Pattern.compile("number:.+", 2);
    private static final Pattern patternStringValue = Pattern.compile("string:.*", 2);
    private static final Pattern patternBooleanValue = Pattern.compile("boolean:.+", 2);
    private static final Pattern patternNullValue = Pattern.compile("null:null", 2);

    @Override
    public boolean isValidContentType(String contentType) {
        return contentType.startsWith(DWR_CONTENT_TYPE);
    }

    @Override
    public String getEscapedValue(String value, boolean toQuote) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    @Override
    public String getUnescapedValue(String value) {
        return StringEscapeUtils.unescapeJava((String)value);
    }

    @Override
    public void parseContent(String content) {
        int offie = content.indexOf("\n");
        int accumulatedOffset = 0;
        while (offie > 0) {
            String paramString = content.substring(0, offie);
            String[] paramDetails = paramString.split("=", 2);
            if (!patternIgnoreScriptName.matcher(paramDetails[0]).matches() && !patternIgnoreMethodName.matcher(paramDetails[0]).matches() && paramDetails.length == 2) {
                if (paramDetails[1] == null) {
                    paramDetails[1] = "";
                }
                if (!patternIgnoreArray.matcher(paramDetails[1]).matches() && !patternIgnoreObject.matcher(paramDetails[1]).matches()) {
                    int valueOffset = 0;
                    String paramValue = paramDetails[1];
                    if (patternNumberValue.matcher(paramDetails[1]).matches() || patternStringValue.matcher(paramDetails[1]).matches() || patternBooleanValue.matcher(paramDetails[1]).matches() || patternNullValue.matcher(paramDetails[1]).matches()) {
                        valueOffset = paramDetails[1].indexOf(":") + 1;
                        paramValue = paramDetails[1].substring(valueOffset);
                    }
                    int beginOffset = accumulatedOffset + paramDetails[0].length() + 1 + valueOffset;
                    int endOffset = accumulatedOffset + offie;
                    this.addParameter(paramDetails[0], beginOffset, endOffset, false, paramValue);
                }
            }
            accumulatedOffset += 1 + offie;
            content = content.substring(offie + 1);
            offie = content.indexOf("\n");
        }
    }
}

