/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.extension.custompages.CustomPageMatcherLocation;
import org.zaproxy.zap.utils.Enableable;

public class DefaultCustomPage
extends Enableable
implements CustomPage {
    private static final String FIELD_SEPARATOR = ";";
    private static final Logger LOGGER = LogManager.getLogger(DefaultCustomPage.class);
    private int contextId;
    private String pageMatcher;
    private CustomPageMatcherLocation pageMatcherLocation;
    private boolean regex;
    private CustomPage.Type type;
    private Pattern pattern;

    public DefaultCustomPage(int contextId, String pageMatcher, CustomPageMatcherLocation pageMatcherLocation, boolean regex, CustomPage.Type type, boolean enabled) {
        this.contextId = contextId;
        this.pageMatcher = pageMatcher;
        this.pageMatcherLocation = pageMatcherLocation;
        this.regex = regex;
        this.type = type;
        this.setEnabled(enabled);
    }

    public DefaultCustomPage(int contextId, String pageMatcher, int pageMatcherLocationID, boolean regex, CustomPage.Type type, boolean enabled) {
        this.contextId = contextId;
        this.pageMatcher = pageMatcher;
        this.pageMatcherLocation = CustomPageMatcherLocation.getCustomPagePageMatcherLocationWithId(pageMatcherLocationID);
        this.regex = regex;
        this.type = type;
        this.setEnabled(enabled);
    }

    @Override
    public int getContextId() {
        return this.contextId;
    }

    @Override
    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public String getPageMatcher() {
        return this.pageMatcher;
    }

    @Override
    public void setPageMatcher(String pageMatcher) {
        this.pageMatcher = pageMatcher;
    }

    @Override
    public CustomPageMatcherLocation getPageMatcherLocation() {
        return this.pageMatcherLocation;
    }

    @Override
    public void setPageMatcherLocation(CustomPageMatcherLocation cppmt) {
        this.pageMatcherLocation = cppmt;
    }

    @Override
    public boolean isRegex() {
        return this.regex;
    }

    @Override
    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    @Override
    public CustomPage.Type getType() {
        return this.type;
    }

    @Override
    public void setType(CustomPage.Type cpt) {
        this.type = cpt;
    }

    @Override
    public boolean isCustomPage(HttpMessage msg, CustomPage.Type cpt) {
        if (this.isEnabled() && this.getType() == cpt) {
            String value = this.getPageMatcherByType(msg);
            return this.matchByLocation(value);
        }
        return false;
    }

    private String getPageMatcherByType(HttpMessage msg) {
        if (CustomPageMatcherLocation.URL.equals((Object)this.getPageMatcherLocation())) {
            return msg.getRequestHeader().getURI().toString();
        }
        if (CustomPageMatcherLocation.RESPONSE_CONTENT.equals((Object)this.getPageMatcherLocation())) {
            return DefaultCustomPage.getHttpMessageAsString(msg);
        }
        LOGGER.error("Could not get page matcher for the given message, with: " + (Object)((Object)this.getPageMatcherLocation()));
        return "";
    }

    private boolean matchByLocation(String value) {
        if (this.isRegex()) {
            return this.isRegexMatch(this.pageMatcher, value);
        }
        return CustomPageMatcherLocation.URL.equals((Object)this.getPageMatcherLocation()) ? value.equals(this.getPageMatcher()) : value.contains(this.getPageMatcher());
    }

    private static String getHttpMessageAsString(HttpMessage msg) {
        return msg.getResponseHeader().toString() + msg.getResponseBody().toString();
    }

    private boolean isRegexMatch(String pageMatcher, String toMatch) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(pageMatcher);
        }
        return this.pattern.matcher(toMatch).find();
    }

    public String toString() {
        StringBuilder cp = new StringBuilder();
        cp.append("ContextId: ").append(this.getContextId());
        cp.append(", Content: ").append(this.getPageMatcher()).append(".");
        cp.append(", Content Type: ").append(this.getPageMatcherLocation().getName());
        cp.append(", Is RegEx: ").append(this.isRegex());
        cp.append(", Type: ").append(this.getType().getName());
        cp.append(", IsEnabled: ").append(this.isEnabled());
        return cp.toString();
    }

    public static String encode(CustomPage cp) {
        StringBuilder encodedCP = new StringBuilder();
        String matcherComponent = cp.getPageMatcher() != null ? cp.getPageMatcher() : "";
        encodedCP.append(new String(Base64.getEncoder().encode(matcherComponent.getBytes(StandardCharsets.UTF_8)), StandardCharsets.US_ASCII)).append(FIELD_SEPARATOR);
        encodedCP.append(cp.getPageMatcherLocation().getId()).append(FIELD_SEPARATOR);
        encodedCP.append(cp.isRegex()).append(FIELD_SEPARATOR);
        encodedCP.append(cp.getType().getId()).append(FIELD_SEPARATOR);
        encodedCP.append(cp.isEnabled()).append(FIELD_SEPARATOR);
        return encodedCP.toString();
    }

    protected static DefaultCustomPage decode(int contextId, String encodedString) {
        String[] pieces = encodedString.split(FIELD_SEPARATOR, -1);
        DefaultCustomPage defaultCustomPage = null;
        try {
            defaultCustomPage = new DefaultCustomPage(contextId, new String(Base64.getDecoder().decode(pieces[0]), StandardCharsets.UTF_8), CustomPageMatcherLocation.getCustomPagePageMatcherLocationWithId(Integer.parseInt(pieces[1])), Boolean.parseBoolean(pieces[2]), CustomPage.Type.getCustomPageTypeWithId(Integer.parseInt(pieces[3])), Boolean.parseBoolean(pieces[4]));
        }
        catch (Exception ex) {
            LOGGER.error("An error occured while decoding DefaultCustomPage from: " + encodedString, (Throwable)ex);
            return null;
        }
        return defaultCustomPage;
    }
}

