/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Arrays;
import org.hsqldb.Expression;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;

public class GroupSet {
    Expression[] groupExpressions;
    HsqlArrayList sets = new HsqlArrayList();
    int nullSets = 0;
    boolean isDistinctGroups;

    public GroupSet(Expression[] expressionArray, boolean bl) {
        this.groupExpressions = expressionArray;
        this.isDistinctGroups = bl;
    }

    public Iterator getIterator() {
        return this.sets.iterator();
    }

    public int isGrouped(HsqlList hsqlList, Expression expression) {
        int n = 0;
        if (hsqlList == null) {
            return (1 << expression.nodes.length) - 1;
        }
        for (int i = 0; i < expression.nodes.length; ++i) {
            n <<= 1;
            int n2 = expression.nodes[i].columnIndex;
            if (hsqlList.contains(n2)) continue;
            ++n;
        }
        return n;
    }

    public void process() {
        HsqlArrayList hsqlArrayList = this.evaluate(this.groupExpressions);
        Iterator iterator = hsqlArrayList.iterator();
        block0: while (iterator.hasNext()) {
            HsqlList hsqlList = (HsqlList)iterator.next();
            if (hsqlList.isEmpty()) {
                if (this.isDistinctGroups) {
                    this.nullSets = 1;
                    continue;
                }
                ++this.nullSets;
                continue;
            }
            if (this.isDistinctGroups) {
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                orderedHashSet.addAll(hsqlList);
                for (int i = 0; i < this.sets.size(); ++i) {
                    HsqlList hsqlList2 = (HsqlList)this.sets.get(i);
                    if (hsqlList2.size() == orderedHashSet.size() && orderedHashSet.containsAll(hsqlList2)) continue block0;
                }
                hsqlList = orderedHashSet;
            }
            this.sets.add(hsqlList);
        }
    }

    private int getColumnIndex(Expression expression) {
        return expression.resultTableColumnIndex;
    }

    private HsqlArrayList evaluate(Expression expression) {
        if (expression.opType == 0) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(new HsqlArrayList());
            return hsqlArrayList;
        }
        Expression[] expressionArray = expression.nodes;
        if (expressionArray.length == 0 || expression.opType != 26 && expression.opType != 25) {
            expressionArray = new Expression[]{expression};
        }
        switch (expression.groupingType) {
            case 61: {
                return this.powerSet(expressionArray);
            }
            case 256: {
                return this.rollUp(expressionArray);
            }
            case 532: {
                return this.grouping(expressionArray);
            }
        }
        if (expression.nodes.length == 0) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList2.add(this.getColumnIndex(expression));
            hsqlArrayList.add(hsqlArrayList2);
            return hsqlArrayList;
        }
        return this.evaluate(expression.nodes);
    }

    private HsqlArrayList evaluate(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (expressionArray.length == 0) {
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList.add(hsqlArrayList2);
            return hsqlArrayList;
        }
        HsqlArrayList hsqlArrayList3 = this.evaluate(expressionArray[0]);
        HsqlArrayList hsqlArrayList4 = this.evaluate(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList4.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList5 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList3.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList6 = new HsqlArrayList();
                HsqlArrayList hsqlArrayList7 = (HsqlArrayList)iterator2.next();
                hsqlArrayList6.addAll(hsqlArrayList7);
                hsqlArrayList6.addAll(hsqlArrayList5);
                hsqlArrayList.add(hsqlArrayList6);
            }
        }
        return hsqlArrayList;
    }

    private HsqlArrayList powerSet(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2;
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            hsqlArrayList3.add(new HsqlArrayList());
            return hsqlArrayList3;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = this.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(this.getColumnIndex(expressionArray[0]));
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = this.powerSet(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList2.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList4 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList5 = new HsqlArrayList();
                HsqlArrayList hsqlArrayList6 = (HsqlArrayList)iterator2.next();
                hsqlArrayList5.addAll(hsqlArrayList4);
                hsqlArrayList5.addAll(hsqlArrayList6);
                if (hsqlArrayList5.isEmpty()) continue;
                hsqlArrayList3.add(hsqlArrayList5);
            }
        }
        hsqlArrayList3.addAll(hsqlArrayList);
        return hsqlArrayList3;
    }

    private HsqlArrayList rollUp(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2;
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            hsqlArrayList3.add(new HsqlArrayList());
            return hsqlArrayList3;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = this.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            hsqlArrayList.add(this.getColumnIndex(expressionArray[0]));
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = this.rollUp(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        Iterator iterator = hsqlArrayList.iterator();
        while (iterator.hasNext()) {
            HsqlArrayList hsqlArrayList4 = (HsqlArrayList)iterator.next();
            Iterator iterator2 = hsqlArrayList2.iterator();
            while (iterator2.hasNext()) {
                HsqlArrayList hsqlArrayList5 = (HsqlArrayList)iterator2.next();
                HsqlArrayList hsqlArrayList6 = new HsqlArrayList();
                hsqlArrayList6.addAll(hsqlArrayList5);
                hsqlArrayList6.addAll(hsqlArrayList4);
                hsqlArrayList3.add(hsqlArrayList6);
            }
        }
        hsqlArrayList3.add(new HsqlArrayList());
        return hsqlArrayList3;
    }

    private HsqlArrayList grouping(Expression[] expressionArray) {
        HsqlArrayList hsqlArrayList;
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        if (expressionArray.length == 0) {
            return hsqlArrayList2;
        }
        if (expressionArray[0].nodes.length != 0 && (expressionArray[0].opType == 26 || expressionArray[0].opType == 25)) {
            hsqlArrayList2 = this.evaluate(expressionArray[0]);
        } else {
            hsqlArrayList2 = new HsqlArrayList();
            hsqlArrayList = new HsqlArrayList();
            if (expressionArray[0].opType != 0) {
                hsqlArrayList.add(this.getColumnIndex(expressionArray[0]));
            }
            hsqlArrayList2.add(hsqlArrayList);
        }
        hsqlArrayList = this.grouping(Arrays.copyOfRange(expressionArray, 1, expressionArray.length));
        hsqlArrayList2.addAll(hsqlArrayList);
        return hsqlArrayList2;
    }
}

